/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.roundtrip;

import com.lunarclient.apollo.async.future.UncertainFuture;
import com.lunarclient.apollo.roundtrip.ApolloRequest;
import com.lunarclient.apollo.roundtrip.ApolloResponse;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ApolloRoundtripManager {
    private final Map<UUID, UncertainFuture<ApolloResponse>> listeners = new ConcurrentHashMap<UUID, UncertainFuture<ApolloResponse>>();
    private final ScheduledThreadPoolExecutor timeoutExecutor = new ScheduledThreadPoolExecutor(1);

    public void handleResponse(ApolloResponse response) {
        UncertainFuture<ApolloResponse> future = this.listeners.remove(response.getPacketId());
        if (future != null) {
            future.handleSuccess(response);
        }
    }

    public <T extends ApolloResponse> void registerListener(ApolloRequest<T> request, UncertainFuture<T> future) {
        UUID packetId = request.getRequestId();
        this.timeoutExecutor.schedule(() -> {
            try {
                UncertainFuture<ApolloResponse> listener = this.listeners.remove(packetId);
                if (listener != null) {
                    Throwable error = new Throwable("Timeout exceeded!");
                    future.handleFailure(error);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, 5000L, TimeUnit.MILLISECONDS);
        this.listeners.put(packetId, future);
    }
}

