/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.stats;

import com.lunarclient.apollo.Apollo;
import com.lunarclient.apollo.ApolloManager;
import com.lunarclient.apollo.ApolloPlatform;
import com.lunarclient.apollo.api.ApolloHttpManager;
import com.lunarclient.apollo.api.request.ServerStartRequest;
import com.lunarclient.apollo.module.ApolloModule;
import com.lunarclient.apollo.option.Option;
import com.lunarclient.apollo.option.Options;
import com.lunarclient.apollo.option.SimpleOption;
import com.lunarclient.apollo.stats.ApolloStats;
import com.lunarclient.apollo.stats.ApolloStatsThread;
import io.leangen.geantyref.TypeToken;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public final class ApolloStatsManager {
    public static final String SESSION_ID = UUID.randomUUID().toString();
    private static final String CONFIG_PREFIX = "mcstats";
    public static final SimpleOption<Boolean> SEND_STATS = ((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)Option.builder().comment("Set to 'true' to send statistics to MCStats, otherwise 'false'.")).node("mcstats", "send-stats")).type(TypeToken.get(Boolean.class))).defaultValue(true)).build();
    public static final SimpleOption<UUID> INSTALLATION_ID = ((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)Option.builder().comment("Your server's installation id used for stats.")).node("mcstats", "installation-id")).type(TypeToken.get(UUID.class))).defaultValue(UUID.randomUUID())).build();
    public static final SimpleOption<Boolean> SERVER_STATISTICS = ((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)Option.builder().comment("Set to 'true' to send your minecraft server statistics to MCStats, otherwise 'false'.")).node("mcstats", "server-statistics")).type(TypeToken.get(Boolean.class))).defaultValue(true)).build();
    public static final SimpleOption<Boolean> SOFTWARE_INFORMATION = ((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)Option.builder().comment("Set to 'true' to send your server software information to MCStats, otherwise 'false'.")).node("mcstats", "software-information")).type(TypeToken.get(Boolean.class))).defaultValue(true)).build();
    public static final SimpleOption<Boolean> HARDWARE_INFORMATION = ((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)Option.builder().comment("Set to 'true' to send your server hardware information to MCStats, otherwise 'false'.")).node("mcstats", "hardware-information")).type(TypeToken.get(Boolean.class))).defaultValue(true)).build();
    public static final SimpleOption<Boolean> HEARTBEAT_PERFORMANCE = ((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)Option.builder().comment("Set to 'true' to send your server cpu and ram usage to MCStats, otherwise 'false'.")).node("mcstats", "performance")).type(TypeToken.get(Boolean.class))).defaultValue(true)).build();
    public static final SimpleOption<Boolean> HEARTBEAT_COUNTS = ((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)Option.builder().comment("Set to 'true' to send your server player count to MCStats, otherwise 'false'.")).node("mcstats", "counts")).type(TypeToken.get(Boolean.class))).defaultValue(true)).build();
    public static final SimpleOption<Boolean> HEARTBEAT_USER_METADATA = ((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)Option.builder().comment("Set to 'true' to send players user metadata to MCStats, otherwise 'false'.")).node("mcstats", "user-metadata")).type(TypeToken.get(Boolean.class))).defaultValue(true)).build();

    public ApolloStatsManager() {
        ApolloManager.registerOptions(SEND_STATS, INSTALLATION_ID, SERVER_STATISTICS, HARDWARE_INFORMATION, SOFTWARE_INFORMATION, HEARTBEAT_PERFORMANCE, HEARTBEAT_COUNTS, HEARTBEAT_USER_METADATA);
    }

    public void enable() {
        this.handleServerStartStats();
        new ApolloStatsThread();
    }

    private void handleServerStartStats() {
        ServerStartRequest request = null;
        try {
            ApolloPlatform platform = Apollo.getPlatform();
            Options options = platform.getOptions();
            if (!((Boolean)options.get(SEND_STATS)).booleanValue()) {
                return;
            }
            boolean serverStatistics = (Boolean)options.get(SERVER_STATISTICS);
            boolean softwareInformation = (Boolean)options.get(SOFTWARE_INFORMATION);
            boolean hardwareInformation = (Boolean)options.get(HARDWARE_INFORMATION);
            if (!(serverStatistics || softwareInformation || hardwareInformation)) {
                return;
            }
            ApolloStats stats = platform.getStats();
            Runtime runtime = Runtime.getRuntime();
            List<String> enabledModules = Apollo.getModuleManager().getModules().stream().filter(ApolloModule::isEnabled).map(ApolloModule::getId).collect(Collectors.toList());
            ServerStartRequest.ServerStartRequestBuilder requestBuilder = ServerStartRequest.builder().serverInstallationId(((UUID)options.get(INSTALLATION_ID)).toString()).serverSessionId(SESSION_ID);
            if (serverStatistics) {
                requestBuilder.plugins(stats.getPlugins()).onlineMode(stats.isOnlineMode()).platformType(platform.getKind().name()).platformSubtype(stats.getPlatformSubtype()).platformVersion(stats.getPlatformVersion()).modules(enabledModules);
            }
            if (softwareInformation) {
                requestBuilder.javaVersion(System.getProperty("java.version")).operatingSystem(System.getProperty("os.name")).operatingSystemRelease(System.getProperty("os.version"));
            }
            if (hardwareInformation) {
                requestBuilder.cpuArch(System.getProperty("os.arch")).cpuCoreCount(runtime.availableProcessors());
            }
            ServerStartRequest finalRequest = request = requestBuilder.build();
            ApolloManager.getHttpManager().request(requestBuilder.build()).onFailure(throwable -> ApolloHttpManager.handleError("Failed to send server start request!", throwable, finalRequest));
        }
        catch (Throwable e) {
            ApolloHttpManager.handleError("Failed to create server start request!", e, request);
        }
    }
}

