/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.stats;

import com.lunarclient.apollo.Apollo;
import com.lunarclient.apollo.ApolloManager;
import com.lunarclient.apollo.ApolloPlatform;
import com.lunarclient.apollo.api.ApolloHttpManager;
import com.lunarclient.apollo.api.request.heartbeat.ServerHeartbeatRequest;
import com.lunarclient.apollo.option.Options;
import com.lunarclient.apollo.stats.ApolloStats;
import com.lunarclient.apollo.stats.ApolloStatsManager;
import com.lunarclient.apollo.stats.metadata.ApolloMetadataManager;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public final class ApolloStatsThread
extends Thread {
    private static final long MB_BYTES = 0x100000L;
    private static final OperatingSystemMXBean MX_BEAN = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    private static final long HEARTBEAT_INTERVAL = TimeUnit.MINUTES.toMillis(15L);

    public ApolloStatsThread() {
        this.setName("Apollo Stats Thread");
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        while (true) {
            ServerHeartbeatRequest request = null;
            try {
                ApolloPlatform platform = Apollo.getPlatform();
                Options options = platform.getOptions();
                ApolloStats stats = platform.getStats();
                Runtime runtime = Runtime.getRuntime();
                if (!((Boolean)options.get(ApolloStatsManager.SEND_STATS)).booleanValue()) break;
                boolean performance = (Boolean)options.get(ApolloStatsManager.HEARTBEAT_PERFORMANCE);
                boolean counts = (Boolean)options.get(ApolloStatsManager.HEARTBEAT_COUNTS);
                boolean userMetadata = (Boolean)options.get(ApolloStatsManager.HEARTBEAT_USER_METADATA);
                if (!performance && !counts && !userMetadata) break;
                ServerHeartbeatRequest.ServerHeartbeatRequestBuilder requestBuilder = ServerHeartbeatRequest.builder().serverInstallationId(((UUID)options.get(ApolloStatsManager.INSTALLATION_ID)).toString()).serverSessionId(ApolloStatsManager.SESSION_ID);
                if (performance) {
                    requestBuilder.cpuUsage(MX_BEAN.getSystemLoadAverage()).ramMax((int)(runtime.maxMemory() / 0x100000L)).ramUsed((int)((runtime.maxMemory() - runtime.freeMemory()) / 0x100000L));
                }
                if (counts) {
                    requestBuilder.totalPlayers(stats.getTotalPlayers());
                }
                if (userMetadata) {
                    ApolloMetadataManager metadataManager = ApolloManager.getMetadataManager();
                    requestBuilder.metadata(metadataManager.extract());
                    metadataManager.clear();
                }
                ServerHeartbeatRequest finalRequest = request = requestBuilder.build();
                ApolloManager.getHttpManager().request(request).onFailure(throwable -> ApolloHttpManager.handleError("Failed to send heartbeat!", throwable, finalRequest));
            }
            catch (Throwable e) {
                ApolloHttpManager.handleError("Failed to create heartbeat!", e, request);
            }
            try {
                Thread.sleep(HEARTBEAT_INTERVAL);
            }
            catch (InterruptedException e) {
                ApolloHttpManager.handleError("Failed to sleep stats thread!", e, null);
            }
        }
    }
}

