/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stylisheffects.client.handler;

import fuzs.puzzleslib.api.client.gui.v2.ScreenHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.stylisheffects.StylishEffects;
import fuzs.stylisheffects.api.v1.client.EffectScreenHandler;
import fuzs.stylisheffects.api.v1.client.MobEffectWidgetContext;
import fuzs.stylisheffects.client.gui.effects.AbstractEffectRenderer;
import fuzs.stylisheffects.client.gui.effects.GuiCompactEffectRenderer;
import fuzs.stylisheffects.client.gui.effects.GuiSmallEffectRenderer;
import fuzs.stylisheffects.client.gui.effects.InventoryCompactEffectRenderer;
import fuzs.stylisheffects.client.gui.effects.InventoryFullSizeEffectRenderer;
import fuzs.stylisheffects.client.handler.EffectRendererEnvironment;
import fuzs.stylisheffects.config.ClientConfig;
import fuzs.stylisheffects.services.ClientAbstractions;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.class_10260;
import net.minecraft.class_11909;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3917;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_768;
import net.minecraft.class_7923;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;

public class EffectScreenHandlerImpl
implements EffectScreenHandler {
    public static final EffectScreenHandlerImpl INSTANCE = new EffectScreenHandlerImpl();
    public static final String KEY_DEBUG_MENU_TYPE = StylishEffects.id("menu_opening").method_48747("screen", "debug");
    @Nullable
    private AbstractEffectRenderer guiRenderer;
    @Nullable
    private AbstractEffectRenderer inventoryRenderer;

    private EffectScreenHandlerImpl() {
    }

    @Override
    public void rebuildEffectRenderers() {
        MobEffectWidgetContext.Renderer rendererType = ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).guiRenderer().rendererType;
        if (rendererType != MobEffectWidgetContext.Renderer.NONE) {
            this.guiRenderer = EffectScreenHandlerImpl.createRenderer(rendererType, EffectRendererEnvironment.GUI);
        }
    }

    @Override
    public Optional<MobEffectWidgetContext> getInventoryHoveredEffect(class_437 screen, double mouseX, double mouseY) {
        return EffectScreenHandlerImpl.getEffectRenderer(screen, this.inventoryRenderer).flatMap(renderer -> renderer.getHoveredEffect((int)mouseX, (int)mouseY).map(renderer::buildContext));
    }

    @Override
    public List<class_768> getInventoryRenderAreas(class_437 screen) {
        return EffectScreenHandlerImpl.getEffectRenderer(screen, this.inventoryRenderer).map(AbstractEffectRenderer::getRenderAreas).orElse(List.of());
    }

    public void onClientTick(class_310 minecraft) {
        this.createInventoryRenderer(minecraft.field_1755, (class_1657)minecraft.field_1724);
    }

    public void onAfterInit(class_310 minecraft, class_437 screen, int screenWidth, int screenHeight, List<class_339> widgets, UnaryOperator<class_339> addWidget, Consumer<class_339> removeWidget) {
        this.createInventoryRenderer(screen, (class_1657)minecraft.field_1724);
    }

    private void createInventoryRenderer(@Nullable class_437 screen, @Nullable class_1657 player) {
        AbstractEffectRenderer renderer;
        AbstractEffectRenderer abstractEffectRenderer = renderer = screen != null ? EffectScreenHandlerImpl.createInventoryRendererOrFallback(screen) : null;
        if (renderer != null && player != null) {
            renderer.setActiveEffects(player.method_6026());
        }
        this.inventoryRenderer = renderer;
    }

    public void renderStatusEffects(class_332 guiGraphics, class_9779 deltaTracker) {
        class_310 minecraft = class_310.method_1551();
        EffectScreenHandlerImpl.getEffectRenderer(minecraft.field_1755, true, this.guiRenderer, minecraft.field_1724.method_6026()).ifPresent(renderer -> {
            MobEffectWidgetContext.ScreenSide screenSide = ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).guiRenderer().screenSide;
            renderer.setScreenDimensions(minecraft.field_1705, guiGraphics.method_51421(), guiGraphics.method_51443(), screenSide.right() ? guiGraphics.method_51421() : 0, 0, screenSide);
            renderer.renderEffects(guiGraphics, minecraft);
        });
    }

    public void onAfterBackground(class_465<?> screen, class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        EffectScreenHandlerImpl.getEffectRenderer(screen, this.inventoryRenderer).ifPresent(renderer -> {
            renderer.renderEffects(guiGraphics, screen.field_22787);
            class_1836.class_1837 tooltipFlag = screen.field_22787.field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070;
            renderer.getHoveredEffectTooltip(mouseX, mouseY, (class_1836)tooltipFlag).ifPresent(tooltip -> {
                if (screen.method_17577().method_34255().method_7960()) {
                    guiGraphics.method_51434(screen.method_64506(), tooltip, mouseX, mouseY);
                }
            });
        });
    }

    public EventResult onBeforeMouseClick(class_437 screen, class_11909 mouseButtonEvent) {
        EffectScreenHandlerImpl.getEffectRenderer(screen, this.inventoryRenderer).ifPresent(renderer -> renderer.getHoveredEffect((int)mouseButtonEvent.comp_4798(), (int)mouseButtonEvent.comp_4799()).ifPresent(effectInstance -> ClientAbstractions.INSTANCE.onEffectMouseClicked(renderer.buildContext((class_1293)effectInstance), screen, mouseButtonEvent, ScreenHelper.isDoubleClick((class_11909)mouseButtonEvent))));
        return EventResult.PASS;
    }

    public EventResultHolder<@Nullable class_437> onScreenOpening(@Nullable class_437 oldScreen, @Nullable class_437 newScreen) {
        if (newScreen instanceof class_465) {
            class_3917 menuType;
            class_465 abstractContainerScreen = (class_465)newScreen;
            if (((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().debugContainerTypes && (menuType = abstractContainerScreen.method_17577().field_17493) != null) {
                class_5250 component = class_2561.method_43470((String)class_7923.field_41187.method_10221((Object)menuType).toString());
                class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)KEY_DEBUG_MENU_TYPE, (Object[])new Object[]{class_2564.method_10885((class_2561)component)}));
            }
        }
        return EventResultHolder.pass();
    }

    private static Optional<AbstractEffectRenderer> getEffectRenderer(class_437 screen, @Nullable AbstractEffectRenderer effectRenderer) {
        return EffectScreenHandlerImpl.getEffectRenderer(screen, false, effectRenderer, null);
    }

    private static Optional<AbstractEffectRenderer> getEffectRenderer(@Nullable class_437 screen, boolean invertSupport, @Nullable AbstractEffectRenderer effectRenderer, @Nullable Collection<class_1293> activeEffects) {
        if ((!invertSupport && EffectScreenHandlerImpl.supportsEffectsDisplay(screen) || invertSupport && !EffectScreenHandlerImpl.supportsEffectsDisplay(screen)) && effectRenderer != null) {
            if (activeEffects != null) {
                effectRenderer.setActiveEffects(activeEffects);
            }
            if (effectRenderer.isActive()) {
                return Optional.of(effectRenderer);
            }
        }
        return Optional.empty();
    }

    public static AbstractEffectRenderer createRenderer(MobEffectWidgetContext.Renderer renderer, EffectRendererEnvironment environment) {
        return switch (renderer) {
            case MobEffectWidgetContext.Renderer.GUI_SMALL -> new GuiSmallEffectRenderer(environment);
            case MobEffectWidgetContext.Renderer.GUI_COMPACT -> new GuiCompactEffectRenderer(environment);
            case MobEffectWidgetContext.Renderer.INVENTORY_COMPACT -> new InventoryCompactEffectRenderer(environment);
            case MobEffectWidgetContext.Renderer.INVENTORY_FULL_SIZE -> new InventoryFullSizeEffectRenderer(environment);
            default -> throw new IllegalArgumentException(String.format("Cannot create effect renderer for type %s", new Object[]{renderer}));
        };
    }

    @Nullable
    private static AbstractEffectRenderer createInventoryRendererOrFallback(class_437 screen) {
        MobEffectWidgetContext.Renderer rendererType = ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().rendererType;
        if (rendererType != MobEffectWidgetContext.Renderer.NONE && EffectScreenHandlerImpl.supportsEffectsDisplay(screen)) {
            class_465 containerScreen = (class_465)screen;
            MobEffectWidgetContext.ScreenSide screenSide = ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().screenSide;
            Consumer<AbstractEffectRenderer> setScreenDimensions = renderer -> {
                int leftPos = containerScreen.field_2776;
                int availableWidth = !screenSide.right() ? leftPos : containerScreen.field_22789 - (leftPos + containerScreen.field_2792);
                int startX = !screenSide.right() ? leftPos : leftPos + containerScreen.field_2792;
                renderer.setScreenDimensions(containerScreen, availableWidth, containerScreen.field_2779, startX, containerScreen.field_2800, screenSide);
            };
            AbstractEffectRenderer renderer2 = EffectScreenHandlerImpl.createRenderer(rendererType, EffectRendererEnvironment.INVENTORY);
            setScreenDimensions.accept(renderer2);
            while (!renderer2.isValid()) {
                EffectRendererEnvironment.Factory rendererFactory = renderer2.getFallbackRenderer();
                if (rendererFactory == null) {
                    return null;
                }
                renderer2 = (AbstractEffectRenderer)rendererFactory.apply(EffectRendererEnvironment.INVENTORY);
                setScreenDimensions.accept(renderer2);
            }
            return renderer2;
        }
        return null;
    }

    private static boolean supportsEffectsDisplay(@Nullable class_437 screen) {
        if (screen instanceof class_465) {
            class_465 containerScreen = (class_465)screen;
            class_3917 menuType = containerScreen.method_17577().field_17493;
            if (menuType != null && ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().menuBlacklist.contains((Object)menuType)) {
                return false;
            }
        }
        if (screen instanceof class_465 && (screen.method_64507() || ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().effectsEverywhere)) {
            if (screen instanceof class_10260) {
                class_10260 abstractRecipeBookScreen = (class_10260)screen;
                if (abstractRecipeBookScreen.field_54474.method_2605()) {
                    return ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().screenSide.right();
                }
            }
            return true;
        }
        return false;
    }
}

