/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stylisheffects.client.handler;

import fuzs.puzzleslib.api.client.gui.v2.ScreenHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.stylisheffects.StylishEffects;
import fuzs.stylisheffects.api.v1.client.EffectScreenHandler;
import fuzs.stylisheffects.api.v1.client.MobEffectWidgetContext;
import fuzs.stylisheffects.client.gui.effects.AbstractEffectRenderer;
import fuzs.stylisheffects.client.gui.effects.GuiCompactEffectRenderer;
import fuzs.stylisheffects.client.gui.effects.GuiSmallEffectRenderer;
import fuzs.stylisheffects.client.gui.effects.InventoryCompactEffectRenderer;
import fuzs.stylisheffects.client.gui.effects.InventoryFullSizeEffectRenderer;
import fuzs.stylisheffects.client.handler.EffectRendererEnvironment;
import fuzs.stylisheffects.config.ClientConfig;
import fuzs.stylisheffects.services.ClientAbstractions;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.AbstractRecipeBookScreen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class EffectScreenHandlerImpl
implements EffectScreenHandler {
    public static final EffectScreenHandlerImpl INSTANCE = new EffectScreenHandlerImpl();
    public static final String KEY_DEBUG_MENU_TYPE = StylishEffects.id("menu_opening").toLanguageKey("screen", "debug");
    @Nullable
    private AbstractEffectRenderer guiRenderer;
    @Nullable
    private AbstractEffectRenderer inventoryRenderer;

    private EffectScreenHandlerImpl() {
    }

    @Override
    public void rebuildEffectRenderers() {
        MobEffectWidgetContext.Renderer rendererType = ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).guiRenderer().rendererType;
        if (rendererType != MobEffectWidgetContext.Renderer.NONE) {
            this.guiRenderer = EffectScreenHandlerImpl.createRenderer(rendererType, EffectRendererEnvironment.GUI);
        }
    }

    @Override
    public Optional<MobEffectWidgetContext> getInventoryHoveredEffect(Screen screen, double mouseX, double mouseY) {
        return EffectScreenHandlerImpl.getEffectRenderer(screen, this.inventoryRenderer).flatMap(renderer -> renderer.getHoveredEffect((int)mouseX, (int)mouseY).map(renderer::buildContext));
    }

    @Override
    public List<Rect2i> getInventoryRenderAreas(Screen screen) {
        return EffectScreenHandlerImpl.getEffectRenderer(screen, this.inventoryRenderer).map(AbstractEffectRenderer::getRenderAreas).orElse(List.of());
    }

    public void onClientTick(Minecraft minecraft) {
        this.createInventoryRenderer(minecraft.screen, (Player)minecraft.player);
    }

    public void onAfterInit(Minecraft minecraft, Screen screen, int screenWidth, int screenHeight, List<AbstractWidget> widgets, UnaryOperator<AbstractWidget> addWidget, Consumer<AbstractWidget> removeWidget) {
        this.createInventoryRenderer(screen, (Player)minecraft.player);
    }

    private void createInventoryRenderer(@Nullable Screen screen, @Nullable Player player) {
        AbstractEffectRenderer renderer;
        AbstractEffectRenderer abstractEffectRenderer = renderer = screen != null ? EffectScreenHandlerImpl.createInventoryRendererOrFallback(screen) : null;
        if (renderer != null && player != null) {
            renderer.setActiveEffects(player.getActiveEffects());
        }
        this.inventoryRenderer = renderer;
    }

    public void renderStatusEffects(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Minecraft minecraft = Minecraft.getInstance();
        EffectScreenHandlerImpl.getEffectRenderer(minecraft.screen, true, this.guiRenderer, minecraft.player.getActiveEffects()).ifPresent(renderer -> {
            MobEffectWidgetContext.ScreenSide screenSide = ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).guiRenderer().screenSide;
            renderer.setScreenDimensions(minecraft.gui, guiGraphics.guiWidth(), guiGraphics.guiHeight(), screenSide.right() ? guiGraphics.guiWidth() : 0, 0, screenSide);
            renderer.renderEffects(guiGraphics, minecraft);
        });
    }

    public void onAfterBackground(AbstractContainerScreen<?> screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        EffectScreenHandlerImpl.getEffectRenderer(screen, this.inventoryRenderer).ifPresent(renderer -> {
            renderer.renderEffects(guiGraphics, screen.minecraft);
            TooltipFlag.Default tooltipFlag = screen.minecraft.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
            renderer.getHoveredEffectTooltip(mouseX, mouseY, (TooltipFlag)tooltipFlag).ifPresent(tooltip -> {
                if (screen.getMenu().getCarried().isEmpty()) {
                    guiGraphics.setComponentTooltipForNextFrame(screen.getFont(), tooltip, mouseX, mouseY);
                }
            });
        });
    }

    public EventResult onBeforeMouseClick(Screen screen, MouseButtonEvent mouseButtonEvent) {
        EffectScreenHandlerImpl.getEffectRenderer(screen, this.inventoryRenderer).ifPresent(renderer -> renderer.getHoveredEffect((int)mouseButtonEvent.x(), (int)mouseButtonEvent.y()).ifPresent(effectInstance -> ClientAbstractions.INSTANCE.onEffectMouseClicked(renderer.buildContext((MobEffectInstance)effectInstance), screen, mouseButtonEvent, ScreenHelper.isDoubleClick((MouseButtonEvent)mouseButtonEvent))));
        return EventResult.PASS;
    }

    public EventResultHolder<@Nullable Screen> onScreenOpening(@Nullable Screen oldScreen, @Nullable Screen newScreen) {
        if (newScreen instanceof AbstractContainerScreen) {
            MenuType menuType;
            AbstractContainerScreen abstractContainerScreen = (AbstractContainerScreen)newScreen;
            if (((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().debugContainerTypes && (menuType = abstractContainerScreen.getMenu().menuType) != null) {
                MutableComponent component = Component.literal((String)BuiltInRegistries.MENU.getKey((Object)menuType).toString());
                Minecraft.getInstance().gui.getChat().addMessage((Component)Component.translatable((String)KEY_DEBUG_MENU_TYPE, (Object[])new Object[]{ComponentUtils.wrapInSquareBrackets((Component)component)}));
            }
        }
        return EventResultHolder.pass();
    }

    private static Optional<AbstractEffectRenderer> getEffectRenderer(Screen screen, @Nullable AbstractEffectRenderer effectRenderer) {
        return EffectScreenHandlerImpl.getEffectRenderer(screen, false, effectRenderer, null);
    }

    private static Optional<AbstractEffectRenderer> getEffectRenderer(@Nullable Screen screen, boolean invertSupport, @Nullable AbstractEffectRenderer effectRenderer, @Nullable Collection<MobEffectInstance> activeEffects) {
        if ((!invertSupport && EffectScreenHandlerImpl.supportsEffectsDisplay(screen) || invertSupport && !EffectScreenHandlerImpl.supportsEffectsDisplay(screen)) && effectRenderer != null) {
            if (activeEffects != null) {
                effectRenderer.setActiveEffects(activeEffects);
            }
            if (effectRenderer.isActive()) {
                return Optional.of(effectRenderer);
            }
        }
        return Optional.empty();
    }

    public static AbstractEffectRenderer createRenderer(MobEffectWidgetContext.Renderer renderer, EffectRendererEnvironment environment) {
        return switch (renderer) {
            case MobEffectWidgetContext.Renderer.GUI_SMALL -> new GuiSmallEffectRenderer(environment);
            case MobEffectWidgetContext.Renderer.GUI_COMPACT -> new GuiCompactEffectRenderer(environment);
            case MobEffectWidgetContext.Renderer.INVENTORY_COMPACT -> new InventoryCompactEffectRenderer(environment);
            case MobEffectWidgetContext.Renderer.INVENTORY_FULL_SIZE -> new InventoryFullSizeEffectRenderer(environment);
            default -> throw new IllegalArgumentException(String.format("Cannot create effect renderer for type %s", new Object[]{renderer}));
        };
    }

    @Nullable
    private static AbstractEffectRenderer createInventoryRendererOrFallback(Screen screen) {
        MobEffectWidgetContext.Renderer rendererType = ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().rendererType;
        if (rendererType != MobEffectWidgetContext.Renderer.NONE && EffectScreenHandlerImpl.supportsEffectsDisplay(screen)) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            MobEffectWidgetContext.ScreenSide screenSide = ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().screenSide;
            Consumer<AbstractEffectRenderer> setScreenDimensions = renderer -> {
                int leftPos = containerScreen.leftPos;
                int availableWidth = !screenSide.right() ? leftPos : containerScreen.width - (leftPos + containerScreen.imageWidth);
                int startX = !screenSide.right() ? leftPos : leftPos + containerScreen.imageWidth;
                renderer.setScreenDimensions(containerScreen, availableWidth, containerScreen.imageHeight, startX, containerScreen.topPos, screenSide);
            };
            AbstractEffectRenderer renderer2 = EffectScreenHandlerImpl.createRenderer(rendererType, EffectRendererEnvironment.INVENTORY);
            setScreenDimensions.accept(renderer2);
            while (!renderer2.isValid()) {
                EffectRendererEnvironment.Factory rendererFactory = renderer2.getFallbackRenderer();
                if (rendererFactory == null) {
                    return null;
                }
                renderer2 = (AbstractEffectRenderer)rendererFactory.apply(EffectRendererEnvironment.INVENTORY);
                setScreenDimensions.accept(renderer2);
            }
            return renderer2;
        }
        return null;
    }

    private static boolean supportsEffectsDisplay(@Nullable Screen screen) {
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            MenuType menuType = containerScreen.getMenu().menuType;
            if (menuType != null && ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().menuBlacklist.contains((Object)menuType)) {
                return false;
            }
        }
        if (screen instanceof AbstractContainerScreen && (screen.showsActiveEffects() || ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().effectsEverywhere)) {
            if (screen instanceof AbstractRecipeBookScreen) {
                AbstractRecipeBookScreen abstractRecipeBookScreen = (AbstractRecipeBookScreen)screen;
                if (abstractRecipeBookScreen.recipeBookComponent.isVisible()) {
                    return ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().screenSide.right();
                }
            }
            return true;
        }
        return false;
    }
}

