/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.forge;

import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import org.anti_ad.mc.common.gui.NativeInputContext;
import org.anti_ad.mc.common.gui.NativeInputContextBase;
import org.anti_ad.mc.common.input.GlobalInputHandler;
import org.anti_ad.mc.common.input.GlobalScreenEventListener;
import org.anti_ad.mc.common.vanilla.Vanilla;

public class CommonForgeEventHandler {
    private int lastMods = 0;

    @SubscribeEvent
    public void onKeyLast(InputEvent.Key event) {
        if (Vanilla.INSTANCE.screen() == null) {
            NativeInputContext<KeyEvent> context = new NativeInputContext<KeyEvent>(event.getKeyEvent(), false);
            GlobalInputHandler.INSTANCE.onKey(context, event.getKey(), event.getScanCode(), event.getAction(), event.getModifiers(), true, 0L);
        }
    }

    @SubscribeEvent
    public void onKeyPressed(ScreenEvent.KeyPressed.Pre event) {
        NativeInputContext<KeyEvent> context = new NativeInputContext<KeyEvent>(event.getKeyEvent(), false);
        this.onScreenKey(context, event.getKeyCode(), event.getScanCode(), 1, event.getModifiers(), (ScreenEvent)event);
        if (event.isCanceled()) {
            return;
        }
        event.setCanceled(GlobalScreenEventListener.INSTANCE.onKeyPressed(context, event.getKeyCode(), event.getScanCode(), event.getModifiers(), true));
    }

    @SubscribeEvent
    public void onKeyRelease(ScreenEvent.KeyReleased.Pre event) {
        NativeInputContext<KeyEvent> context = new NativeInputContext<KeyEvent>(event.getKeyEvent(), false);
        this.onScreenKey(context, event.getKeyCode(), event.getScanCode(), 0, event.getModifiers(), (ScreenEvent)event);
        if (event.isCanceled()) {
            return;
        }
        event.setCanceled(GlobalScreenEventListener.INSTANCE.onKeyReleased(context, event.getKeyCode(), event.getScanCode(), event.getModifiers(), true));
    }

    @SubscribeEvent
    public void onKeyPressedPost(ScreenEvent.KeyPressed.Post event) {
        NativeInputContext<KeyEvent> context = new NativeInputContext<KeyEvent>(event.getKeyEvent(), false);
        event.setCanceled(GlobalScreenEventListener.INSTANCE.onKeyPressed(context, event.getKeyCode(), event.getScanCode(), event.getModifiers(), false));
    }

    @SubscribeEvent
    public void onKeyReleasePost(ScreenEvent.KeyReleased.Post event) {
        NativeInputContext<KeyEvent> context = new NativeInputContext<KeyEvent>(event.getKeyEvent(), false);
        event.setCanceled(GlobalScreenEventListener.INSTANCE.onKeyReleased(context, event.getKeyCode(), event.getScanCode(), event.getModifiers(), false));
    }

    private void onScreenKey(NativeInputContextBase<?> context, int key, int scanCode, int action, int modifiers, ScreenEvent event) {
        Screen lastScreen = Vanilla.INSTANCE.screen();
        long handle = Vanilla.INSTANCE.window().handle();
        boolean result = GlobalInputHandler.INSTANCE.onKey(context, key, scanCode, action, modifiers, true, handle);
        if (event instanceof ICancellableEvent) {
            ((ICancellableEvent)event).setCanceled(result || lastScreen != Vanilla.INSTANCE.screen());
        }
    }

    @SubscribeEvent
    public void onMouseButtonLast(InputEvent.MouseButton.Post event) {
        if (Vanilla.INSTANCE.screen() == null) {
            NativeInputContext<MouseButtonInfo> context = new NativeInputContext<MouseButtonInfo>(event.getMouseButtonInfo(), false);
            GlobalInputHandler.INSTANCE.onMouseButton(context, event.getButton(), event.getAction(), event.getModifiers());
        }
    }

    @SubscribeEvent
    public void onMouseClicked(ScreenEvent.MouseButtonPressed.Pre event) {
        NativeInputContext<MouseButtonEvent> context = new NativeInputContext<MouseButtonEvent>(event.getMouseButtonEvent(), event.isDoubleClick());
        this.onScreenMouseButton(context, event.getButton(), 1, this.lastMods, (ICancellableEvent)event);
        if (event.isCanceled()) {
            return;
        }
        event.setCanceled(GlobalScreenEventListener.INSTANCE.onMouseClicked(context, event.getMouseX(), event.getMouseY(), event.getButton(), true));
    }

    @SubscribeEvent
    public void onMouseReleased(ScreenEvent.MouseButtonReleased.Pre event) {
        NativeInputContext<MouseButtonEvent> context = new NativeInputContext<MouseButtonEvent>(event.getMouseButtonEvent(), false);
        this.onScreenMouseButton(context, event.getButton(), 0, this.lastMods, (ICancellableEvent)event);
        if (event.isCanceled()) {
            return;
        }
        event.setCanceled(GlobalScreenEventListener.INSTANCE.onMouseReleased(context, event.getMouseX(), event.getMouseY(), event.getButton(), true));
    }

    @SubscribeEvent
    public void onMouseClickedPost(ScreenEvent.MouseButtonPressed.Post event) {
        NativeInputContext<MouseButtonEvent> context = new NativeInputContext<MouseButtonEvent>(event.getMouseButtonEvent(), false);
        GlobalScreenEventListener.INSTANCE.onMouseClicked(context, event.getMouseX(), event.getMouseY(), event.getButton(), false);
    }

    @SubscribeEvent
    public void onMouseReleasedPost(ScreenEvent.MouseButtonReleased.Post event) {
        NativeInputContext<MouseButtonEvent> context = new NativeInputContext<MouseButtonEvent>(event.getMouseButtonEvent(), false);
        GlobalScreenEventListener.INSTANCE.onMouseReleased(context, event.getMouseX(), event.getMouseY(), event.getButton(), false);
    }

    private void onScreenMouseButton(NativeInputContextBase<?> context, int button, int action, int mods, ICancellableEvent event) {
        Screen lastScreen = Vanilla.INSTANCE.screen();
        boolean result = GlobalInputHandler.INSTANCE.onMouseButton(context, button, action, mods);
        event.setCanceled(result || lastScreen != Vanilla.INSTANCE.screen());
    }

    @SubscribeEvent
    public void onRawMouse(InputEvent.MouseButton.Pre event) {
        this.lastMods = event.getModifiers();
    }

    @SubscribeEvent
    public void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        double deltaX = event.getScrollDeltaX();
        double deltaY = event.getScrollDeltaY();
        if (deltaX != 0.0) {
            event.setCanceled(CommonForgeEventHandler.processHorizontalScrollEvent(deltaX));
        }
        if (deltaY != 0.0) {
            event.setCanceled(CommonForgeEventHandler.processVerticalScrollEvent(deltaY));
        }
    }

    @SubscribeEvent
    public void onGuiMouseScroll(ScreenEvent.MouseScrolled.Pre event) {
        boolean result;
        Screen lastScreen;
        double deltaX = event.getScrollDeltaX();
        double deltaY = event.getScrollDeltaY();
        if (deltaX != 0.0) {
            lastScreen = Vanilla.INSTANCE.screen();
            result = CommonForgeEventHandler.processHorizontalScrollEvent(deltaX);
            result = CommonForgeEventHandler.processHorizontalScrollGUIEvent(deltaX, event.getMouseX(), event.getMouseY()) || result;
            event.setCanceled(result || lastScreen != Vanilla.INSTANCE.screen());
        }
        if (deltaY != 0.0) {
            lastScreen = Vanilla.INSTANCE.screen();
            result = CommonForgeEventHandler.processVerticalScrollEvent(deltaY);
            result = CommonForgeEventHandler.processVerticalScrollGUIEvent(deltaY, event.getMouseX(), event.getMouseY()) || result;
            event.setCanceled(result || lastScreen != Vanilla.INSTANCE.screen());
        }
    }

    private static boolean processVerticalScrollGUIEvent(double delta, double mouseX, double mouseY) {
        int button = delta > 0.0 ? -10000 : -10001;
        boolean result = GlobalScreenEventListener.INSTANCE.onMouseClicked(NativeInputContext.getEMPTY(), mouseX, mouseY, button, true);
        result = GlobalScreenEventListener.INSTANCE.onMouseReleased(NativeInputContext.getEMPTY(), mouseX, mouseY, button, true) || result;
        return result;
    }

    private static boolean processHorizontalScrollGUIEvent(double delta, double mouseX, double mouseY) {
        int button = delta > 0.0 ? -10002 : -10003;
        boolean result = GlobalScreenEventListener.INSTANCE.onMouseClicked(NativeInputContext.getEMPTY(), mouseX, mouseY, button, true);
        result = GlobalScreenEventListener.INSTANCE.onMouseReleased(NativeInputContext.getEMPTY(), mouseX, mouseY, button, true) || result;
        return result;
    }

    private static boolean processVerticalScrollEvent(double delta) {
        int button = delta > 0.0 ? -10000 : -10001;
        boolean result = GlobalInputHandler.INSTANCE.onMouseButton(NativeInputContext.getEMPTY(), button, 1, 0);
        result = GlobalInputHandler.INSTANCE.onMouseButton(NativeInputContext.getEMPTY(), button, 0, 0) | result;
        return result;
    }

    private static boolean processHorizontalScrollEvent(double delta) {
        int button = delta > 0.0 ? -10002 : -10003;
        boolean result = GlobalInputHandler.INSTANCE.onMouseButton(NativeInputContext.getEMPTY(), button, 1, 0);
        result = GlobalInputHandler.INSTANCE.onMouseButton(NativeInputContext.getEMPTY(), button, 0, 0) | result;
        return result;
    }
}

