/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.config.builder;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JvmStreamsKt;
import org.anti_ad.mc.common.Savable;
import org.anti_ad.mc.common.config.IConfigElement;
import org.anti_ad.mc.common.extensions.Java_ioKt;
import org.anti_ad.mc.common.extensions.JsonKt;
import org.anti_ad.mc.common.vanilla.VanillaUtil;
import org.anti_ad.mc.libipn.Log;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u00078B@BX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lorg/anti_ad/mc/common/config/builder/ConfigSaveLoadManager;", "Lorg/anti_ad/mc/common/Savable;", "modId", "", "fileName", "configSource", "Lkotlin/Function0;", "Lorg/anti_ad/mc/common/config/IConfigElement;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "configFile", "Ljava/nio/file/Path;", "path", "value", "config", "getConfig", "()Lorg/anti_ad/mc/common/config/IConfigElement;", "setConfig", "(Lorg/anti_ad/mc/common/config/IConfigElement;)V", "encoder", "Lkotlinx/serialization/json/Json;", "getEncoder$annotations", "()V", "save", "", "load", "forge-1.21.1"})
public class ConfigSaveLoadManager
implements Savable {
    @NotNull
    private final Function0<IConfigElement> configSource;
    @NotNull
    private final Path configFile;
    @NotNull
    private final String path;
    @Nullable
    private IConfigElement config;
    @NotNull
    private final Json encoder;

    public ConfigSaveLoadManager(@NotNull String modId, @NotNull String fileName, @NotNull Function0<? extends IConfigElement> configSource) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(configSource, (String)"configSource");
        this.configSource = configSource;
        this.configFile = Java_ioKt.div(VanillaUtil.INSTANCE.configDirectory(modId), fileName);
        this.path = Java_ioKt.getLoggingPath(this.configFile);
        this.encoder = kotlinx.serialization.json.JsonKt.Json$default(null, ConfigSaveLoadManager::encoder$lambda$0, (int)1, null);
    }

    private final IConfigElement getConfig() {
        if (this.config == null) {
            this.config = (IConfigElement)this.configSource.invoke();
        }
        return this.config;
    }

    private final void setConfig(IConfigElement value) {
        if (value == null) {
            this.config = null;
        }
    }

    private static /* synthetic */ void getEncoder$annotations() {
    }

    @Override
    public void save() {
        try {
            IConfigElement iConfigElement = this.getConfig();
            Intrinsics.checkNotNull((Object)iConfigElement);
            JsonElement el = iConfigElement.toJsonElement();
            SerializationStrategy serializationStrategy = (SerializationStrategy)JsonElement.Companion.serializer();
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream(this.configFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            JvmStreamsKt.encodeToStream((Json)this.encoder, (SerializationStrategy)serializationStrategy, (Object)el, (OutputStream)outputStream);
        }
        catch (IOException e) {
            Log.INSTANCE.error("I/O error while writing config file " + this.path, e);
        }
        catch (Exception e) {
            Log.INSTANCE.error("Error write config file " + this.path, e);
        }
    }

    @Override
    public void load() {
        try {
            if (!Java_ioKt.exists(this.configFile)) {
                return;
            }
            JsonElement j = JsonKt.toJsonElement(PathsKt.readText$default((Path)this.configFile, null, (int)1, null));
            IConfigElement iConfigElement = this.getConfig();
            Intrinsics.checkNotNull((Object)iConfigElement);
            iConfigElement.fromJsonElement(j);
        }
        catch (IOException e) {
            Log.INSTANCE.error("Failed to read config file " + this.path, e);
        }
        catch (SerializationException e) {
            Log.INSTANCE.error("Failed to parse config file " + this.path + " as JSON", e);
        }
        catch (Exception e) {
            Log.INSTANCE.error("Error write config file " + this.path, e);
        }
    }

    private static final Unit encoder$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrintIndent("    ");
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }
}

