/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.vanilla.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.anti_ad.mc.common.gui.NativeContext;
import org.anti_ad.mc.common.math2d.Rect2dKt;
import org.anti_ad.mc.common.math2d.Rectangle;
import org.anti_ad.mc.common.vanilla.render.LibIPNRenderSystem;
import org.anti_ad.mc.common.vanilla.render.glue.RectKt;
import org.anti_ad.mc.common.vanilla.render.glue.ScreenKt;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4fStack;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\b\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u000e\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a*\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\tH\u0086\b\u00f8\u0001\u0000\u001a\u0016\u0010\f\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0018\u0010\r\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u000e\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0006\u0010\u0010\u001a\u00020\u0001\u001a\u0006\u0010\u0011\u001a\u00020\u0001\u001a\b\u0010\u0012\u001a\u00020\u0001H\u0002\"\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0013"}, d2={"rStandardGlState", "", "rClearDepth", "context", "Lorg/anti_ad/mc/common/gui/NativeContext;", "rDepthMask", "bounds", "Lorg/anti_ad/mc/common/math2d/Rectangle;", "block", "Lkotlin/Function0;", "depthBounds", "", "rCreateDepthMask", "rCreateDepthMaskNoCheck", "rRemoveDepthMask", "rOverwriteDepth", "rDisableDepth", "rEnableDepth", "rEnableBlend", "neoforge-1.21.6"})
public final class GLKt {
    @NotNull
    private static final List<Rectangle> depthBounds = new ArrayList();

    public static final void rStandardGlState() {
        GLKt.rEnableBlend();
        LibIPNRenderSystem.INSTANCE._enableDepthTest();
        LibIPNRenderSystem.INSTANCE._depthMask(true);
    }

    public static final void rClearDepth(@NotNull NativeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        LibIPNRenderSystem.INSTANCE._enableDepthTest();
        LibIPNRenderSystem.INSTANCE._depthMask(true);
        LibIPNRenderSystem.INSTANCE._clear(256);
        GLKt.rOverwriteDepth(context, ScreenKt.getRScreenBounds());
        depthBounds.clear();
    }

    public static final void rDepthMask(@NotNull NativeContext context, @NotNull Rectangle bounds, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$rDepthMask = false;
        GLKt.rCreateDepthMask(context, bounds);
        block.invoke();
        GLKt.rRemoveDepthMask(context);
    }

    public static final void rCreateDepthMask(@NotNull NativeContext context, @NotNull Rectangle bounds) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        GLKt.rStandardGlState();
        if (depthBounds.isEmpty()) {
            GLKt.rCreateDepthMaskNoCheck(context, bounds);
        } else {
            GLKt.rCreateDepthMaskNoCheck(context, Rect2dKt.intersect((Rectangle)CollectionsKt.last(depthBounds), bounds));
        }
    }

    private static final void rCreateDepthMaskNoCheck(NativeContext context, Rectangle bounds) {
        depthBounds.add(bounds);
        Matrix4fStack a = RenderSystem.getModelViewStack();
        a.pushMatrix();
        a.translate(0.0f, 0.0f, -400.0f);
        GLKt.rOverwriteDepth(context, bounds);
    }

    public static final void rRemoveDepthMask(@NotNull NativeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Matrix4fStack a = RenderSystem.getModelViewStack();
        a.popMatrix();
        Rectangle rectangle = depthBounds.removeLast();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"removeLast(...)");
        GLKt.rOverwriteDepth(context, rectangle);
    }

    private static final void rOverwriteDepth(NativeContext context, Rectangle bounds) {
        LibIPNRenderSystem.INSTANCE._depthFunc(519);
        RectKt.rFillRect(context, bounds, 0);
        LibIPNRenderSystem.INSTANCE._depthFunc(515);
    }

    public static final void rDisableDepth() {
        LibIPNRenderSystem.INSTANCE._depthFunc(519);
        LibIPNRenderSystem.INSTANCE._depthMask(false);
    }

    public static final void rEnableDepth() {
        LibIPNRenderSystem.INSTANCE._depthMask(true);
        LibIPNRenderSystem.INSTANCE._depthFunc(515);
    }

    private static final void rEnableBlend() {
        LibIPNRenderSystem.INSTANCE._enableBlend();
        LibIPNRenderSystem.INSTANCE._blendFuncSeparate(LibIPNRenderSystem.SrcFactor.SRC_ALPHA.getValue(), LibIPNRenderSystem.DstFactor.ONE_MINUS_SRC_ALPHA.getValue(), LibIPNRenderSystem.SrcFactor.ONE.getValue(), LibIPNRenderSystem.DstFactor.ZERO.getValue());
        LibIPNRenderSystem.INSTANCE._blendFunc(LibIPNRenderSystem.SrcFactor.SRC_ALPHA.getValue(), LibIPNRenderSystem.DstFactor.ONE_MINUS_SRC_ALPHA.getValue());
    }
}

