/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.better_snowball.entity.projectile.thrown;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class BetterSnowballHostilitySnowballEntity
extends Snowball {
    private final Level world;

    public BetterSnowballHostilitySnowballEntity(Level world, LivingEntity owner, ItemStack itemStack) {
        super(world, owner, itemStack);
        this.world = world;
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        LivingEntity livingEntity;
        super.onHitEntity(entityHitResult);
        Entity entity = entityHitResult.getEntity();
        int i = entity instanceof Blaze ? 3 : 0;
        entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), (float)i);
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity) instanceof Mob) {
            Mob mobEntity = (Mob)livingEntity;
            List nearbyEntities = this.world.getEntities((Entity)mobEntity, mobEntity.getBoundingBox().inflate(5.0), e -> e instanceof LivingEntity);
            for (Entity nearbyEntity : nearbyEntities) {
                if (!(nearbyEntity instanceof LivingEntity)) continue;
                LivingEntity targetEntity = (LivingEntity)nearbyEntity;
                if (nearbyEntity == mobEntity || !mobEntity.canAttack(targetEntity)) continue;
                mobEntity.setTarget(targetEntity);
            }
        }
    }
}

