/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.event.MaterialEvent;
import com.gregtechceu.gtceu.api.data.chemical.material.event.MaterialRegistryEvent;
import com.gregtechceu.gtceu.api.data.chemical.material.registry.MaterialRegistry;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.CommandDispatcher;
import dev.arbor.gtnn.GTNN;
import dev.arbor.gtnn.GTNNIntegration;
import dev.arbor.gtnn.api.registry.GTRecipeEvent;
import dev.arbor.gtnn.api.registry.GTRecipeManager;
import dev.arbor.gtnn.api.registry.NNRegistrate;
import dev.arbor.gtnn.client.GTNNCommands;
import dev.arbor.gtnn.client.renderer.ExtraHeartRenderHandler;
import dev.arbor.gtnn.client.renderer.StructureSelectRenderer;
import dev.arbor.gtnn.client.renderer.item.ItemCustomLayerModel;
import dev.arbor.gtnn.data.GTNNMachines;
import dev.arbor.gtnn.data.GTNNMaterials;
import dev.arbor.gtnn.data.GTNNRecipes;
import dev.arbor.gtnn.data.block.NNBlockMaps;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Camera;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0015H\u0007J\u001c\u0010\u0016\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017H\u0007J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0011H\u0007J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001fH\u0007J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006#"}, d2={"Ldev/arbor/gtnn/GTNNRegistries;", "", "<init>", "()V", "MATERIAL_REGISTRY", "Lcom/gregtechceu/gtceu/api/data/chemical/material/registry/MaterialRegistry;", "REGISTRATE", "Ldev/arbor/gtnn/api/registry/NNRegistrate;", "getREGISTRATE", "()Ldev/arbor/gtnn/api/registry/NNRegistrate;", "registerRecipeHandler", "", "event", "Ldev/arbor/gtnn/api/registry/GTRecipeEvent$RegisterHandler;", "registerGeometryLoaders", "Lnet/minecraftforge/client/event/ModelEvent$RegisterGeometryLoaders;", "fmlCommonSetupEvent", "Lnet/minecraftforge/fml/event/lifecycle/FMLCommonSetupEvent;", "onRenderWorldLast", "Lnet/minecraftforge/client/event/RenderLevelStageEvent;", "onServerStarting", "Lnet/minecraftforge/event/RegisterCommandsEvent;", "registerMachines", "Lcom/gregtechceu/gtceu/api/GTCEuAPI$RegisterEvent;", "Lnet/minecraft/resources/ResourceLocation;", "Lcom/gregtechceu/gtceu/api/machine/MachineDefinition;", "onCommonSetup", "modBus", "registerMaterialRegistryEvent", "Lcom/gregtechceu/gtceu/api/data/chemical/material/event/MaterialRegistryEvent;", "registerMaterials", "Lcom/gregtechceu/gtceu/api/data/chemical/material/event/MaterialEvent;", "getAllPackResources", "", "Lnet/minecraft/server/packs/PackResources;", "gtnn-1.20.1"})
public final class GTNNRegistries {
    @NotNull
    public static final GTNNRegistries INSTANCE = new GTNNRegistries();
    private static MaterialRegistry MATERIAL_REGISTRY;
    @NotNull
    private static final NNRegistrate REGISTRATE;

    private GTNNRegistries() {
    }

    @NotNull
    public final NNRegistrate getREGISTRATE() {
        return REGISTRATE;
    }

    @JvmStatic
    public static final void registerRecipeHandler(@NotNull GTRecipeEvent.RegisterHandler event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        GTNNRecipes.INSTANCE.register(event);
    }

    @JvmStatic
    public static final void registerGeometryLoaders(@NotNull ModelEvent.RegisterGeometryLoaders event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.register("item_custom_layers", (IGeometryLoader)ItemCustomLayerModel.Companion.getINSTANCE());
    }

    @JvmStatic
    public static final void fmlCommonSetupEvent(@NotNull FMLCommonSetupEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MinecraftForge.EVENT_BUS.register((Object)new ExtraHeartRenderHandler());
        GTRecipeManager.INSTANCE.onCommonSetup();
    }

    @JvmStatic
    public static final void onRenderWorldLast(@NotNull RenderLevelStageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        RenderLevelStageEvent.Stage stage = event.getStage();
        if (stage == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            PoseStack poseStack = event.getPoseStack();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"getPoseStack(...)");
            Camera camera = event.getCamera();
            Intrinsics.checkNotNullExpressionValue((Object)camera, (String)"getCamera(...)");
            StructureSelectRenderer.INSTANCE.renderStructureSelect(poseStack, camera);
        }
    }

    @JvmStatic
    public static final void onServerStarting(@NotNull RegisterCommandsEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CommandDispatcher commandDispatcher = event.getDispatcher();
        Intrinsics.checkNotNullExpressionValue((Object)commandDispatcher, (String)"getDispatcher(...)");
        GTNNCommands.register((CommandDispatcher<CommandSourceStack>)commandDispatcher);
    }

    @JvmStatic
    public static final void registerMachines(@NotNull GTCEuAPI.RegisterEvent<ResourceLocation, MachineDefinition> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        GTNNMachines.INSTANCE.init();
        GTNN.INSTANCE.getLOGGER().info("register GTNN Machines");
    }

    @JvmStatic
    public static final void onCommonSetup(@NotNull FMLCommonSetupEvent modBus) {
        Intrinsics.checkNotNullParameter((Object)modBus, (String)"modBus");
        NNBlockMaps.INSTANCE.initBlocks();
    }

    @JvmStatic
    public static final void registerMaterialRegistryEvent(@NotNull MaterialRegistryEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MATERIAL_REGISTRY = GTCEuAPI.materialManager.createRegistry("gtnn");
        GTNN.INSTANCE.getLOGGER().info("register GTNN Materials");
    }

    @JvmStatic
    public static final void registerMaterials(@NotNull MaterialEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        GTNNMaterials.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final List<PackResources> getAllPackResources() {
        ArrayList<FilePackResources> packResources = new ArrayList<FilePackResources>();
        if (GTNNIntegration.INSTANCE.isAdAstraLoaded()) {
            Closeable closeable = INSTANCE.getClass().getResourceAsStream("/data/gtnn/ad_astra.zip");
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                File tempFile = File.createTempFile("gtnn_resource_pack", ".tmp");
                FileUtils.copyInputStreamToFile((InputStream)it, (File)tempFile);
                boolean bl2 = packResources.add(new FilePackResources(tempFile.getName(), tempFile, false));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return packResources;
    }

    static {
        REGISTRATE = new NNRegistrate("gtnn");
    }
}

