/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.api.block;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.client.util.TooltipHelper;
import dev.arbor.gtnn.GTNN;
import dev.arbor.gtnn.api.block.ITierType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001:\u0001\u001bR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Ldev/arbor/gtnn/api/block/ITierGlassType;", "Ldev/arbor/gtnn/api/block/ITierType;", "isOpticalGlass", "", "()Z", "texture", "Lnet/minecraft/resources/ResourceLocation;", "getTexture", "()Lnet/minecraft/resources/ResourceLocation;", "tireVoltage", "", "getTireVoltage", "()J", "tireName", "", "getTireName", "()Ljava/lang/String;", "tireNameColored", "getTireNameColored", "opticalGlassTier", "", "getOpticalGlassTier", "()I", "opticalTierName", "Lnet/minecraft/network/chat/Component;", "getOpticalTierName", "()Lnet/minecraft/network/chat/Component;", "SimpleTierGlassType", "gtnn-1.20.1"})
public interface ITierGlassType
extends ITierType {
    public boolean isOpticalGlass();

    @NotNull
    public ResourceLocation getTexture();

    public long getTireVoltage();

    @NotNull
    public String getTireName();

    @NotNull
    public String getTireNameColored();

    public int getOpticalGlassTier();

    @NotNull
    public Component getOpticalTierName();

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static long getTireVoltage(@NotNull ITierGlassType $this) {
            return GTValues.V[$this.getTier()];
        }

        @NotNull
        public static String getTireName(@NotNull ITierGlassType $this) {
            String string = GTValues.VN[$this.getTier()];
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            return string;
        }

        @NotNull
        public static String getTireNameColored(@NotNull ITierGlassType $this) {
            String string = GTValues.VNF[$this.getTier()];
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            return string;
        }

        public static int getOpticalGlassTier(@NotNull ITierGlassType $this) {
            return (int)(Math.floor((double)$this.getTier() / 2.0) + (double)($this.getTier() % 2) - (double)2);
        }

        @NotNull
        public static Component getOpticalTierName(@NotNull ITierGlassType $this) {
            MutableComponent mutableComponent = Component.m_237115_((String)("gtnn.optical_glass_tier.desc." + $this.getOpticalGlassTier())).m_130940_(TooltipHelper.BLINKING_CYAN.getCurrent());
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            return (Component)mutableComponent;
        }

        @NotNull
        public static String getSerializedName(@NotNull ITierGlassType $this) {
            return ITierType.DefaultImpls.getSerializedName($this);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000e\u001a\u00020\u0004H\u0016J\t\u0010\u0012\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\rR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006\u001a"}, d2={"Ldev/arbor/gtnn/api/block/ITierGlassType$SimpleTierGlassType;", "Ldev/arbor/gtnn/api/block/ITierGlassType;", "Ljava/lang/Record;", "typeName", "", "tier", "", "isOpticalGlass", "", "<init>", "(Ljava/lang/String;IZ)V", "()Ljava/lang/String;", "()I", "()Z", "toString", "texture", "Lnet/minecraft/resources/ResourceLocation;", "()Lnet/minecraft/resources/ResourceLocation;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "gtnn-1.20.1"})
    public record SimpleTierGlassType(@NotNull String typeName, int tier, boolean isOpticalGlass) implements ITierGlassType
    {
        public SimpleTierGlassType {
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        }

        @Override
        @NotNull
        public String toString() {
            return this.typeName();
        }

        @NotNull
        public ResourceLocation texture() {
            return GTNN.INSTANCE.id("block/casings/transparent/" + this.typeName());
        }

        @NotNull
        public final String component1() {
            return this.typeName;
        }

        public final int component2() {
            return this.tier;
        }

        public final boolean component3() {
            return this.isOpticalGlass;
        }

        @NotNull
        public final SimpleTierGlassType copy(@NotNull String typeName, int tier, boolean isOpticalGlass) {
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            return new SimpleTierGlassType(typeName, tier, isOpticalGlass);
        }

        public static /* synthetic */ SimpleTierGlassType copy$default(SimpleTierGlassType simpleTierGlassType, String string, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = simpleTierGlassType.typeName;
            }
            if ((n2 & 2) != 0) {
                n = simpleTierGlassType.tier;
            }
            if ((n2 & 4) != 0) {
                bl = simpleTierGlassType.isOpticalGlass;
            }
            return simpleTierGlassType.copy(string, n, bl);
        }

        @Override
        public int hashCode() {
            int result = this.typeName.hashCode();
            result = result * 31 + Integer.hashCode(this.tier);
            result = result * 31 + Boolean.hashCode(this.isOpticalGlass);
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SimpleTierGlassType)) {
                return false;
            }
            SimpleTierGlassType simpleTierGlassType = (SimpleTierGlassType)other;
            if (!Intrinsics.areEqual((Object)this.typeName, (Object)simpleTierGlassType.typeName)) {
                return false;
            }
            if (this.tier != simpleTierGlassType.tier) {
                return false;
            }
            return this.isOpticalGlass == simpleTierGlassType.isOpticalGlass;
        }

        public long tireVoltage() {
            return DefaultImpls.getTireVoltage(this);
        }

        @NotNull
        public String tireName() {
            return DefaultImpls.getTireName(this);
        }

        @NotNull
        public String tireNameColored() {
            return DefaultImpls.getTireNameColored(this);
        }

        public int opticalGlassTier() {
            return DefaultImpls.getOpticalGlassTier(this);
        }

        @NotNull
        public Component opticalTierName() {
            return DefaultImpls.getOpticalTierName(this);
        }

        @Override
        @NotNull
        public String m_7912_() {
            return DefaultImpls.getSerializedName(this);
        }
    }
}

