/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.api.pattern;

import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import dev.arbor.gtnn.api.pattern.NNBlockPattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010%\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J/\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00152\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\u001bJ\u001f\u0010\u001a\u001a\u00020\u00002\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0015J\u0016\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u0011J\u0016\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0011J\u0006\u0010\"\u001a\u00020#J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0015J\u001f\u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\n0\n0\nH\u0002\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020(H\u0002R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ldev/arbor/gtnn/api/pattern/NNFactoryPattern;", "", "charDir", "Lcom/gregtechceu/gtceu/api/pattern/util/RelativeDirection;", "stringDir", "aisleDir", "<init>", "(Lcom/gregtechceu/gtceu/api/pattern/util/RelativeDirection;Lcom/gregtechceu/gtceu/api/pattern/util/RelativeDirection;Lcom/gregtechceu/gtceu/api/pattern/util/RelativeDirection;)V", "depth", "", "", "", "aisleRepetitions", "", "symbolMap", "", "", "Lcom/gregtechceu/gtceu/api/pattern/TraceabilityPredicate;", "structureDir", "[Lcom/gregtechceu/gtceu/api/pattern/util/RelativeDirection;", "aisleHeight", "", "rowWidth", "aisleRepeatable", "minRepeat", "maxRepeat", "aisle", "(II[Ljava/lang/String;)Ldev/arbor/gtnn/api/pattern/NNFactoryPattern;", "([Ljava/lang/String;)Ldev/arbor/gtnn/api/pattern/NNFactoryPattern;", "setRepeatable", "repeatCount", "where", "symbol", "blockMatcher", "build", "Ldev/arbor/gtnn/api/pattern/NNBlockPattern;", "tier", "makePredicateArray", "()[[[Lcom/gregtechceu/gtceu/api/pattern/TraceabilityPredicate;", "checkMissingPredicates", "", "Companion", "gtnn-1.20.1"})
@SourceDebugExtension(value={"SMAP\nNNFactoryPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NNFactoryPattern.kt\ndev/arbor/gtnn/api/pattern/NNFactoryPattern\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,155:1\n13472#2,2:156\n13472#2:159\n13473#2:162\n1#3:158\n1179#4,2:160\n37#5:163\n36#5,3:164\n538#6:167\n523#6,6:168\n*S KotlinDebug\n*F\n+ 1 NNFactoryPattern.kt\ndev/arbor/gtnn/api/pattern/NNFactoryPattern\n*L\n21#1:156,2\n44#1:159\n44#1:162\n48#1:160,2\n97#1:163\n97#1:164,3\n131#1:167\n131#1:168,6\n*E\n"})
public final class NNFactoryPattern {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String[]> depth = new ArrayList();
    @NotNull
    private final List<int[]> aisleRepetitions = new ArrayList();
    @NotNull
    private final Map<Character, TraceabilityPredicate> symbolMap = new LinkedHashMap();
    @NotNull
    private final RelativeDirection[] structureDir;
    private int aisleHeight;
    private int rowWidth;

    private NNFactoryPattern(RelativeDirection charDir, RelativeDirection stringDir, RelativeDirection aisleDir) {
        RelativeDirection[] relativeDirectionArray = new RelativeDirection[]{charDir, stringDir, aisleDir};
        this.structureDir = relativeDirectionArray;
        int flags = 0;
        RelativeDirection[] $this$forEach$iv = this.structureDir;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            RelativeDirection element$iv;
            RelativeDirection direction = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            flags = switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1, 2 -> flags | 1;
                case 3, 4 -> flags | 2;
                case 5, 6 -> flags | 4;
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        if (!(flags == 7)) {
            boolean bl = false;
            String string = "Must have 3 different axes!";
            throw new IllegalArgumentException(string.toString());
        }
        this.symbolMap.put(Character.valueOf(' '), Predicates.any());
    }

    @NotNull
    public final NNFactoryPattern aisleRepeatable(int minRepeat, int maxRepeat, String ... aisle) {
        Intrinsics.checkNotNullParameter((Object)aisle, (String)"aisle");
        if (!(!(aisle.length == 0) && ((CharSequence)aisle[0]).length() > 0)) {
            boolean $i$a$-require-NNFactoryPattern$aisleRepeatable$32 = false;
            String $i$a$-require-NNFactoryPattern$aisleRepeatable$32 = "Empty pattern for aisle";
            throw new IllegalArgumentException($i$a$-require-NNFactoryPattern$aisleRepeatable$32.toString());
        }
        if (this.depth.isEmpty()) {
            this.aisleHeight = aisle.length;
            this.rowWidth = aisle[0].length();
        }
        if (!(aisle.length == this.aisleHeight)) {
            boolean $i$a$-require-NNFactoryPattern$aisleRepeatable$52 = false;
            String $i$a$-require-NNFactoryPattern$aisleRepeatable$52 = "Expected aisle with height of " + this.aisleHeight + ", but was given one with a height of " + aisle.length;
            throw new IllegalArgumentException($i$a$-require-NNFactoryPattern$aisleRepeatable$52.toString());
        }
        String[] $this$forEach$iv = aisle;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String row = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (!(row.length() == this.rowWidth)) {
                boolean $i$a$-require-NNFactoryPattern$aisleRepeatable$3$22 = false;
                String $i$a$-require-NNFactoryPattern$aisleRepeatable$3$22 = "Not all rows in the given aisle are the correct width (expected " + this.rowWidth + ", found one with " + row.length() + ")";
                throw new IllegalArgumentException($i$a$-require-NNFactoryPattern$aisleRepeatable$3$22.toString());
            }
            CharSequence $this$forEach$iv2 = row;
            boolean $i$f$forEach2 = false;
            for (int j = 0; j < $this$forEach$iv2.length(); ++j) {
                char element$iv2;
                char c = element$iv2 = $this$forEach$iv2.charAt(j);
                boolean bl2 = false;
                this.symbolMap.putIfAbsent(Character.valueOf(c), null);
            }
        }
        this.depth.add(aisle);
        if (!(minRepeat <= maxRepeat)) {
            boolean bl = false;
            String string = "Lower bound of repeat counting must smaller than upper bound!";
            throw new IllegalArgumentException(string.toString());
        }
        int[] nArray = new int[]{minRepeat, maxRepeat};
        this.aisleRepetitions.add(nArray);
        return this;
    }

    @NotNull
    public final NNFactoryPattern aisle(String ... aisle) {
        Intrinsics.checkNotNullParameter((Object)aisle, (String)"aisle");
        return this.aisleRepeatable(1, 1, Arrays.copyOf(aisle, aisle.length));
    }

    @NotNull
    public final NNFactoryPattern setRepeatable(int minRepeat, int maxRepeat) {
        if (!(minRepeat <= maxRepeat)) {
            boolean bl = false;
            String string = "Lower bound of repeat counting must smaller than upper bound!";
            throw new IllegalArgumentException(string.toString());
        }
        int[] nArray = new int[]{minRepeat, maxRepeat};
        this.aisleRepetitions.set(this.aisleRepetitions.size() - 1, nArray);
        return this;
    }

    @NotNull
    public final NNFactoryPattern setRepeatable(int repeatCount) {
        return this.setRepeatable(repeatCount, repeatCount);
    }

    @NotNull
    public final NNFactoryPattern where(@NotNull String symbol, @NotNull TraceabilityPredicate blockMatcher) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)blockMatcher, (String)"blockMatcher");
        return this.where(symbol.charAt(0), blockMatcher);
    }

    @NotNull
    public final NNFactoryPattern where(char symbol, @NotNull TraceabilityPredicate blockMatcher) {
        Intrinsics.checkNotNullParameter((Object)blockMatcher, (String)"blockMatcher");
        Character c = Character.valueOf(symbol);
        this.symbolMap.put(c, blockMatcher.isAny() || blockMatcher.isAir() ? blockMatcher : new TraceabilityPredicate(blockMatcher).sort());
        return this;
    }

    @NotNull
    public final NNBlockPattern build() {
        return this.build(0);
    }

    @NotNull
    public final NNBlockPattern build(int tier) {
        int n;
        int n2;
        int n3;
        this.checkMissingPredicates();
        int[] centerOffset = new int[5];
        Collection $this$toTypedArray$iv = this.aisleRepetitions;
        int $i$f$toTypedArray = 0;
        Collection thisCollection$iv22 = $this$toTypedArray$iv;
        int[][] repetitionsArray = (int[][])thisCollection$iv22.toArray((T[])new int[0][]);
        int thisCollection$iv22 = this.depth.size();
        TraceabilityPredicate[][][] traceabilityPredicateArrayArray = new TraceabilityPredicate[thisCollection$iv22][][];
        for ($i$f$toTypedArray = 0; $i$f$toTypedArray < thisCollection$iv22; ++$i$f$toTypedArray) {
            n3 = $i$f$toTypedArray;
            int n4 = 0;
            n2 = this.aisleHeight;
            TraceabilityPredicate[][] traceabilityPredicateArrayArray2 = new TraceabilityPredicate[n2][];
            int n5 = n3;
            TraceabilityPredicate[][][] traceabilityPredicateArrayArray3 = traceabilityPredicateArrayArray;
            while (n4 < n2) {
                n = n4++;
                traceabilityPredicateArrayArray2[n] = new TraceabilityPredicate[this.rowWidth];
            }
            traceabilityPredicateArrayArray3[n5] = traceabilityPredicateArrayArray2;
        }
        TraceabilityPredicate[][][] predicate = traceabilityPredicateArrayArray;
        int minZ = 0;
        int maxZ = 0;
        n3 = ((Collection)this.depth).size();
        for (int i = 0; i < n3; ++i) {
            n2 = this.aisleHeight;
            for (int j = 0; j < n2; ++j) {
                n = this.rowWidth;
                for (int k = 0; k < n; ++k) {
                    char cell = this.depth.get(i)[j].charAt(k);
                    TraceabilityPredicate[] traceabilityPredicateArray = predicate[i][j];
                    TraceabilityPredicate traceabilityPredicate = this.symbolMap.get(Character.valueOf(cell));
                    Intrinsics.checkNotNull((Object)traceabilityPredicate);
                    traceabilityPredicateArray[k] = traceabilityPredicate;
                    TraceabilityPredicate traceabilityPredicate2 = predicate[i][j][k];
                    Intrinsics.checkNotNull((Object)traceabilityPredicate2);
                    if (!traceabilityPredicate2.isController) continue;
                    int[] nArray = new int[]{k, j, i, minZ, maxZ};
                    centerOffset = nArray;
                }
            }
            minZ += this.aisleRepetitions.get(i)[0];
            maxZ += this.aisleRepetitions.get(i)[1];
        }
        return new NNBlockPattern(tier, predicate, this.structureDir, repetitionsArray, centerOffset);
    }

    private final TraceabilityPredicate[][][] makePredicateArray() {
        this.checkMissingPredicates();
        int n = this.depth.size();
        TraceabilityPredicate[][][] traceabilityPredicateArrayArray = new TraceabilityPredicate[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            int n3 = this.aisleHeight;
            TraceabilityPredicate[][] traceabilityPredicateArrayArray2 = new TraceabilityPredicate[n3][];
            int n4 = n2;
            TraceabilityPredicate[][][] traceabilityPredicateArrayArray3 = traceabilityPredicateArrayArray;
            for (int j = 0; j < n3; ++j) {
                int n5 = j;
                int n6 = 0;
                int n7 = this.rowWidth;
                TraceabilityPredicate[] traceabilityPredicateArray = new TraceabilityPredicate[n7];
                int n8 = n5;
                TraceabilityPredicate[][] traceabilityPredicateArrayArray4 = traceabilityPredicateArrayArray2;
                while (n6 < n7) {
                    int n9 = n6++;
                    Intrinsics.checkNotNull((Object)this.symbolMap.get(Character.valueOf(this.depth.get(n2)[n5].charAt(n9))));
                }
                traceabilityPredicateArrayArray4[n8] = traceabilityPredicateArray;
            }
            traceabilityPredicateArrayArray3[n4] = traceabilityPredicateArrayArray2;
        }
        return traceabilityPredicateArrayArray;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkMissingPredicates() {
        void $this$filterTo$iv$iv;
        Map<Character, TraceabilityPredicate> $this$filter$iv = this.symbolMap;
        boolean $i$f$filter = false;
        Map<Character, TraceabilityPredicate> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(it.getValue() == null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Set missing = destination$iv$iv.keySet();
        if (!missing.isEmpty()) {
            boolean bl = false;
            String string = "Predicates for character(s) " + CollectionsKt.joinToString$default((Iterable)missing, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + " are missing";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ NNFactoryPattern(RelativeDirection charDir, RelativeDirection stringDir, RelativeDirection aisleDir, DefaultConstructorMarker $constructor_marker) {
        this(charDir, stringDir, aisleDir);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Ldev/arbor/gtnn/api/pattern/NNFactoryPattern$Companion;", "", "<init>", "()V", "start", "Ldev/arbor/gtnn/api/pattern/NNFactoryPattern;", "charDir", "Lcom/gregtechceu/gtceu/api/pattern/util/RelativeDirection;", "stringDir", "aisleDir", "gtnn-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NNFactoryPattern start() {
            return new NNFactoryPattern(RelativeDirection.LEFT, RelativeDirection.UP, RelativeDirection.FRONT, null);
        }

        @NotNull
        public final NNFactoryPattern start(@NotNull RelativeDirection charDir, @NotNull RelativeDirection stringDir, @NotNull RelativeDirection aisleDir) {
            Intrinsics.checkNotNullParameter((Object)charDir, (String)"charDir");
            Intrinsics.checkNotNullParameter((Object)stringDir, (String)"stringDir");
            Intrinsics.checkNotNullParameter((Object)aisleDir, (String)"aisleDir");
            return new NNFactoryPattern(charDir, stringDir, aisleDir, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RelativeDirection.values().length];
            try {
                nArray[RelativeDirection.UP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelativeDirection.DOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelativeDirection.LEFT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelativeDirection.RIGHT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelativeDirection.FRONT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelativeDirection.BACK.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

