/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.api.recipe;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.gregtechceu.gtceu.client.ClientProxy;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import dev.arbor.gtnn.GTNN;
import dev.arbor.gtnn.data.GTNNMaterials;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J.\u0010\u001d\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u001e2\u0018\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H\u001e0\t0\b2\u0006\u0010 \u001a\u00020\u000eJ\u000e\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000eJ:\u0010#\u001a6\u00122\u00120\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000e0%j\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000e`&0\t0$R\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000RY\u0010\u0007\u001aJ\u0012F\u0012D\u0012.\u0012,\u0012(\u0012&\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0018\u00010\u000b0\u000b0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\t0\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001f\u0010\u0012\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00130\u00130\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0011RV\u0010\u0015\u001aD\u0012(\u0012&\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0018\u00010\u000b0\u000b\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\t0\b0\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Ldev/arbor/gtnn/api/recipe/OresHelper;", "", "<init>", "()V", "ORE_REPLACEMENTS", "", "Lcom/gregtechceu/gtceu/api/data/chemical/material/Material;", "ORES_WEIGHTED", "", "Lkotlin/Pair;", "", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/Level;", "kotlin.jvm.PlatformType", "", "Lnet/minecraft/world/item/ItemStack;", "getORES_WEIGHTED", "()Ljava/util/List;", "ALLOW_ITEM", "Lnet/minecraft/world/item/Item;", "getALLOW_ITEM", "ORES_CLEAN", "", "getORES_CLEAN", "()Ljava/util/Map;", "getChance", "oreDefinition", "Lcom/gregtechceu/gtceu/api/data/worldgen/GTOreDefinition;", "getContainedOresAndBlocks", "getRandomItem", "T", "randomList", "size", "getRigMultiplier", "tier", "getOreCleanList", "", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "gtnn-1.20.1"})
@SourceDebugExtension(value={"SMAP\nOresHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OresHelper.kt\ndev/arbor/gtnn/api/recipe/OresHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1563#2:115\n1634#2,3:116\n1374#2:119\n1460#2,2:120\n3550#2,7:122\n1462#2,3:129\n1563#2:132\n1634#2,3:133\n1374#2:136\n1460#2,2:137\n1563#2:139\n1634#2,3:140\n1462#2,3:143\n1504#2:146\n1534#2,3:147\n1537#2,3:157\n1252#2,4:162\n1563#2:166\n1634#2,3:167\n384#3,7:150\n465#3:160\n415#3:161\n1#4:170\n*S KotlinDebug\n*F\n+ 1 OresHelper.kt\ndev/arbor/gtnn/api/recipe/OresHelper\n*L\n20#1:115\n20#1:116,3\n22#1:119\n22#1:120,2\n26#1:122,7\n22#1:129,3\n30#1:132\n30#1:133,3\n32#1:136\n32#1:137,2\n33#1:139\n33#1:140,3\n32#1:143,3\n36#1:146\n36#1:147,3\n36#1:157,3\n36#1:162,4\n65#1:166\n65#1:167,3\n36#1:150,7\n36#1:160\n36#1:161\n*E\n"})
public final class OresHelper {
    @NotNull
    public static final OresHelper INSTANCE = new OresHelper();
    @JvmField
    @NotNull
    public static final Map<Material, Material> ORE_REPLACEMENTS;

    private OresHelper() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<Set<ResourceKey<Level>>, Pair<Integer, ItemStack>>> getORES_WEIGHTED() {
        void $this$flatMapTo$iv$iv;
        Pair it;
        Iterable $this$mapTo$iv$iv;
        Collection collection = ClientProxy.CLIENT_ORE_VEINS.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            GTOreDefinition gTOreDefinition = (GTOreDefinition)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Set set = it.dimensionFilter();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"dimensionFilter(...)");
            Set set2 = CollectionsKt.toSet((Iterable)set);
            Integer n = it.weight();
            Intrinsics.checkNotNull((Object)it);
            collection2.add(TuplesKt.to((Object)set2, (Object)TuplesKt.to((Object)n, (Object)TuplesKt.to(INSTANCE.getChance((GTOreDefinition)it), INSTANCE.getContainedOresAndBlocks((GTOreDefinition)it)))));
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            Set dimensions = (Set)it.component1();
            Pair pair = (Pair)it.component2();
            int weight = ((Number)pair.component1()).intValue();
            Pair pair2 = (Pair)pair.component2();
            List chances = (List)pair2.component1();
            List ores = (List)pair2.component2();
            Iterable $this$zip$iv = chances;
            boolean $i$f$zip = false;
            Iterator first$iv = $this$zip$iv.iterator();
            Iterator second$iv = ((Iterable)ores).iterator();
            ArrayList<Pair> list$iv = new ArrayList<Pair>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10), CollectionsKt.collectionSizeOrDefault((Iterable)ores, (int)10)));
            while (first$iv.hasNext() && second$iv.hasNext()) {
                void ore;
                void chance;
                ItemStack itemStack = (ItemStack)second$iv.next();
                int n = ((Number)first$iv.next()).intValue();
                ArrayList<Pair> arrayList = list$iv;
                boolean bl2 = false;
                arrayList.add(new Pair((Object)dimensions, (Object)TuplesKt.to((Object)(weight * chance), (Object)ore)));
            }
            Iterable list$iv$iv = list$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Item> getALLOW_ITEM() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getORES_WEIGHTED();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((ItemStack)((Pair)it.getSecond()).getSecond()).m_41720_());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ResourceKey<Level>, List<Pair<Integer, ItemStack>>> getORES_CLEAN() {
        void $this$mapValuesTo$iv$iv;
        Object object;
        Object key$iv$iv;
        Object $this$groupByTo$iv$iv;
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getORES_WEIGHTED();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            Pair weightedPair = (Pair)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = (Iterable)weightedPair.getFirst();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void resourceKey;
                ResourceKey resourceKey2 = (ResourceKey)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)resourceKey, (Object)weightedPair.getSecond()));
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object object2;
            Object element$iv$iv;
            element$iv$iv = iterator.next();
            Pair it2 = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-OresHelper$ORES_CLEAN$42 = false;
            key$iv$iv = (ResourceKey)it2.getFirst();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object2;
            Pair $i$a$-groupBy-OresHelper$ORES_CLEAN$42 = (Pair)element$iv$iv;
            object = list$iv$iv;
            boolean bl = false;
            object.add((Pair)it.getSecond());
        }
        Object $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object object3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = object3;
            boolean bl3 = false;
            List value = (List)entry.getValue();
            List list = CollectionsKt.toList((Iterable)value);
            object.put(k, list);
        }
        return destination$iv$iv;
    }

    private final List<Integer> getChance(GTOreDefinition oreDefinition) {
        IntList intList = oreDefinition.veinGenerator().getAllChances();
        Intrinsics.checkNotNullExpressionValue((Object)intList, (String)"getAllChances(...)");
        return (List)intList;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ItemStack> getContainedOresAndBlocks(GTOreDefinition oreDefinition) {
        void $this$mapTo$iv$iv;
        List list = oreDefinition.veinGenerator().getAllEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllEntries(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void entry;
            VeinGenerator.VeinEntry veinEntry = (VeinGenerator.VeinEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((ItemStack)entry.map(OresHelper::getContainedOresAndBlocks$lambda$11$lambda$9, OresHelper::getContainedOresAndBlocks$lambda$11$lambda$10));
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    public final <T> int getRandomItem(@NotNull List<? extends Pair<Integer, ? extends T>> randomList, int size) {
        Intrinsics.checkNotNullParameter(randomList, (String)"randomList");
        if (randomList.isEmpty()) {
            return -1;
        }
        int[] baseOffsets = new int[size];
        int currentIndex = 0;
        for (int i = 0; i < size; ++i) {
            Pair<Integer, ? extends T> entry = randomList.get(i);
            if (!(((Number)entry.getFirst()).intValue() > 0)) {
                boolean bl = false;
                String string = "Invalid weight: " + entry.getFirst();
                throw new IllegalArgumentException(string.toString());
            }
            baseOffsets[i] = currentIndex += ((Number)entry.getFirst()).intValue();
        }
        int randomValue = GTValues.RNG.m_188503_(currentIndex);
        for (int i = 0; i < size; ++i) {
            if (randomValue >= baseOffsets[i]) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid weight");
    }

    public final int getRigMultiplier(int tier) {
        if (tier == 2) {
            return 8;
        }
        if (tier == 3) {
            return 32;
        }
        if (tier == 4) {
            return 64;
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<ResourceKey<Level>, HashMap<ItemStack, Integer>>> getOreCleanList() {
        Set<ResourceKey<Level>> levels = this.getORES_CLEAN().keySet();
        List all = new ArrayList();
        for (ResourceKey<Level> level : levels) {
            void var8_9;
            HashMap things = new HashMap();
            List<Pair<Integer, ItemStack>> list = this.getORES_CLEAN().get(level);
            Intrinsics.checkNotNull(list);
            Iterable iterable = list;
            boolean n = false;
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                void it;
                Object t = iterator.next();
                Pair pair = (Pair)t;
                void var13_17 = var8_9;
                boolean bl = false;
                int n2 = ((Number)it.getFirst()).intValue();
                var8_9 = var13_17 + n2;
            }
            void sum = var8_9;
            List<Pair<Integer, ItemStack>> list2 = this.getORES_CLEAN().get(level);
            Intrinsics.checkNotNull(list2);
            for (Pair pair : list2) {
                int chance = ((Number)pair.getFirst()).intValue() * 10000 / sum;
                ItemStack stack = new ItemStack((ItemLike)((ItemStack)pair.getSecond()).m_41720_(), 1);
                if (stack.m_41619_()) continue;
                Integer n3 = chance;
                ((Map)things).put(stack, n3);
            }
            all.add(TuplesKt.to(level, things));
        }
        return all;
    }

    private static final ItemStack getContainedOresAndBlocks$lambda$11$lambda$9(BlockState it) {
        return ItemStack.f_41583_;
    }

    private static final ItemStack getContainedOresAndBlocks$lambda$11$lambda$10(Material material) {
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        return ChemicalHelper.get((TagPrefix)TagPrefix.rawOre, (Material)material);
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)GTMaterials.Neutronium, (Object)GTNNMaterials.NeutroniumMixture)};
        ORE_REPLACEMENTS = MapsKt.mutableMapOf((Pair[])objectArray);
        if (GTNN.getServerConfig().enableHarderNaquadahLine) {
            objectArray = new Pair[]{TuplesKt.to((Object)GTMaterials.Naquadah, (Object)GTNNMaterials.NaquadahOxideMixture), TuplesKt.to((Object)GTMaterials.NaquadahEnriched, (Object)GTNNMaterials.EnrichedNaquadahOxideMixture), TuplesKt.to((Object)GTMaterials.Naquadria, (Object)GTNNMaterials.NaquadriaOxideMixture)};
            MapsKt.putAll(ORE_REPLACEMENTS, (Iterable)CollectionsKt.listOf((Object[])objectArray));
        }
        if (GTNN.getServerConfig().enableHarderPlatinumLine) {
            objectArray = new Pair[]{TuplesKt.to((Object)GTMaterials.Platinum, (Object)GTNNMaterials.PlatinumMetal), TuplesKt.to((Object)GTMaterials.Palladium, (Object)GTNNMaterials.PalladiumMetal)};
            MapsKt.putAll(ORE_REPLACEMENTS, (Iterable)CollectionsKt.listOf((Object[])objectArray));
        }
    }
}

