/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.api.registry;

import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import dev.arbor.gtnn.api.registry.GTRecipeEvent;
import dev.arbor.gtnn.mixin.gt.GTRecipeTypeAccessor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\tJ\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007J\b\u0010\u0014\u001a\u00020\u0010H\u0007J\b\u0010\u0015\u001a\u00020\u0010H\u0007R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldev/arbor/gtnn/api/registry/GTRecipeManager;", "", "<init>", "()V", "filterMap", "", "Lcom/gregtechceu/gtceu/api/recipe/GTRecipeType;", "", "Ljava/util/function/Predicate;", "Lcom/gregtechceu/gtceu/data/recipe/builder/GTRecipeBuilder;", "removed", "", "shouldRemove", "type", "builder", "onGTRecipeAddition", "", "provider", "Ljava/util/function/Consumer;", "Lnet/minecraft/data/recipes/FinishedRecipe;", "onGTPostInitialization", "onCommonSetup", "gtnn-1.20.1"})
@SourceDebugExtension(value={"SMAP\nGTRecipeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GTRecipeManager.kt\ndev/arbor/gtnn/api/registry/GTRecipeManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n216#2,2:62\n1869#3,2:64\n*S KotlinDebug\n*F\n+ 1 GTRecipeManager.kt\ndev/arbor/gtnn/api/registry/GTRecipeManager\n*L\n46#1:62,2\n50#1:64,2\n*E\n"})
public final class GTRecipeManager {
    @NotNull
    public static final GTRecipeManager INSTANCE = new GTRecipeManager();
    @NotNull
    private static final Map<GTRecipeType, List<Predicate<GTRecipeBuilder>>> filterMap = new HashMap();
    private static boolean removed;

    private GTRecipeManager() {
    }

    public final boolean shouldRemove(@NotNull GTRecipeType type, @NotNull GTRecipeBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (removed) {
            return false;
        }
        List<Predicate<GTRecipeBuilder>> list = filterMap.get(type);
        if (list != null) {
            for (Predicate<GTRecipeBuilder> filter : list) {
                if (!filter.test(builder)) continue;
                return true;
            }
        }
        return false;
    }

    @ApiStatus.Internal
    public final void onGTRecipeAddition(@NotNull Consumer<FinishedRecipe> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        removed = true;
        MinecraftForge.EVENT_BUS.post((Event)new GTRecipeEvent.AddRecipe(provider));
        removed = false;
    }

    @ApiStatus.Internal
    public final void onGTPostInitialization() {
        Map map = new HashMap();
        ModLoader.get().postEvent((Event)new GTRecipeEvent.RegisterHandler(map));
        ImmutableMap handlerList = ImmutableMap.copyOf((Map)map);
        Intrinsics.checkNotNull((Object)handlerList);
        Map $this$forEach$iv = (Map)handlerList;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            GTRecipeType type = (GTRecipeType)entry.getKey();
            List list = (List)entry.getValue();
            Intrinsics.checkNotNull((Object)type, (String)"null cannot be cast to non-null type dev.arbor.gtnn.mixin.gt.GTRecipeTypeAccessor");
            BiConsumer save = ((GTRecipeTypeAccessor)type).getRecipeBuilder().onSave;
            if (save != null) {
                list.add(save);
            }
            type.onRecipeBuild((arg_0, arg_1) -> GTRecipeManager.onGTPostInitialization$lambda$2$lambda$1(list, arg_0, arg_1));
        }
    }

    @ApiStatus.Internal
    public final void onCommonSetup() {
        ModLoader.get().postEvent((Event)new GTRecipeEvent.RemoveRecipe(filterMap));
    }

    private static final void onGTPostInitialization$lambda$2$lambda$1(List $list, GTRecipeBuilder builder, Consumer consumer) {
        Intrinsics.checkNotNull((Object)$list);
        Iterable $this$forEach$iv = $list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BiConsumer c = (BiConsumer)element$iv;
            boolean bl = false;
            c.accept(builder, consumer);
        }
    }
}

