/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.arbor.gtnn.GTNN;
import java.util.Random;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 -2\u00020\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JH\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0002J(\u0010!\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0002J(\u0010$\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007H\u0002J@\u0010(\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Ldev/arbor/gtnn/client/renderer/ExtraHeartRenderHandler;", "", "<init>", "()V", "mc", "Lnet/minecraft/client/Minecraft;", "playerHealth", "", "lastPlayerHealth", "healthUpdateCounter", "", "lastSystemTime", "rand", "Ljava/util/Random;", "regen", "blit", "", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "texture", "Lnet/minecraft/resources/ResourceLocation;", "x", "y", "textureX", "textureY", "width", "height", "renderHealthbar", "event", "Lnet/minecraftforge/client/event/RenderGuiOverlayEvent$Pre;", "getPotionOffset", "player", "Lnet/minecraft/world/entity/player/Player;", "renderExtraHearts", "xBasePos", "yBasePos", "renderExtraAbsorption", "getYRegenOffset", "i", "offset", "renderCustomHearts", "potionOffset", "count", "absorb", "", "Companion", "gtnn-1.20.1"})
public final class ExtraHeartRenderHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Minecraft mc;
    private int playerHealth;
    private int lastPlayerHealth;
    private long healthUpdateCounter;
    private long lastSystemTime;
    @NotNull
    private final Random rand;
    private int regen;
    @NotNull
    private static final ResourceLocation ICON_HEARTS = GTNN.INSTANCE.id("textures/gui/hearts.png");
    @NotNull
    private static final ResourceLocation ICON_ABSORB = GTNN.INSTANCE.id("textures/gui/absorb.png");
    @NotNull
    private static final ResourceLocation ICON_VANILLA = new ResourceLocation("textures/gui/icons.png");

    public ExtraHeartRenderHandler() {
        Minecraft minecraft = Minecraft.m_91087_();
        Intrinsics.checkNotNullExpressionValue((Object)minecraft, (String)"getInstance(...)");
        this.mc = minecraft;
        this.rand = new Random();
    }

    private final void blit(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int textureX, int textureY, int width, int height) {
        guiGraphics.m_280218_(texture, x, y, textureX, textureY, width, height);
    }

    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=true)
    public final void renderHealthbar(@NotNull RenderGuiOverlayEvent.Pre event) {
        boolean bl;
        AttributeInstance attrMaxHealth;
        boolean highlight;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        GuiGraphics guiGraphics = event.getGuiGraphics();
        if (event.isCanceled() || !GTNN.getClientConfig().extraHeartRenderer || event.getOverlay() != VanillaGuiOverlay.PLAYER_HEALTH.type()) {
            return;
        }
        Gui gui = this.mc.f_91065_;
        if (!(gui instanceof ForgeGui) || this.mc.f_91066_.f_92062_ || !((ForgeGui)gui).shouldDrawSurvivalElements()) {
            return;
        }
        Entity entity = this.mc.m_91288_();
        Player player = entity instanceof Player ? (Player)entity : null;
        if (player == null) {
            return;
        }
        Player player2 = player;
        ((ForgeGui)gui).setupOverlayRenderState(true, false);
        this.mc.m_91307_().m_6180_("health");
        int leftHeight = ((ForgeGui)gui).leftHeight;
        int width = this.mc.m_91268_().m_85445_();
        int height = this.mc.m_91268_().m_85446_();
        int updateCounter = this.mc.f_91065_.m_93079_();
        int health = Mth.m_14167_((float)player2.m_21223_());
        boolean bl2 = highlight = this.healthUpdateCounter > (long)updateCounter && (this.healthUpdateCounter - (long)updateCounter) / 3L % 2L == 1L;
        if (health < this.playerHealth && player2.f_19802_ > 0) {
            this.lastSystemTime = Util.m_137550_();
            this.healthUpdateCounter = updateCounter + 20;
        } else if (health > this.playerHealth && player2.f_19802_ > 0) {
            this.lastSystemTime = Util.m_137550_();
            this.healthUpdateCounter = updateCounter + 10;
        }
        if (Util.m_137550_() - this.lastSystemTime > 1000L) {
            this.playerHealth = health;
            this.lastPlayerHealth = health;
            this.lastSystemTime = Util.m_137550_();
        }
        this.playerHealth = health;
        int healthLast = this.lastPlayerHealth;
        AttributeInstance attributeInstance = attrMaxHealth = player2.m_21051_(Attributes.f_22276_);
        float healthMax = attributeInstance != null ? (float)attributeInstance.m_22135_() : 0.0f;
        float absorb = Mth.m_14167_((float)player2.m_6103_());
        healthMax = (float)Math.min((double)healthMax, 20.0);
        health = (int)Math.min((double)health, 20.0);
        absorb = (float)Math.min((double)absorb, 20.0);
        int healthRows = Mth.m_14167_((float)((healthMax + absorb) / 2.0f / 10.0f));
        int rowHeight = (int)Math.max((double)(10 - (healthRows - 2)), 3.0);
        this.rand.setSeed((long)updateCounter * 312871L);
        int left = width / 2 - 91;
        int top = height - leftHeight;
        this.regen = -1;
        if (player2.m_21023_(MobEffects.f_19605_)) {
            this.regen = updateCounter % 25;
        }
        boolean bl3 = bl = this.mc.f_91073_ != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ClientLevel clientLevel = this.mc.f_91073_;
        Intrinsics.checkNotNull((Object)clientLevel);
        int textureY = 9 * (clientLevel.m_6106_().m_5466_() ? 5 : 0);
        int textureX = highlight ? 25 : 16;
        int margin = 16;
        if (player2.m_21023_(MobEffects.f_19614_)) {
            margin += 36;
        } else if (player2.m_21023_(MobEffects.f_19615_)) {
            margin += 72;
        }
        float absorbRemaining = absorb;
        for (int i = Mth.m_14167_((float)((healthMax + absorb) / 2.0f)) - 1; -1 < i; --i) {
            int row = Mth.m_14167_((float)((float)(i + 1) / 10.0f)) - 1;
            int x = left + i % 10 * 8;
            int y = top - row * rowHeight;
            if (health <= 4) {
                y += this.rand.nextInt(2);
            }
            if (i == this.regen) {
                y -= 2;
            }
            Intrinsics.checkNotNull((Object)guiGraphics);
            this.blit(guiGraphics, ICON_VANILLA, x, y, textureX, textureY, 9, 9);
            if (highlight) {
                if (i * 2 + 1 < healthLast) {
                    this.blit(guiGraphics, ICON_VANILLA, x, y, margin + 54, textureY, 9, 9);
                } else if (i * 2 + 1 == healthLast) {
                    this.blit(guiGraphics, ICON_VANILLA, x, y, margin + 63, textureY, 9, 9);
                }
            }
            if (absorbRemaining > 0.0f) {
                if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                    this.blit(guiGraphics, ICON_VANILLA, x, y, margin + 153, textureY, 9, 9);
                    absorbRemaining -= 1.0f;
                    continue;
                }
                this.blit(guiGraphics, ICON_VANILLA, x, y, margin + 144, textureY, 9, 9);
                absorbRemaining -= 2.0f;
                continue;
            }
            if (i * 2 + 1 < health) {
                this.blit(guiGraphics, ICON_VANILLA, x, y, margin + 36, textureY, 9, 9);
                continue;
            }
            if (i * 2 + 1 != health) continue;
            this.blit(guiGraphics, ICON_VANILLA, x, y, margin + 45, textureY, 9, 9);
        }
        Intrinsics.checkNotNull((Object)guiGraphics);
        this.renderExtraHearts(guiGraphics, left, top, player2);
        this.renderExtraAbsorption(guiGraphics, left, top - rowHeight, player2);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICON_VANILLA);
        ForgeGui forgeGui = (ForgeGui)gui;
        forgeGui.leftHeight += 10;
        if (absorb > 0.0f) {
            forgeGui = (ForgeGui)gui;
            forgeGui.leftHeight += 10;
        }
        event.setCanceled(true);
        RenderSystem.disableBlend();
        this.mc.m_91307_().m_7238_();
        MinecraftForge.EVENT_BUS.post((Event)new RenderGuiOverlayEvent.Post(event.getWindow(), guiGraphics, event.getPartialTick(), VanillaGuiOverlay.PLAYER_HEALTH.type()));
    }

    private final int getPotionOffset(Player player) {
        boolean bl;
        int potionOffset = 0;
        MobEffectInstance potion = player.m_21124_(MobEffects.f_19615_);
        if (potion != null) {
            potionOffset = 18;
        }
        if ((potion = player.m_21124_(MobEffects.f_19614_)) != null) {
            potionOffset = 9;
        }
        boolean bl2 = bl = this.mc.f_91073_ != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ClientLevel clientLevel = this.mc.f_91073_;
        Intrinsics.checkNotNull((Object)clientLevel);
        if (clientLevel.m_6106_().m_5466_()) {
            potionOffset += 27;
        }
        return potionOffset;
    }

    private final void renderExtraHearts(GuiGraphics guiGraphics, int xBasePos, int yBasePos, Player player) {
        int potionOffset = this.getPotionOffset(player);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICON_HEARTS);
        int hp = Mth.m_14167_((float)player.m_21223_());
        this.renderCustomHearts(guiGraphics, ICON_HEARTS, xBasePos, yBasePos, potionOffset, hp, false);
    }

    private final void renderExtraAbsorption(GuiGraphics guiGraphics, int xBasePos, int yBasePos, Player player) {
        int potionOffset = this.getPotionOffset(player);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICON_ABSORB);
        int absorb = Mth.m_14167_((float)player.m_6103_());
        this.renderCustomHearts(guiGraphics, ICON_ABSORB, xBasePos, yBasePos, potionOffset, absorb, true);
    }

    private final int getYRegenOffset(int i, int offset) {
        return i + offset == this.regen ? -2 : 0;
    }

    private final void renderCustomHearts(GuiGraphics guiGraphics, ResourceLocation texture, int xBasePos, int yBasePos, int potionOffset, int count, boolean absorb) {
        int regenOffset = absorb ? 10 : 0;
        int n = count / 20;
        for (int iter = 0; iter < n; ++iter) {
            int renderHearts = (count - 20 * (iter + 1)) / 2;
            int heartIndex = iter % 11;
            if (renderHearts > 10) {
                renderHearts = 10;
            }
            int n2 = renderHearts;
            for (int i = 0; i < n2; ++i) {
                int y = this.getYRegenOffset(i, regenOffset);
                if (absorb) {
                    this.blit(guiGraphics, texture, xBasePos + 8 * i, yBasePos + y, 0, 54, 9, 9);
                }
                this.blit(guiGraphics, texture, xBasePos + 8 * i, yBasePos + y, 18 * heartIndex, potionOffset, 9, 9);
            }
            if (count % 2 != 1 || renderHearts >= 10) continue;
            int y = this.getYRegenOffset(renderHearts, regenOffset);
            if (absorb) {
                this.blit(guiGraphics, texture, xBasePos + 8 * renderHearts, yBasePos + y, 0, 54, 9, 9);
            }
            this.blit(guiGraphics, texture, xBasePos + 8 * renderHearts, yBasePos + y, 9 + 18 * heartIndex, potionOffset, 9, 9);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ldev/arbor/gtnn/client/renderer/ExtraHeartRenderHandler$Companion;", "", "<init>", "()V", "ICON_HEARTS", "Lnet/minecraft/resources/ResourceLocation;", "ICON_ABSORB", "ICON_VANILLA", "gtnn-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

