/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.client.renderer.item;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.item.component.ICustomRenderer;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.arbor.gtnn.GTNN;
import dev.arbor.gtnn.api.item.INNItemRendererProvider;
import dev.arbor.gtnn.client.renderer.item.INumberSuperscriptEffect;
import dev.arbor.gtnn.client.renderer.item.IVoltageSuperscriptEffect;
import dev.arbor.gtnn.client.renderer.item.WrappedItemRenderer;
import dev.arbor.gtnn.extension.RenderOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JH\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eH\u0017R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ldev/arbor/gtnn/client/renderer/item/SuperscriptItemRenderer;", "Ldev/arbor/gtnn/client/renderer/item/WrappedItemRenderer;", "<init>", "()V", "voltageTextures", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lnet/minecraft/resources/ResourceLocation;", "numberTextures", "romaNumberTextures", "renderItem", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "transformType", "Lnet/minecraft/world/item/ItemDisplayContext;", "leftHand", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "combinedLight", "", "combinedOverlay", "model", "Lnet/minecraft/client/resources/model/BakedModel;", "getTexture", "onPrepareTextureAtlas", "atlasName", "register", "Ljava/util/function/Consumer;", "gtnn-1.20.1"})
public final class SuperscriptItemRenderer
extends WrappedItemRenderer {
    @NotNull
    private final Int2ObjectOpenHashMap<ResourceLocation> voltageTextures = new Int2ObjectOpenHashMap();
    @NotNull
    private final Int2ObjectOpenHashMap<ResourceLocation> numberTextures = new Int2ObjectOpenHashMap();
    @NotNull
    private final Int2ObjectOpenHashMap<ResourceLocation> romaNumberTextures = new Int2ObjectOpenHashMap();

    public SuperscriptItemRenderer() {
        if (Platform.isClient()) {
            this.registerEvent();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderItem(@NotNull ItemStack stack, @NotNull ItemDisplayContext transformType, boolean leftHand, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay, @NotNull BakedModel model) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)transformType, (String)"transformType");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        BakedModel vanillaModel = this.getVanillaModel(stack, null, null);
        ResourceLocation texture = this.getTexture(stack);
        if (transformType == ItemDisplayContext.GUI && texture != null) {
            Tesselator tess = Tesselator.m_85913_();
            MultiBufferSource.BufferSource immediateBuffer = MultiBufferSource.m_109898_((BufferBuilder)tess.m_85915_());
            Intrinsics.checkNotNull((Object)immediateBuffer);
            this.vanillaRender(stack, transformType, leftHand, poseStack, (MultiBufferSource)immediateBuffer, combinedLight, combinedOverlay, vanillaModel);
            immediateBuffer.m_109911_();
            BufferBuilder buf = tess.m_85915_();
            buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            poseStack.m_85836_();
            poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
            RenderSystem.setShader(SuperscriptItemRenderer::renderItem$lambda$0);
            TextureAtlasSprite sprite = ModelFactory.getBlockSprite((ResourceLocation)texture);
            RenderOps.INSTANCE.bindBlockAtlas();
            float minU = sprite.m_118409_();
            float maxU = sprite.m_118410_();
            float minV = sprite.m_118411_();
            float maxV = sprite.m_118412_();
            Matrix4f posMatrix = poseStack.m_85850_().m_252922_();
            buf.m_252986_(posMatrix, 1.0f, 1.0f, 0.0f).m_7421_(maxU, minV).m_5752_();
            buf.m_252986_(posMatrix, 0.0f, 1.0f, 0.0f).m_7421_(minU, minV).m_5752_();
            buf.m_252986_(posMatrix, 0.0f, 0.0f, 0.0f).m_7421_(minU, maxV).m_5752_();
            buf.m_252986_(posMatrix, 1.0f, 0.0f, 0.0f).m_7421_(maxU, maxV).m_5752_();
            tess.m_85914_();
            poseStack.m_85849_();
        } else {
            this.vanillaRender(stack, transformType, leftHand, poseStack, buffer, combinedLight, combinedOverlay, model);
        }
    }

    private final ResourceLocation getTexture(ItemStack stack) {
        if (stack.m_41720_() instanceof INNItemRendererProvider) {
            Item item = stack.m_41720_();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type dev.arbor.gtnn.api.item.INNItemRendererProvider");
            INNItemRendererProvider provider = (INNItemRendererProvider)item;
            ICustomRenderer info = provider.getRenderInfo(stack);
            return info instanceof INumberSuperscriptEffect ? (((INumberSuperscriptEffect)info).isRoma() ? (ResourceLocation)this.romaNumberTextures.get(((INumberSuperscriptEffect)info).getTier()) : (ResourceLocation)this.numberTextures.get(((INumberSuperscriptEffect)info).getTier())) : (info instanceof IVoltageSuperscriptEffect ? (ResourceLocation)this.voltageTextures.get(((IVoltageSuperscriptEffect)info).getTier()) : null);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onPrepareTextureAtlas(@NotNull ResourceLocation atlasName, @NotNull Consumer<ResourceLocation> register2) {
        Intrinsics.checkNotNullParameter((Object)atlasName, (String)"atlasName");
        Intrinsics.checkNotNullParameter(register2, (String)"register");
        if (Intrinsics.areEqual((Object)atlasName, (Object)InventoryMenu.f_39692_)) {
            for (int i = 0; i < 15; ++i) {
                ResourceLocation voltageId = GTNN.INSTANCE.id("superscript/voltage/" + GTValues.VN[i]);
                register2.accept(voltageId);
                Integer n = i;
                ((Map)this.voltageTextures).put(n, voltageId);
                ResourceLocation numberId = GTNN.INSTANCE.id("superscript/number/" + (i + 1));
                register2.accept(numberId);
                ((Map)this.numberTextures).put(i + 1, numberId);
                ResourceLocation romaNumberId = GTNN.INSTANCE.id("superscript/number/roman/" + (i + 1));
                register2.accept(romaNumberId);
                ((Map)this.romaNumberTextures).put(i + 1, romaNumberId);
            }
        }
    }

    private static final ShaderInstance renderItem$lambda$0() {
        return GameRenderer.m_172817_();
    }
}

