/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.common.item.behaviors;

import com.google.common.base.Joiner;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.component.IItemUIFactory;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.factory.HeldItemUIFactory;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import dev.arbor.gtnn.GTNN;
import dev.arbor.gtnn.api.pattern.DebugBlockPattern;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0016J\u001b\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001bJ\u000e\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#H\u0016J.\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00140%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020,H\u0016\u00a8\u0006-"}, d2={"Ldev/arbor/gtnn/common/item/behaviors/StructureWriteBehavior;", "Lcom/gregtechceu/gtceu/api/item/component/IItemUIFactory;", "<init>", "()V", "createUI", "Lcom/lowdragmc/lowdraglib/gui/modular/ModularUI;", "playerInventoryHolder", "Lcom/lowdragmc/lowdraglib/gui/factory/HeldItemUIFactory$HeldItemHolder;", "entityPlayer", "Lnet/minecraft/world/entity/player/Player;", "export", "", "exportMsg", "", "exportLog", "changeDirX", "changeDirY", "isItemStructureWriter", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "getDir", "Lnet/minecraft/core/Direction;", "setDir", "dir", "getPos", "", "Lnet/minecraft/core/BlockPos;", "(Lnet/minecraft/world/item/ItemStack;)[Lnet/minecraft/core/BlockPos;", "addPos", "pos", "removePos", "onItemUseFirst", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "item", "Lnet/minecraft/world/item/Item;", "level", "Lnet/minecraft/world/level/Level;", "player", "usedHand", "Lnet/minecraft/world/InteractionHand;", "gtnn-1.20.1"})
public final class StructureWriteBehavior
implements IItemUIFactory {
    @NotNull
    public static final StructureWriteBehavior INSTANCE = new StructureWriteBehavior();

    private StructureWriteBehavior() {
    }

    @NotNull
    public ModularUI createUI(@NotNull HeldItemUIFactory.HeldItemHolder playerInventoryHolder, @NotNull Player entityPlayer) {
        Intrinsics.checkNotNullParameter((Object)playerInventoryHolder, (String)"playerInventoryHolder");
        Intrinsics.checkNotNullParameter((Object)entityPlayer, (String)"entityPlayer");
        IGuiTexture[] iGuiTextureArray = new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE};
        Widget container = new WidgetGroup(8, 8, 160, 54).addWidget((Widget)new ImageWidget(4, 4, 152, 46, (IGuiTexture)GuiTextures.DISPLAY)).addWidget((Widget)new LabelWidget(7, 7, () -> StructureWriteBehavior.createUI$lambda$1(playerInventoryHolder)).setTextColor(16447990)).addWidget((Widget)new LabelWidget(7, 20, () -> StructureWriteBehavior.createUI$lambda$2(playerInventoryHolder)).setTextColor(16447990)).setBackground(iGuiTextureArray);
        IGuiTexture[] iGuiTextureArray2 = new IGuiTexture[]{GuiTextures.BACKGROUND};
        ModularUI modularUI = new ModularUI(176, 120, (IUIHolder)playerInventoryHolder, entityPlayer).background(iGuiTextureArray2).widget(container);
        iGuiTextureArray2 = new IGuiTexture[]{GuiTextures.BUTTON, new TextTexture("item.gtnn.debug.structure_writer.export_to_log")};
        ButtonWidget buttonWidget = new ButtonWidget(9, 68, 77, 20, (IGuiTexture)new GuiTextureGroup(iGuiTextureArray2), arg_0 -> StructureWriteBehavior.createUI$lambda$3(playerInventoryHolder, arg_0));
        iGuiTextureArray2 = new IGuiTexture[]{GuiTextures.BUTTON, new TextTexture("item.gtnn.debug.structure_writer.export_to_msg")};
        ButtonWidget buttonWidget2 = new ButtonWidget(90, 68, 77, 20, (IGuiTexture)new GuiTextureGroup(iGuiTextureArray2), arg_0 -> StructureWriteBehavior.createUI$lambda$4(playerInventoryHolder, arg_0));
        iGuiTextureArray2 = new IGuiTexture[]{GuiTextures.BUTTON, new TextTexture("item.gtnn.debug.structure_writer.rotate_along_x_axis")};
        ButtonWidget buttonWidget3 = new ButtonWidget(9, 91, 77, 20, (IGuiTexture)new GuiTextureGroup(iGuiTextureArray2), arg_0 -> StructureWriteBehavior.createUI$lambda$5(playerInventoryHolder, arg_0));
        iGuiTextureArray2 = new IGuiTexture[]{GuiTextures.BUTTON, new TextTexture("item.gtnn.debug.structure_writer.rotate_along_y_axis")};
        ModularUI modularUI2 = modularUI.widget((Widget)buttonWidget).widget((Widget)buttonWidget2).widget((Widget)buttonWidget3).widget((Widget)new ButtonWidget(90, 91, 77, 20, (IGuiTexture)new GuiTextureGroup(iGuiTextureArray2), arg_0 -> StructureWriteBehavior.createUI$lambda$6(playerInventoryHolder, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)modularUI2, (String)"widget(...)");
        return modularUI2;
    }

    private final String export(HeldItemUIFactory.HeldItemHolder playerInventoryHolder) {
        ItemStack itemStack = playerInventoryHolder.held;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"held");
        BlockPos[] blockPosArray = this.getPos(itemStack);
        if (blockPosArray == null) {
            return null;
        }
        BlockPos[] pos = blockPosArray;
        if (!(playerInventoryHolder.player instanceof ServerPlayer)) {
            return null;
        }
        ItemStack itemStack2 = playerInventoryHolder.held;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"held");
        Direction direction = this.getDir(itemStack2);
        StringBuilder builder = new StringBuilder();
        Level level = playerInventoryHolder.player.m_9236_();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        DebugBlockPattern blockPattern = new DebugBlockPattern(level, pos[0].m_123341_(), pos[0].m_123342_(), pos[0].m_123343_(), pos[1].m_123341_(), pos[1].m_123342_(), pos[1].m_123343_());
        RelativeDirection[] dirs = DebugBlockPattern.Companion.getDir(direction);
        blockPattern.changeDir(dirs[0], dirs[1], dirs[2]);
        String[][] stringArray = blockPattern.getPattern();
        int n = ((Object[])stringArray).length;
        for (int i = 0; i < n; ++i) {
            Object[] strings = stringArray[i];
            String string = ".aisle(\"%s\")\n";
            Object[] objectArray = new Object[]{Joiner.on((String)"\", \"").join(strings)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            builder.append(string2);
        }
        return builder.toString();
    }

    private final void exportMsg(HeldItemUIFactory.HeldItemHolder playerInventoryHolder) {
        String message = this.export(playerInventoryHolder);
        if (message == null) {
            return;
        }
        if (!LDLib.isRemote()) {
            playerInventoryHolder.player.m_213846_((Component)Component.m_237113_((String)message));
        }
    }

    private final void exportLog(HeldItemUIFactory.HeldItemHolder playerInventoryHolder) {
        String message = this.export(playerInventoryHolder);
        if (message == null) {
            return;
        }
        GTNN.INSTANCE.getLOGGER().info(message);
    }

    private final void changeDirX(HeldItemUIFactory.HeldItemHolder playerInventoryHolder) {
        ItemStack itemStack = playerInventoryHolder.held;
        Intrinsics.checkNotNull((Object)itemStack);
        if (this.getPos(itemStack) != null && playerInventoryHolder.player instanceof ServerPlayer) {
            Direction direction = this.getDir(itemStack).m_175362_(Direction.Axis.X);
            Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"getClockWise(...)");
            this.setDir(itemStack, direction);
        }
    }

    private final void changeDirY(HeldItemUIFactory.HeldItemHolder playerInventoryHolder) {
        ItemStack itemStack = playerInventoryHolder.held;
        Intrinsics.checkNotNull((Object)itemStack);
        if (this.getPos(itemStack) != null && playerInventoryHolder.player instanceof ServerPlayer) {
            Direction direction = this.getDir(itemStack).m_175362_(Direction.Axis.Y);
            Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"getClockWise(...)");
            this.setDir(itemStack, direction);
        }
    }

    public final boolean isItemStructureWriter(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        Object object = item instanceof ComponentItem ? (ComponentItem)item : null;
        return object != null && (object = object.getComponents()) != null ? object.contains(this) : false;
    }

    @NotNull
    public final Direction getDir(@NotNull ItemStack stack) {
        Direction direction;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        CompoundTag tag = stack.m_41698_("structure_writer");
        if (!tag.m_128441_("dir")) {
            direction = Direction.WEST;
        } else {
            Direction direction2 = Direction.m_122402_((String)tag.m_128461_("dir"));
            direction = direction2;
            Intrinsics.checkNotNull((Object)direction2);
        }
        return direction;
    }

    public final void setDir(@NotNull ItemStack stack, @NotNull Direction dir) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        CompoundTag tag = stack.m_41698_("structure_writer");
        tag.m_128359_("dir", dir.name());
    }

    @Nullable
    public final BlockPos[] getPos(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        CompoundTag tag = stack.m_41698_("structure_writer");
        if (!tag.m_128441_("minX")) {
            return null;
        }
        BlockPos[] blockPosArray = new BlockPos[]{new BlockPos(tag.m_128451_("minX"), tag.m_128451_("minY"), tag.m_128451_("minZ")), new BlockPos(tag.m_128451_("maxX"), tag.m_128451_("maxY"), tag.m_128451_("maxZ"))};
        return blockPosArray;
    }

    public final void addPos(@NotNull ItemStack stack, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        CompoundTag tag = stack.m_41698_("structure_writer");
        if (!tag.m_128441_("minX") || tag.m_128451_("minX") > pos.m_123341_()) {
            tag.m_128405_("minX", pos.m_123341_());
        }
        if (!tag.m_128441_("maxX") || tag.m_128451_("maxX") < pos.m_123341_()) {
            tag.m_128405_("maxX", pos.m_123341_());
        }
        if (!tag.m_128441_("minY") || tag.m_128451_("minY") > pos.m_123342_()) {
            tag.m_128405_("minY", pos.m_123342_());
        }
        if (!tag.m_128441_("maxY") || tag.m_128451_("maxY") < pos.m_123342_()) {
            tag.m_128405_("maxY", pos.m_123342_());
        }
        if (!tag.m_128441_("minZ") || tag.m_128451_("minZ") > pos.m_123343_()) {
            tag.m_128405_("minZ", pos.m_123343_());
        }
        if (!tag.m_128441_("maxZ") || tag.m_128451_("maxZ") < pos.m_123343_()) {
            tag.m_128405_("maxZ", pos.m_123343_());
        }
    }

    public final void removePos(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        CompoundTag tag = stack.m_41698_("structure_writer");
        tag.m_128473_("minX");
        tag.m_128473_("maxX");
        tag.m_128473_("minY");
        tag.m_128473_("maxY");
        tag.m_128473_("minZ");
        tag.m_128473_("maxZ");
    }

    @NotNull
    public InteractionResult onItemUseFirst(@NotNull ItemStack stack, @NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.SUCCESS;
        }
        Player player2 = player;
        ItemStack itemStack = player2.m_21120_(context.m_43724_());
        if (!player2.m_6144_()) {
            Intrinsics.checkNotNull((Object)itemStack);
            BlockPos blockPos = context.m_8083_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getClickedPos(...)");
            this.addPos(itemStack, blockPos);
        } else {
            Intrinsics.checkNotNull((Object)itemStack);
            this.removePos(itemStack);
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Item item, @NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        InteractionResultHolder interactionResultHolder;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack stack = player.m_21120_(usedHand);
        if (player.m_6144_()) {
            Intrinsics.checkNotNull((Object)stack);
            this.removePos(stack);
            InteractionResultHolder interactionResultHolder2 = InteractionResultHolder.m_19090_((Object)stack);
            Intrinsics.checkNotNull((Object)interactionResultHolder2);
            interactionResultHolder = interactionResultHolder2;
        } else {
            if (player instanceof ServerPlayer) {
                HeldItemUIFactory.INSTANCE.openUI((ServerPlayer)player, usedHand);
            }
            InteractionResultHolder interactionResultHolder3 = InteractionResultHolder.m_19090_((Object)stack);
            Intrinsics.checkNotNull((Object)interactionResultHolder3);
            interactionResultHolder = interactionResultHolder3;
        }
        return interactionResultHolder;
    }

    private static final String createUI$lambda$1(HeldItemUIFactory.HeldItemHolder $playerInventoryHolder) {
        int x = 0;
        int y = 0;
        int z = 0;
        ItemStack itemStack = $playerInventoryHolder.held;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"held");
        BlockPos[] blockPosArray = INSTANCE.getPos(itemStack);
        if (blockPosArray != null) {
            BlockPos[] blockPos = blockPosArray;
            boolean bl = false;
            x = 1 + blockPos[1].m_123341_() - blockPos[0].m_123341_();
            y = 1 + blockPos[1].m_123342_() - blockPos[0].m_123342_();
            z = 1 + blockPos[1].m_123343_() - blockPos[0].m_123343_();
        }
        Object[] objectArray = new Object[]{x, y, z};
        return LocalizationUtils.format((String)"item.gtnn.debug.structure_writer.structural_scale", (Object[])objectArray);
    }

    private static final String createUI$lambda$2(HeldItemUIFactory.HeldItemHolder $playerInventoryHolder) {
        ItemStack itemStack = $playerInventoryHolder.held;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"held");
        Direction direction = INSTANCE.getDir(itemStack);
        RelativeDirection[] dirs = DebugBlockPattern.Companion.getDir(direction);
        Object[] objectArray = new Object[]{dirs[0].name(), dirs[1].name(), dirs[2].name()};
        return LocalizationUtils.format((String)"item.gtnn.debug.structure_writer.export_order", (Object[])objectArray);
    }

    private static final void createUI$lambda$3(HeldItemUIFactory.HeldItemHolder $playerInventoryHolder, ClickData it) {
        INSTANCE.exportLog($playerInventoryHolder);
    }

    private static final void createUI$lambda$4(HeldItemUIFactory.HeldItemHolder $playerInventoryHolder, ClickData it) {
        INSTANCE.exportMsg($playerInventoryHolder);
    }

    private static final void createUI$lambda$5(HeldItemUIFactory.HeldItemHolder $playerInventoryHolder, ClickData it) {
        INSTANCE.changeDirX($playerInventoryHolder);
    }

    private static final void createUI$lambda$6(HeldItemUIFactory.HeldItemHolder $playerInventoryHolder, ClickData it) {
        INSTANCE.changeDirY($playerInventoryHolder);
    }
}

