/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.common.item.behaviors;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconSet;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconType;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.ICustomDescriptionId;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.client.renderer.item.TagPrefixItemRenderer;
import com.lowdragmc.lowdraglib.Platform;
import java.util.List;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J0\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Ldev/arbor/gtnn/common/item/behaviors/TagPrefixBehavior;", "Lcom/gregtechceu/gtceu/api/item/component/IAddInformation;", "Lcom/gregtechceu/gtceu/api/item/component/ICustomDescriptionId;", "tagPrefix", "Lcom/gregtechceu/gtceu/api/data/tag/TagPrefix;", "material", "Lcom/gregtechceu/gtceu/api/data/chemical/material/Material;", "<init>", "(Lcom/gregtechceu/gtceu/api/data/tag/TagPrefix;Lcom/gregtechceu/gtceu/api/data/chemical/material/Material;)V", "getMaterial", "()Lcom/gregtechceu/gtceu/api/data/chemical/material/Material;", "onAttached", "", "item", "Lnet/minecraft/world/item/Item;", "appendHoverText", "stack", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "isAdvanced", "Lnet/minecraft/world/item/TooltipFlag;", "getItemName", "Companion", "gtnn-1.20.1"})
public final class TagPrefixBehavior
implements IAddInformation,
ICustomDescriptionId {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TagPrefix tagPrefix;
    @NotNull
    private final Material material;

    public TagPrefixBehavior(@NotNull TagPrefix tagPrefix, @NotNull Material material) {
        Intrinsics.checkNotNullParameter((Object)tagPrefix, (String)"tagPrefix");
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        this.tagPrefix = tagPrefix;
        this.material = material;
    }

    @NotNull
    public final Material getMaterial() {
        return this.material;
    }

    public void onAttached(@NotNull Item item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (Platform.isClient()) {
            TagPrefixItemRenderer.create((Item)item, (MaterialIconType)this.tagPrefix.materialIconType(), (MaterialIconSet)this.material.getMaterialIconSet());
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<? extends Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)isAdvanced, (String)"isAdvanced");
        if (this.tagPrefix.tooltip() != null) {
            BiConsumer biConsumer = this.tagPrefix.tooltip();
            Intrinsics.checkNotNull((Object)biConsumer);
            biConsumer.accept(this.material, tooltipComponents);
        }
    }

    @Nullable
    public Component getItemName(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return (Component)this.tagPrefix.getLocalizedName(this.material);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Ldev/arbor/gtnn/common/item/behaviors/TagPrefixBehavior$Companion;", "", "<init>", "()V", "tintColor", "Lnet/minecraft/client/color/item/ItemColor;", "getBehaviour", "Ldev/arbor/gtnn/common/item/behaviors/TagPrefixBehavior;", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "gtnn-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @OnlyIn(value=Dist.CLIENT)
        @NotNull
        public final ItemColor tintColor() {
            return Companion::tintColor$lambda$0;
        }

        private final TagPrefixBehavior getBehaviour(ItemStack itemStack) {
            ComponentItem componentItem;
            Item item = itemStack.m_41720_();
            ComponentItem componentItem2 = componentItem = item instanceof ComponentItem ? (ComponentItem)item : null;
            if (componentItem != null) {
                for (IItemComponent component : componentItem.getComponents()) {
                    if (!(component instanceof TagPrefixBehavior)) continue;
                    return (TagPrefixBehavior)component;
                }
            }
            return null;
        }

        private static final int tintColor$lambda$0(ItemStack itemStack, int index) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            TagPrefixBehavior behavior = Companion.getBehaviour(itemStack);
            if (behavior != null) {
                return behavior.getMaterial().getLayerARGB(index);
            }
            return -1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

