/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.common.machine.multiblock;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.pattern.util.PatternMatchContext;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import dev.arbor.gtnn.api.block.ITierType;
import dev.arbor.gtnn.api.machine.feature.IGTPPMachine;
import dev.arbor.gtnn.api.machine.feature.IGTPPRenderMachine;
import dev.arbor.gtnn.api.pattern.TraceabilityPredicateEx;
import dev.arbor.gtnn.data.block.NNBlockMaps;
import dev.arbor.gtnn.data.pattern.NNPredicates;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 /2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001/B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0014J\u0018\u0010\u0019\u001a\u00020\u00122\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001bH\u0016J\u0006\u0010\u001f\u001a\u00020\tJ*\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0016J8\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020(2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010.\u001a\u00020!H\u0016R\u001e\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000b\u00a8\u00060"}, d2={"Ldev/arbor/gtnn/common/machine/multiblock/ChemicalPlantMachine;", "Lcom/gregtechceu/gtceu/api/machine/multiblock/WorkableElectricMultiblockMachine;", "Ldev/arbor/gtnn/api/machine/feature/IGTPPMachine;", "Ldev/arbor/gtnn/api/machine/feature/IGTPPRenderMachine;", "holder", "Lcom/gregtechceu/gtceu/api/machine/IMachineBlockEntity;", "<init>", "(Lcom/gregtechceu/gtceu/api/machine/IMachineBlockEntity;)V", "casingTier", "", "getCasingTier", "()I", "setCasingTier", "(I)V", "coilLevel", "tubeTier", "voltageTier", "onStructureFormed", "", "onStructureInvalid", "getFieldHolder", "Lcom/lowdragmc/lowdraglib/syncdata/field/ManagedFieldHolder;", "getRealRecipe", "Lcom/gregtechceu/gtceu/api/recipe/GTRecipe;", "recipe", "addDisplayText", "components", "", "Lnet/minecraft/network/chat/Component;", "maxParallel", "getMaxParallel", "getChance", "getPartAppearance", "Lnet/minecraft/world/level/block/state/BlockState;", "part", "Lcom/gregtechceu/gtceu/api/machine/feature/multiblock/IMultiPart;", "side", "Lnet/minecraft/core/Direction;", "sourceState", "sourcePos", "Lnet/minecraft/core/BlockPos;", "getBlockAppearance", "state", "level", "Lnet/minecraft/world/level/BlockAndTintGetter;", "pos", "getAppearance", "Companion", "gtnn-1.20.1"})
@SourceDebugExtension(value={"SMAP\nChemicalPlantMachine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChemicalPlantMachine.kt\ndev/arbor/gtnn/common/machine/multiblock/ChemicalPlantMachine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n1193#2,2:160\n1267#2,4:162\n*S KotlinDebug\n*F\n+ 1 ChemicalPlantMachine.kt\ndev/arbor/gtnn/common/machine/multiblock/ChemicalPlantMachine\n*L\n153#1:160,2\n153#1:162,4\n*E\n"})
public final class ChemicalPlantMachine
extends WorkableElectricMultiblockMachine
implements IGTPPMachine,
IGTPPRenderMachine {
    @NotNull
    public static final Companion Companion;
    @Persisted
    @DescSynced
    @RequireRerender
    private int casingTier;
    private int coilLevel;
    private int tubeTier;
    private int voltageTier;
    @NotNull
    private static final Map<Integer, BlockState> APPEARANCE_MAP;
    @NotNull
    private static final ManagedFieldHolder MANAGED_FIELD_HOLDER;

    public ChemicalPlantMachine(@NotNull IMachineBlockEntity holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super(holder, new Object[0]);
    }

    public final int getCasingTier() {
        return this.casingTier;
    }

    public final void setCasingTier(int n) {
        this.casingTier = n;
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        PatternMatchContext context = this.getMultiblockState().getMatchContext();
        TraceabilityPredicateEx traceabilityPredicateEx = NNPredicates.INSTANCE.getCoilBlock();
        Intrinsics.checkNotNull((Object)context);
        this.coilLevel = traceabilityPredicateEx.getTier(context);
        this.tubeTier = NNPredicates.INSTANCE.getPipeBlock().getTier(context);
        this.voltageTier = NNPredicates.INSTANCE.getMachineCasing().getTier(context);
        this.casingTier = NNPredicates.INSTANCE.getPlantCasings().getTier(context);
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.coilLevel = 0;
        this.casingTier = 0;
        this.tubeTier = 0;
        this.voltageTier = 0;
    }

    @NotNull
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Nullable
    protected GTRecipe getRealRecipe(@NotNull GTRecipe recipe) {
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        if (this.voltageTier < 9 && RecipeHelper.getRecipeEUtTier((GTRecipe)recipe) > this.voltageTier) {
            return null;
        }
        GTRecipe modified = super.getRealRecipe(recipe);
        if (this.casingTier > 0) {
            GTRecipe copied;
            GTRecipe gTRecipe = copied = Intrinsics.areEqual((Object)recipe, (Object)modified) ? modified.copy() : modified;
            if (copied != null) {
                copied.duration = (int)((double)copied.duration / (1.0 + (double)this.coilLevel * 0.5));
            }
            return copied;
        }
        return modified;
    }

    public void addDisplayText(@NotNull List<Component> components) {
        Intrinsics.checkNotNullParameter(components, (String)"components");
        super.addDisplayText(components);
        if (this.isFormed()) {
            Object[] objectArray = new Object[]{this.coilLevel * 50};
            components.add((Component)Component.m_237110_((String)"gtnn.multiblock.chemical_plant.heating_coil", (Object[])objectArray));
            objectArray = new Object[]{this.tubeTier * 2};
            components.add((Component)Component.m_237110_((String)"gtnn.multiblock.chemical_plant.parallel_level", (Object[])objectArray));
            objectArray = new Object[]{GTValues.VNF[this.voltageTier]};
            components.add((Component)Component.m_237110_((String)"gtnn.multiblock.chemical_plant.tier", (Object[])objectArray));
            objectArray = new Object[]{this.getChance()};
            components.add((Component)Component.m_237110_((String)"gtnn.multiblock.chemical_plant.chance", (Object[])objectArray));
        }
    }

    @Override
    public int getMaxParallel() {
        return Math.max((this.tubeTier - 1) * 2 + 1, 1);
    }

    public final int getChance() {
        return (int)Math.min((double)(100 - 20 * (this.tubeTier - 1)), 100.0);
    }

    @Nullable
    public BlockState getPartAppearance(@NotNull IMultiPart part, @NotNull Direction side, @NotNull BlockState sourceState, @NotNull BlockPos sourcePos) {
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)sourceState, (String)"sourceState");
        Intrinsics.checkNotNullParameter((Object)sourcePos, (String)"sourcePos");
        BlockState appearanceBlock = APPEARANCE_MAP.get(this.casingTier);
        BlockState blockState = appearanceBlock;
        if (blockState == null) {
            blockState = super.getPartAppearance(part, side, sourceState, sourcePos);
        }
        return blockState;
    }

    @NotNull
    public BlockState getBlockAppearance(@NotNull BlockState state, @NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull Direction side, @NotNull BlockState sourceState, @NotNull BlockPos sourcePos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)sourceState, (String)"sourceState");
        Intrinsics.checkNotNullParameter((Object)sourcePos, (String)"sourcePos");
        BlockState appearanceBlock = this.getAppearance();
        return appearanceBlock;
    }

    @Override
    @NotNull
    public BlockState getAppearance() {
        if (this.isFormed()) {
            BlockState blockState = APPEARANCE_MAP.get(this.casingTier);
            Intrinsics.checkNotNull((Object)blockState);
            return blockState;
        }
        BlockState blockState = APPEARANCE_MAP.get(1);
        Intrinsics.checkNotNull((Object)blockState);
        return blockState;
    }

    @Override
    @NotNull
    public BlockState getPartAppearance(@NotNull IMultiPart part) {
        return IGTPPRenderMachine.DefaultImpls.getPartAppearance(this, part);
    }

    @Override
    public int getSpeedMultiplier() {
        return IGTPPMachine.DefaultImpls.getSpeedMultiplier(this);
    }

    @Override
    public int getEnergyConsumeMultiplier() {
        return IGTPPMachine.DefaultImpls.getEnergyConsumeMultiplier(this);
    }

    @Override
    public int getPollution() {
        return IGTPPMachine.DefaultImpls.getPollution(this);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateTo$iv$iv;
        Companion = new Companion(null);
        Set set = NNBlockMaps.ALL_CP_CASINGS.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        Iterable $this$associate$iv = set;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            ITierType it = (ITierType)element$iv$iv;
            boolean bl = false;
            Integer n = it.getTier();
            Object object = NNBlockMaps.ALL_CP_CASINGS.get((Object)it);
            Intrinsics.checkNotNull((Object)object);
            Pair pair = TuplesKt.to((Object)n, (Object)((Block)((Supplier)object).get()).m_49966_());
            map.put(pair.getFirst(), pair.getSecond());
        }
        APPEARANCE_MAP = destination$iv$iv;
        MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ChemicalPlantMachine.class, WorkableMultiblockMachine.MANAGED_FIELD_HOLDER);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldev/arbor/gtnn/common/machine/multiblock/ChemicalPlantMachine$Companion;", "", "<init>", "()V", "APPEARANCE_MAP", "", "", "Lnet/minecraft/world/level/block/state/BlockState;", "MANAGED_FIELD_HOLDER", "Lcom/lowdragmc/lowdraglib/syncdata/field/ManagedFieldHolder;", "gtnn-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

