/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.common.machine.multiblock;

import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IExplosionMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.pattern.util.PatternMatchContext;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.modifier.ModifierFunction;
import com.gregtechceu.gtceu.api.transfer.fluid.CustomFluidTank;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.machine.multiblock.part.FluidHatchPartMachine;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import dev.arbor.gtnn.data.GTNNMaterials;
import dev.arbor.gtnn.data.GTNNRecipeTypes;
import dev.arbor.gtnn.extension.NNUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\nH\u0002J \u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\nH\u0002J\b\u0010 \u001a\u00020\u0017H\u0016J\b\u0010!\u001a\u00020\u0017H\u0016J\b\u0010\"\u001a\u00020\u0012H\u0016J\u0006\u0010#\u001a\u00020\nJ\b\u0010$\u001a\u00020%H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u00128\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00020\u00128\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00020\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Ldev/arbor/gtnn/common/machine/multiblock/LargeNaquadahReactorMachine;", "Lcom/gregtechceu/gtceu/api/machine/multiblock/WorkableElectricMultiblockMachine;", "Lcom/gregtechceu/gtceu/api/machine/feature/IExplosionMachine;", "holder", "Lcom/gregtechceu/gtceu/api/machine/IMachineBlockEntity;", "<init>", "(Lcom/gregtechceu/gtceu/api/machine/IMachineBlockEntity;)V", "activeFluid", "", "Lnet/minecraft/world/level/material/Fluid;", "", "activeFluidCost", "fuelFluids", "", "hatchPartMachines", "", "Lcom/gregtechceu/gtceu/common/machine/multiblock/part/FluidHatchPartMachine;", "hasAir", "", "hasCool", "activeFluidPower", "lockFluid", "checkHatch", "", "machine", "duration", "checkLockFluid", "fluid", "Lnet/minecraftforge/fluids/FluidStack;", "air", "active", "cool", "onStructureFormed", "onStructureInvalid", "alwaysTryModifyRecipe", "getFinalPowerRate", "getFieldHolder", "Lcom/lowdragmc/lowdraglib/syncdata/field/ManagedFieldHolder;", "Companion", "gtnn-1.20.1"})
public final class LargeNaquadahReactorMachine
extends WorkableElectricMultiblockMachine
implements IExplosionMachine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Fluid, Integer> activeFluid;
    @NotNull
    private final Map<Fluid, Integer> activeFluidCost;
    @NotNull
    private final List<Fluid> fuelFluids;
    @Nullable
    private Set<? extends FluidHatchPartMachine> hatchPartMachines;
    @Persisted
    private boolean hasAir;
    @Persisted
    private boolean hasCool;
    @Persisted
    private int activeFluidPower;
    @Nullable
    private Fluid lockFluid;
    @NotNull
    private static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(LargeNaquadahReactorMachine.class, WorkableMultiblockMachine.MANAGED_FIELD_HOLDER);

    public LargeNaquadahReactorMachine(@NotNull IMachineBlockEntity holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super(holder, new Object[0]);
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)GTMaterials.Caesium.getFluid(), (Object)2), TuplesKt.to((Object)GTMaterials.Uranium235.getFluid(), (Object)3), TuplesKt.to((Object)GTMaterials.Naquadah.getFluid(), (Object)4)};
        this.activeFluid = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)GTMaterials.Caesium.getFluid(), (Object)180), TuplesKt.to((Object)GTMaterials.Uranium235.getFluid(), (Object)180), TuplesKt.to((Object)GTMaterials.Naquadah.getFluid(), (Object)20)};
        this.activeFluidCost = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new Fluid[]{GTNNMaterials.ThoriumBasedLiquidFuelExcited.getFluid(), GTNNMaterials.UraniumBasedLiquidFuelExcited.getFluid(), GTNNMaterials.PlutoniumBasedLiquidFuelExcited.getFluid()};
        this.fuelFluids = CollectionsKt.listOf((Object[])objectArray);
        this.activeFluidPower = 1;
    }

    private final void checkHatch(LargeNaquadahReactorMachine machine, int duration) {
        machine.hasCool = false;
        machine.hasAir = false;
        machine.activeFluidPower = 1;
        Set<? extends FluidHatchPartMachine> set = machine.hatchPartMachines;
        Intrinsics.checkNotNull(set);
        for (FluidHatchPartMachine fluidHatchPartMachine : set) {
            NotifiableFluidTank tank = fluidHatchPartMachine.tank;
            IO io = tank.getHandlerIO();
            if (io == IO.IN || io == IO.BOTH) {
                Iterator iterator = ArrayIteratorKt.iterator((Object[])tank.getStorages());
                while (iterator.hasNext()) {
                    FluidStack fluid;
                    CustomFluidTank i = (CustomFluidTank)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)i.getFluid(), (String)"getFluid(...)");
                    if (Intrinsics.areEqual((Object)i.getFluid(), (Object)FluidStack.EMPTY)) continue;
                    this.checkLockFluid(machine, fluid);
                    this.active(machine, fluid, duration);
                    if (this.cool(fluid, duration)) {
                        machine.hasCool = true;
                    }
                    if (!this.air(fluid, duration)) continue;
                    machine.hasAir = true;
                }
            }
            if (!machine.hasCool || !machine.hasAir || machine.activeFluidPower == 1) continue;
            return;
        }
    }

    private final void checkLockFluid(LargeNaquadahReactorMachine machine, FluidStack fluid) {
        if (machine.fuelFluids.contains(fluid.getFluid())) {
            if (machine.lockFluid == null) {
                machine.lockFluid = fluid.getFluid();
            } else if (!Intrinsics.areEqual((Object)machine.lockFluid, (Object)fluid.getFluid())) {
                machine.doExplosion(128.0f);
            }
        }
    }

    private final boolean air(FluidStack fluid, int duration) {
        if (fluid.getFluid().m_6212_(GTMaterials.LiquidAir.getFluid())) {
            int airAmount = 120 * duration;
            if (fluid.getAmount() >= airAmount) {
                fluid.setAmount(fluid.getAmount() - airAmount);
                return true;
            }
            return false;
        }
        return false;
    }

    private final void active(LargeNaquadahReactorMachine machine, FluidStack fluid, int duration) {
        if (this.activeFluid.containsKey(fluid.getFluid())) {
            Integer n = this.activeFluidCost.get(fluid.getFluid());
            Intrinsics.checkNotNull((Object)n);
            int activeFluidCostI = ((Number)n).intValue() / 20 * duration;
            Integer activeFluidPower = this.activeFluid.get(fluid.getFluid());
            int n2 = machine.activeFluidPower;
            Integer n3 = activeFluidPower;
            Intrinsics.checkNotNull((Object)n3);
            if (n2 <= n3 && fluid.getAmount() >= activeFluidCostI) {
                machine.activeFluidPower = activeFluidPower;
                fluid.setAmount(fluid.getAmount() - activeFluidCostI);
            }
        }
    }

    private final boolean cool(FluidStack fluid, int duration) {
        if (fluid.getFluid().m_6212_(GTMaterials.PCBCoolant.getFluid())) {
            int coldAmount = 50 * duration;
            if (fluid.getAmount() >= coldAmount) {
                fluid.setAmount(fluid.getAmount() - coldAmount);
                return true;
            }
        }
        return false;
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        PatternMatchContext matchContext = this.getMultiblockState().getMatchContext();
        Long2ObjectMap ioMap = (Long2ObjectMap)matchContext.getOrCreate("ioMap", Long2ObjectMaps::emptyMap);
        List parts = this.getParts();
        for (IMultiPart part : parts) {
            Object io = ioMap.getOrDefault(part.self().getPos().m_121878_(), (Object)IO.BOTH);
            if (io == IO.NONE || !(part instanceof FluidHatchPartMachine)) continue;
            this.hatchPartMachines = NNUtils.INSTANCE.getOrDefault(this.hatchPartMachines, LargeNaquadahReactorMachine::onStructureFormed$mutableSetOf__proxy);
            Set<? extends FluidHatchPartMachine> set = this.hatchPartMachines;
            Intrinsics.checkNotNull(set, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<com.gregtechceu.gtceu.common.machine.multiblock.part.FluidHatchPartMachine>");
            TypeIntrinsics.asMutableSet(set).add(part);
        }
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.hatchPartMachines = new HashSet();
        this.lockFluid = null;
    }

    public boolean alwaysTryModifyRecipe() {
        return true;
    }

    public final int getFinalPowerRate() {
        int activeFluidPower = this.activeFluidPower;
        if (this.hasCool) {
            activeFluidPower = (int)((double)activeFluidPower * 1.5);
        }
        return activeFluidPower;
    }

    @NotNull
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    private static final Set<Object> onStructureFormed$mutableSetOf__proxy() {
        return new LinkedHashSet();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/arbor/gtnn/common/machine/multiblock/LargeNaquadahReactorMachine$Companion;", "", "<init>", "()V", "MANAGED_FIELD_HOLDER", "Lcom/lowdragmc/lowdraglib/syncdata/field/ManagedFieldHolder;", "modifyRecipe", "Lcom/gregtechceu/gtceu/api/recipe/modifier/ModifierFunction;", "machine", "Lcom/gregtechceu/gtceu/api/machine/MetaMachine;", "recipe", "Lcom/gregtechceu/gtceu/api/recipe/GTRecipe;", "gtnn-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModifierFunction modifyRecipe(@NotNull MetaMachine machine, @NotNull GTRecipe recipe) {
            Intrinsics.checkNotNullParameter((Object)machine, (String)"machine");
            Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
            if (!Intrinsics.areEqual((Object)recipe.recipeType, (Object)GTNNRecipeTypes.INSTANCE.getLARGE_NAQUADAH_REACTOR_RECIPES())) {
                ModifierFunction modifierFunction = ModifierFunction.NULL;
                Intrinsics.checkNotNullExpressionValue((Object)modifierFunction, (String)"NULL");
                return modifierFunction;
            }
            if (machine instanceof LargeNaquadahReactorMachine) {
                return arg_0 -> Companion.modifyRecipe$lambda$0(recipe, machine, arg_0);
            }
            ModifierFunction modifierFunction = ModifierFunction.NULL;
            Intrinsics.checkNotNullExpressionValue((Object)modifierFunction, (String)"NULL");
            return modifierFunction;
        }

        private static final GTRecipe modifyRecipe$lambda$0(GTRecipe $recipe, MetaMachine $machine, GTRecipe it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            int duration = $recipe.duration;
            ((LargeNaquadahReactorMachine)$machine).checkHatch((LargeNaquadahReactorMachine)$machine, duration);
            GTRecipe copyRecipe = $recipe.copy();
            if (!((LargeNaquadahReactorMachine)$machine).hasAir) {
                copyRecipe.tickOutputs.clear();
                copyRecipe.outputs.clear();
                return copyRecipe;
            }
            long eut = copyRecipe.getOutputEUt().getTotalEU();
            if (((LargeNaquadahReactorMachine)$machine).hasCool) {
                eut = (long)((double)eut * 1.5);
            }
            Map map = copyRecipe.tickOutputs;
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"tickOutputs");
            Map map2 = map;
            EURecipeCapability eURecipeCapability = EURecipeCapability.CAP;
            List list = CollectionsKt.listOf((Object)new Content((Object)(eut *= (long)((LargeNaquadahReactorMachine)$machine).activeFluidPower), 1, 1, 0));
            map2.put(eURecipeCapability, list);
            return copyRecipe;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

