/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredIOPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import dev.arbor.gtnn.common.item.behaviors.CatalystBehavior;
import dev.arbor.gtnn.common.machine.multiblock.ChemicalPlantMachine;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.ParametersAreNonnullByDefault;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0007H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\b\u0010\u0017\u001a\u00020\u0012H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J0\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\"H\u0016J\b\u0010'\u001a\u00020(H\u0016R\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ldev/arbor/gtnn/common/machine/multiblock/part/CatalystHatchPartMachine;", "Lcom/gregtechceu/gtceu/api/machine/multiblock/part/TieredIOPartMachine;", "holder", "Lcom/gregtechceu/gtceu/api/machine/IMachineBlockEntity;", "<init>", "(Lcom/gregtechceu/gtceu/api/machine/IMachineBlockEntity;)V", "buffer", "Lcom/gregtechceu/gtceu/api/machine/trait/NotifiableItemStackHandler;", "getBuffer", "()Lcom/gregtechceu/gtceu/api/machine/trait/NotifiableItemStackHandler;", "inventory", "getInventory", "bufferSubs", "Lcom/lowdragmc/lowdraglib/syncdata/ISubscription;", "inventorySubs", "transferSubs", "Lcom/gregtechceu/gtceu/api/machine/TickableSubscription;", "onLoad", "", "onUnload", "createInventory", "onInventoryChanged", "transferItems", "unsubscribe", "createUIWidget", "Lcom/lowdragmc/lowdraglib/gui/widget/Widget;", "addSlots", "container", "Lcom/lowdragmc/lowdraglib/gui/widget/WidgetGroup;", "handler", "x", "", "y", "canPutItems", "", "getChance", "", "setWorkingEnabled", "workingEnabled", "getFieldHolder", "Lcom/lowdragmc/lowdraglib/syncdata/field/ManagedFieldHolder;", "Companion", "gtnn-1.20.1"})
public final class CatalystHatchPartMachine
extends TieredIOPartMachine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Persisted
    @NotNull
    private final NotifiableItemStackHandler buffer;
    @Persisted
    @NotNull
    private final NotifiableItemStackHandler inventory;
    @Nullable
    private ISubscription bufferSubs;
    @Nullable
    private ISubscription inventorySubs;
    @Nullable
    private TickableSubscription transferSubs;
    @NotNull
    private static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(CatalystHatchPartMachine.class, TieredIOPartMachine.MANAGED_FIELD_HOLDER);
    @NotNull
    private static final ResourceTexture SMALL_ARROW_OVERLAY = new ResourceTexture("gtnn:textures/gui/arrows/small_arrow_overlay.png");

    public CatalystHatchPartMachine(@NotNull IMachineBlockEntity holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super(holder, 5, IO.IN);
        this.buffer = new NotifiableItemStackHandler((MetaMachine)this, 16, IO.NONE, IO.BOTH);
        this.inventory = this.createInventory();
    }

    @NotNull
    public final NotifiableItemStackHandler getBuffer() {
        return this.buffer;
    }

    @NotNull
    public final NotifiableItemStackHandler getInventory() {
        return this.inventory;
    }

    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.bufferSubs = this.buffer.addChangedListener(() -> CatalystHatchPartMachine.onLoad$lambda$0(this));
            this.inventorySubs = this.inventory.addChangedListener(() -> CatalystHatchPartMachine.onLoad$lambda$1(this));
        }
    }

    public void onUnload() {
        block1: {
            super.onUnload();
            ISubscription iSubscription = this.bufferSubs;
            if (iSubscription != null) {
                iSubscription.unsubscribe();
            }
            ISubscription iSubscription2 = this.inventorySubs;
            if (iSubscription2 == null) break block1;
            iSubscription2.unsubscribe();
        }
    }

    private final NotifiableItemStackHandler createInventory() {
        IO iO = IO.IN;
        IO iO2 = IO.OUT;
        IntFunction<CustomItemStackHandler> intFunction = CatalystHatchPartMachine::createInventory$lambda$2;
        return new NotifiableItemStackHandler(this, iO, iO2, intFunction){
            final /* synthetic */ CatalystHatchPartMachine this$0;
            {
                this.this$0 = $receiver;
                super((MetaMachine)$receiver, 16, $super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            public List<Ingredient> handleRecipeInner(IO io, GTRecipe recipe, List<Ingredient> left, boolean simulate) {
                CustomItemStackHandler customItemStackHandler;
                Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
                Intrinsics.checkNotNullParameter(left, (String)"left");
                if (io != this.handlerIO) {
                    return left;
                }
                if (simulate) {
                    NonNullList items = NonNullList.m_122779_();
                    int n = this.storage.getSlots();
                    for (int i = 0; i < n; ++i) {
                        items.add((Object)this.storage.getStackInSlot(i));
                    }
                    customItemStackHandler = new CustomItemStackHandler(items);
                } else {
                    customItemStackHandler = this.storage;
                }
                CustomItemStackHandler capability = customItemStackHandler;
                Iterator<Ingredient> iterator = left.iterator();
                if (io == IO.IN) {
                    block1: while (iterator.hasNext()) {
                        Ingredient ingredient = iterator.next();
                        int n = capability.getSlots();
                        for (int i = 0; i < n; ++i) {
                            ItemStack item;
                            ItemStack itemStack;
                            Intrinsics.checkNotNullExpressionValue((Object)capability.getStackInSlot(i), (String)"getStackInSlot(...)");
                            ItemStack itemStack2 = itemStack = simulate ? item.m_41777_() : item;
                            if (!ingredient.test(itemStack)) continue;
                            Object[] ingredientStacks = ingredient.m_43908_();
                            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])ingredientStacks);
                            while (iterator2.hasNext()) {
                                ItemStack ingredientStack = (ItemStack)iterator2.next();
                                if (!ingredientStack.m_150930_(itemStack.m_41720_())) continue;
                                Intrinsics.checkNotNull((Object)itemStack);
                                CatalystBehavior behavior = CatalystBehavior.Companion.getBehaviour(itemStack);
                                int count = ingredientStack.m_41613_();
                                if (!simulate) {
                                    float chance = CatalystHatchPartMachine.access$getChance(this.this$0);
                                    double u = (float)count * chance;
                                    double e = (float)count * chance * (1.0f - chance);
                                    count = (int)Math.ceil(Math.sqrt(e) * GTValues.RNG.m_188583_() + u);
                                }
                                if (behavior != null) {
                                    int damage = RangesKt.coerceAtMost((int)count, (int)behavior.getDurability(itemStack));
                                    behavior.applyDamage(itemStack, damage);
                                    ingredientStack.m_41774_(damage);
                                    if (itemStack.m_41619_() || ingredientStack.m_41619_()) {
                                        CatalystHatchPartMachine.access$transferItems(this.this$0);
                                    }
                                } else {
                                    ItemStack extracted;
                                    Intrinsics.checkNotNullExpressionValue((Object)capability.extractItem(i, count, false), (String)"extractItem(...)");
                                    ingredientStack.m_41774_(extracted.m_41613_());
                                }
                                if (!ingredientStack.m_41619_()) continue;
                                iterator.remove();
                                continue block1;
                            }
                        }
                    }
                }
                return left.isEmpty() ? null : left;
            }
        };
    }

    private final void onInventoryChanged() {
        if (this.isWorkingEnabled() && !this.buffer.isEmpty()) {
            this.transferSubs = this.subscribeServerTick(this.transferSubs, () -> CatalystHatchPartMachine.onInventoryChanged$lambda$3(this));
        } else {
            this.unsubscribe();
        }
    }

    private final void transferItems() {
        int n = this.buffer.getSlots();
        for (int i = 0; i < n; ++i) {
            ItemStack copy;
            ItemStack stack;
            Intrinsics.checkNotNullExpressionValue((Object)this.buffer.getStackInSlot(i), (String)"getStackInSlot(...)");
            if (stack.m_41619_() || !this.inventory.getStackInSlot(i).m_41619_() || this.buffer.extractItem(i, 1, true).m_41619_() || !this.inventory.insertItemInternal(i, copy = stack.m_255036_(1), true).m_41619_()) continue;
            this.buffer.extractItem(i, 1, false);
            this.inventory.insertItemInternal(i, copy, false);
        }
        this.unsubscribe();
    }

    private final void unsubscribe() {
        TickableSubscription tickableSubscription = this.transferSubs;
        if (tickableSubscription != null) {
            tickableSubscription.unsubscribe();
        }
        this.transferSubs = null;
    }

    @NotNull
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 175, 88);
        WidgetGroup slotsContainer = new WidgetGroup(4, 4, 167, 80);
        slotsContainer.addWidget((Widget)new ImageWidget(75, 31, 18, 18, (IGuiTexture)SMALL_ARROW_OVERLAY));
        this.addSlots(slotsContainer, this.buffer, 4, 4, true);
        this.addSlots(slotsContainer, this.inventory, 91, 4, false);
        IGuiTexture[] iGuiTextureArray = new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE};
        slotsContainer.setBackground(iGuiTextureArray);
        group.addWidget((Widget)slotsContainer);
        return (Widget)group;
    }

    private final void addSlots(WidgetGroup container, NotifiableItemStackHandler handler, int x, int y, boolean canPutItems) {
        int index = 0;
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 4; ++i) {
                int n = index++;
                IGuiTexture[] iGuiTextureArray = new IGuiTexture[]{GuiTextures.SLOT};
                container.addWidget(new SlotWidget((IItemHandlerModifiable)handler, n, x + i * 18, y + j * 18, true, canPutItems).setBackground(iGuiTextureArray));
            }
        }
    }

    private final float getChance() {
        for (IMultiController controller : this.controllers) {
            if (!(controller instanceof ChemicalPlantMachine)) continue;
            return (float)((ChemicalPlantMachine)controller).getChance() / 100.0f;
        }
        return 1.0f;
    }

    public void setWorkingEnabled(boolean workingEnabled) {
        super.setWorkingEnabled(workingEnabled);
        this.onInventoryChanged();
    }

    @NotNull
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    private static final void onLoad$lambda$0(CatalystHatchPartMachine this$0) {
        this$0.onInventoryChanged();
    }

    private static final void onLoad$lambda$1(CatalystHatchPartMachine this$0) {
        this$0.onInventoryChanged();
    }

    private static final CustomItemStackHandler createInventory$lambda$2(int slots) {
        return new CustomItemStackHandler(slots){

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    private static final void onInventoryChanged$lambda$3(CatalystHatchPartMachine this$0) {
        this$0.transferItems();
    }

    public static final /* synthetic */ float access$getChance(CatalystHatchPartMachine $this) {
        return $this.getChance();
    }

    public static final /* synthetic */ void access$transferItems(CatalystHatchPartMachine $this) {
        $this.transferItems();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Ldev/arbor/gtnn/common/machine/multiblock/part/CatalystHatchPartMachine$Companion;", "", "<init>", "()V", "MANAGED_FIELD_HOLDER", "Lcom/lowdragmc/lowdraglib/syncdata/field/ManagedFieldHolder;", "getMANAGED_FIELD_HOLDER", "()Lcom/lowdragmc/lowdraglib/syncdata/field/ManagedFieldHolder;", "SMALL_ARROW_OVERLAY", "Lcom/lowdragmc/lowdraglib/gui/texture/ResourceTexture;", "getSMALL_ARROW_OVERLAY", "()Lcom/lowdragmc/lowdraglib/gui/texture/ResourceTexture;", "gtnn-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ManagedFieldHolder getMANAGED_FIELD_HOLDER() {
            return MANAGED_FIELD_HOLDER;
        }

        @NotNull
        public final ResourceTexture getSMALL_ARROW_OVERLAY() {
            return SMALL_ARROW_OVERLAY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

