/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.common.machine.multiblock.part.EnergyHatchPartMachine;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.ParametersAreNonnullByDefault;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\bH\u0014\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0013H\u0002J\b\u0010\"\u001a\u00020#H\u0016R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ldev/arbor/gtnn/common/machine/multiblock/part/NeutronAcceleratorMachine;", "Lcom/gregtechceu/gtceu/common/machine/multiblock/part/EnergyHatchPartMachine;", "holder", "Lcom/gregtechceu/gtceu/api/machine/IMachineBlockEntity;", "tier", "", "args", "", "", "<init>", "(Lcom/gregtechceu/gtceu/api/machine/IMachineBlockEntity;I[Ljava/lang/Object;)V", "powerListener", "Lcom/lowdragmc/lowdraglib/syncdata/ISubscription;", "powerSubs", "Lcom/gregtechceu/gtceu/api/machine/TickableSubscription;", "createEnergyContainer", "Lcom/gregtechceu/gtceu/api/machine/trait/NotifiableEnergyContainer;", "([Ljava/lang/Object;)Lcom/gregtechceu/gtceu/api/machine/trait/NotifiableEnergyContainer;", "consumeEnergy", "", "onLoad", "", "onUnload", "updateSubscription", "energyChanged", "shouldOpenUI", "", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "hit", "Lnet/minecraft/world/phys/BlockHitResult;", "getMaxEUConsume", "getFieldHolder", "Lcom/lowdragmc/lowdraglib/syncdata/field/ManagedFieldHolder;", "Companion", "gtnn-1.20.1"})
public final class NeutronAcceleratorMachine
extends EnergyHatchPartMachine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ISubscription powerListener;
    @Nullable
    private TickableSubscription powerSubs;
    @NotNull
    private static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(NeutronAcceleratorMachine.class, EnergyHatchPartMachine.MANAGED_FIELD_HOLDER);

    public NeutronAcceleratorMachine(@NotNull IMachineBlockEntity holder, int tier, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object[] objectArray = new Object[]{args};
        super(holder, tier, IO.IN, 1, objectArray);
    }

    @NotNull
    protected NotifiableEnergyContainer createEnergyContainer(Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        long maxCapacity = GTValues.V[this.tier] * 72L * (long)this.amperage;
        NotifiableEnergyContainer container = NotifiableEnergyContainer.receiverContainer((MetaMachine)((MetaMachine)this), (long)maxCapacity, (long)GTValues.V[this.tier], (long)this.amperage);
        container.setSideInputCondition(arg_0 -> NeutronAcceleratorMachine.createEnergyContainer$lambda$0(this, arg_0));
        container.setCapabilityValidator(arg_0 -> NeutronAcceleratorMachine.createEnergyContainer$lambda$1(this, arg_0));
        Intrinsics.checkNotNull((Object)container);
        return container;
    }

    public final long consumeEnergy() {
        return this.isWorkingEnabled() && this.energyContainer.getEnergyStored() > 0L ? Math.abs(this.energyContainer.changeEnergy(-this.getMaxEUConsume())) * (long)(10 + ThreadLocalRandom.current().nextInt(11)) : 0L;
    }

    public void onLoad() {
        super.onLoad();
        this.powerListener = this.energyContainer.addChangedListener(() -> NeutronAcceleratorMachine.onLoad$lambda$2(this));
        this.updateSubscription();
    }

    public void onUnload() {
        super.onUnload();
        if (this.powerListener != null) {
            ISubscription iSubscription = this.powerListener;
            Intrinsics.checkNotNull((Object)iSubscription);
            iSubscription.unsubscribe();
            this.powerListener = null;
        }
    }

    private final void updateSubscription() {
        if (this.energyContainer.getEnergyStored() > 0L) {
            this.powerSubs = this.subscribeServerTick(this.powerSubs, () -> NeutronAcceleratorMachine.updateSubscription$lambda$3(this));
        } else if (this.powerSubs != null) {
            TickableSubscription tickableSubscription = this.powerSubs;
            Intrinsics.checkNotNull((Object)tickableSubscription);
            tickableSubscription.unsubscribe();
            this.powerSubs = null;
        }
    }

    private final void energyChanged() {
        if (this.energyContainer.getEnergyStored() > 0L && !this.isWorkingEnabled()) {
            this.energyContainer.changeEnergy(-GTValues.V[this.tier]);
        }
    }

    public boolean shouldOpenUI(@NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        return true;
    }

    private final long getMaxEUConsume() {
        return MathKt.roundToLong((double)((double)GTValues.V[this.tier] * 0.8));
    }

    @NotNull
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    private static final boolean createEnergyContainer$lambda$0(NeutronAcceleratorMachine this$0, Direction it) {
        return it == this$0.getFrontFacing() && this$0.isWorkingEnabled();
    }

    private static final boolean createEnergyContainer$lambda$1(NeutronAcceleratorMachine this$0, Direction it) {
        return it == null || it == this$0.getFrontFacing();
    }

    private static final void onLoad$lambda$2(NeutronAcceleratorMachine this$0) {
        this$0.updateSubscription();
    }

    private static final void updateSubscription$lambda$3(NeutronAcceleratorMachine this$0) {
        this$0.energyChanged();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/arbor/gtnn/common/machine/multiblock/part/NeutronAcceleratorMachine$Companion;", "", "<init>", "()V", "MANAGED_FIELD_HOLDER", "Lcom/lowdragmc/lowdraglib/syncdata/field/ManagedFieldHolder;", "gtnn-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

