/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredPartMachine;
import com.gregtechceu.gtceu.utils.RedstoneUtil;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextBoxWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KMutableProperty0;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0007H\u0002J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u001fH\u0002J\b\u0010\"\u001a\u00020#H\u0016R\u0012\u0010\u0006\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00078\u0002@BX\u0083\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\t\u0010\nR \u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00078\u0002@BX\u0083\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\f\u0010\nR \u0010\r\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8\u0002@BX\u0083\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00078\u0002@BX\u0083\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0012\u0010\nR\u000e\u0010\u0013\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ldev/arbor/gtnn/common/machine/multiblock/part/NeutronSensorMachine;", "Lcom/gregtechceu/gtceu/api/machine/multiblock/part/TieredPartMachine;", "holder", "Lcom/gregtechceu/gtceu/api/machine/IMachineBlockEntity;", "<init>", "(Lcom/gregtechceu/gtceu/api/machine/IMachineBlockEntity;)V", "energy", "", "min", "setMin", "(I)V", "max", "setMax", "isInverted", "", "setInverted", "(Z)V", "redstoneSignalOutput", "setRedstoneSignalOutput", "k", "clamp", "value", "createUIWidget", "Lcom/lowdragmc/lowdraglib/gui/widget/Widget;", "update", "", "getOutputSignal", "side", "Lnet/minecraft/core/Direction;", "canConnectRedstone", "toText", "", "num", "fromText", "getFieldHolder", "Lcom/lowdragmc/lowdraglib/syncdata/field/ManagedFieldHolder;", "Companion", "gtnn-1.20.1"})
public final class NeutronSensorMachine
extends TieredPartMachine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Persisted
    private int energy;
    @Persisted
    @DescSynced
    private int min;
    @Persisted
    @DescSynced
    private int max;
    @Persisted
    private boolean isInverted;
    @Persisted
    private int redstoneSignalOutput;
    private final int k;
    @NotNull
    private static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(NeutronSensorMachine.class, TieredPartMachine.MANAGED_FIELD_HOLDER);

    public NeutronSensorMachine(@NotNull IMachineBlockEntity holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super(holder, 5);
        this.k = 1000;
    }

    private final void setMin(int min) {
        this.min = min;
        this.update();
    }

    private final void setMax(int max) {
        this.max = max;
        this.update();
    }

    private final void setInverted(boolean isInverted) {
        this.isInverted = isInverted;
        this.update();
    }

    private final void setRedstoneSignalOutput(int redstoneSignalOutput) {
        this.redstoneSignalOutput = redstoneSignalOutput;
        this.updateSignal();
    }

    private final int clamp(int value, int min, int max) {
        return value < min ? min : RangesKt.coerceAtMost((int)value, (int)max);
    }

    @NotNull
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(Position.ORIGIN, new Size(176, 112));
        Object object = new Object[]{"KeV"};
        group.addWidget((Widget)new TextBoxWidget(8, 35, 65, CollectionsKt.listOf((Object)LocalizationUtils.format((String)"gtnn.universal.desc.neutron_kinetic_energy.min", (Object[])object))));
        object = new Object[]{"KeV"};
        group.addWidget((Widget)new TextBoxWidget(8, 80, 65, CollectionsKt.listOf((Object)LocalizationUtils.format((String)"gtnn.universal.desc.neutron_kinetic_energy.max", (Object[])object))));
        object = () -> NeutronSensorMachine.createUIWidget$lambda$0(this);
        Consumer<String> consumer = arg_0 -> NeutronSensorMachine.createUIWidget$lambda$1(this, arg_0);
        group.addWidget((Widget)new TextFieldWidget(this, (Supplier<String>)object, consumer){
            private int maxValue;
            final /* synthetic */ NeutronSensorMachine this$0;
            {
                this.this$0 = $receiver;
                super(80, 35, 85, 18, $super_call_param$1, $super_call_param$2);
            }

            public final int getMaxValue() {
                return this.maxValue;
            }

            public final void setMaxValue(int n) {
                this.maxValue = n;
            }

            public void updateScreen() {
                super.updateScreen();
                if (this.maxValue != NeutronSensorMachine.access$getMax$p(this.this$0)) {
                    this.maxValue = NeutronSensorMachine.access$getMax$p(this.this$0);
                    this.setNumbersOnly(0, this.maxValue);
                }
            }
        }.setNumbersOnly(0, this.max));
        object = () -> NeutronSensorMachine.createUIWidget$lambda$2(this);
        consumer = arg_0 -> NeutronSensorMachine.createUIWidget$lambda$3(this, arg_0);
        group.addWidget((Widget)new TextFieldWidget(this, (Supplier<String>)object, consumer){
            private int minValue;
            final /* synthetic */ NeutronSensorMachine this$0;
            {
                this.this$0 = $receiver;
                super(80, 80, 85, 18, $super_call_param$1, $super_call_param$2);
            }

            public final int getMinValue() {
                return this.minValue;
            }

            public final void setMinValue(int n) {
                this.minValue = n;
            }

            public void updateScreen() {
                super.updateScreen();
                if (this.minValue != NeutronSensorMachine.access$getMin$p(this.this$0)) {
                    this.minValue = NeutronSensorMachine.access$getMin$p(this.this$0);
                    this.setNumbersOnly(this.minValue, 1200000);
                }
            }
        }.setNumbersOnly(this.min, 1200000));
        group.addWidget((Widget)new ToggleButtonWidget(8, 8, 20, 20, (IGuiTexture)GuiTextures.INVERT_REDSTONE_BUTTON, () -> NeutronSensorMachine.createUIWidget$lambda$4((KMutableProperty0)new MutablePropertyReference0Impl((Object)this){

            public Object get() {
                return NeutronSensorMachine.access$isInverted$p((NeutronSensorMachine)((Object)this.receiver));
            }

            public void set(Object value) {
                NeutronSensorMachine.access$setInverted((NeutronSensorMachine)((Object)this.receiver), (Boolean)value);
            }
        }), arg_0 -> NeutronSensorMachine.createUIWidget$lambda$5(this, arg_0)).setTooltipText("gui.gtnn.neutron_sensor.invert"));
        group.addWidget((Widget)new LabelWidget(80, 13, "1000 KeV = 1 MeV").setTextColor(ColorPattern.BLACK.color).setDropShadow(false));
        return (Widget)group;
    }

    public final void update(int energy) {
        this.energy = energy;
        int output = RedstoneUtil.computeRedstoneBetweenValues((float)energy, (float)(this.max * this.k), (float)(this.min * this.k), (boolean)this.isInverted);
        if (this.redstoneSignalOutput != output) {
            this.setRedstoneSignalOutput(output);
        }
    }

    private final void update() {
        this.update(this.energy);
        this.updateSignal();
    }

    public int getOutputSignal(@Nullable Direction side) {
        if (side == this.getFrontFacing().m_122424_()) {
            return this.redstoneSignalOutput;
        }
        return 0;
    }

    public boolean canConnectRedstone(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return false;
    }

    private final String toText(int num) {
        return String.valueOf(num);
    }

    private final int fromText(String num) {
        return Integer.parseInt(num);
    }

    @NotNull
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    private static final String createUIWidget$lambda$0(NeutronSensorMachine this$0) {
        return this$0.toText(this$0.min);
    }

    private static final void createUIWidget$lambda$1(NeutronSensorMachine this$0, String it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.setMin(this$0.clamp(this$0.fromText(it), 0, this$0.max));
    }

    private static final String createUIWidget$lambda$2(NeutronSensorMachine this$0) {
        return this$0.toText(this$0.max);
    }

    private static final void createUIWidget$lambda$3(NeutronSensorMachine this$0, String it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.setMax(this$0.clamp(this$0.fromText(it), this$0.min, 1200000));
    }

    private static final boolean createUIWidget$lambda$4(KMutableProperty0 $tmp0) {
        return (Boolean)((Function0)$tmp0).invoke();
    }

    private static final void createUIWidget$lambda$5(NeutronSensorMachine this$0, boolean it) {
        this$0.setInverted(it);
    }

    public static final /* synthetic */ int access$getMax$p(NeutronSensorMachine $this) {
        return $this.max;
    }

    public static final /* synthetic */ int access$getMin$p(NeutronSensorMachine $this) {
        return $this.min;
    }

    public static final /* synthetic */ boolean access$isInverted$p(NeutronSensorMachine $this) {
        return $this.isInverted;
    }

    public static final /* synthetic */ void access$setInverted(NeutronSensorMachine $this, boolean isInverted) {
        $this.setInverted(isInverted);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/arbor/gtnn/common/machine/multiblock/part/NeutronSensorMachine$Companion;", "", "<init>", "()V", "MANAGED_FIELD_HOLDER", "Lcom/lowdragmc/lowdraglib/syncdata/field/ManagedFieldHolder;", "gtnn-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

