/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.common.recipe;

import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.condition.RecipeConditionType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.arbor.gtnn.common.machine.multiblock.ChemicalPlantMachine;
import dev.arbor.gtnn.data.GTNNRecipeConditions;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\tJ\f\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0001H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/arbor/gtnn/common/recipe/PlantCasingCondition;", "Lcom/gregtechceu/gtceu/api/recipe/RecipeCondition;", "<init>", "()V", "tier", "", "(I)V", "isReverse", "", "(ZI)V", "getType", "Lcom/gregtechceu/gtceu/api/recipe/condition/RecipeConditionType;", "getTooltips", "Lnet/minecraft/network/chat/Component;", "testCondition", "gtRecipe", "Lcom/gregtechceu/gtceu/api/recipe/GTRecipe;", "recipeLogic", "Lcom/gregtechceu/gtceu/api/machine/trait/RecipeLogic;", "createTemplate", "Companion", "gtnn-1.20.1"})
public final class PlantCasingCondition
extends RecipeCondition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int tier;
    @NotNull
    private static final Codec<PlantCasingCondition> CODEC;
    public static final int BRONZE = 1;
    public static final int STEEL = 2;
    public static final int ALUMINIUM = 3;
    public static final int STAINLESS_STEEL = 4;
    public static final int TITANIUM = 5;
    public static final int TUNGSTEN_STEEL = 6;
    @NotNull
    private static Map<Integer, String> CASING_TIERS;

    public PlantCasingCondition() {
    }

    public PlantCasingCondition(int tier) {
        this.tier = Mth.m_14045_((int)tier, (int)1, (int)6);
    }

    public PlantCasingCondition(boolean isReverse, int tier) {
        super(isReverse);
        this.tier = Mth.m_14045_((int)tier, (int)1, (int)6);
    }

    @NotNull
    public RecipeConditionType<?> getType() {
        return GTNNRecipeConditions.getPLANT_CASING();
    }

    @NotNull
    public Component getTooltips() {
        Object[] objectArray = new Object[2];
        objectArray[0] = this.tier;
        String string = CASING_TIERS.get(this.tier);
        Intrinsics.checkNotNull((Object)string);
        objectArray[1] = Component.m_237115_((String)string);
        MutableComponent mutableComponent = Component.m_237110_((String)"gtnn.recipe.condition.plant_casing.tooltip", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return (Component)mutableComponent;
    }

    protected boolean testCondition(@NotNull GTRecipe gtRecipe, @NotNull RecipeLogic recipeLogic) {
        Intrinsics.checkNotNullParameter((Object)gtRecipe, (String)"gtRecipe");
        Intrinsics.checkNotNullParameter((Object)recipeLogic, (String)"recipeLogic");
        IRecipeLogicMachine machine = recipeLogic.machine;
        if (machine instanceof ChemicalPlantMachine) {
            return ((ChemicalPlantMachine)machine).getCasingTier() >= this.tier;
        }
        return false;
    }

    @NotNull
    public RecipeCondition createTemplate() {
        return new PlantCasingCondition();
    }

    private static final Integer CODEC$lambda$1$lambda$0(PlantCasingCondition it) {
        return it.tier;
    }

    private static final App CODEC$lambda$1(RecordCodecBuilder.Instance instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        return RecipeCondition.isReverse((RecordCodecBuilder.Instance)instance).and((App)Codec.INT.fieldOf("plantCasing").forGetter(PlantCasingCondition::CODEC$lambda$1$lambda$0)).apply((Applicative)instance, PlantCasingCondition::new);
    }

    static {
        Codec codec = RecordCodecBuilder.create(PlantCasingCondition::CODEC$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        CODEC = codec;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)1, (Object)"gtnn.recipe.condition.plant_casing.tier.bronze"), TuplesKt.to((Object)2, (Object)"gtnn.recipe.condition.plant_casing.tier.steel"), TuplesKt.to((Object)3, (Object)"gtnn.recipe.condition.plant_casing.tier.aluminium"), TuplesKt.to((Object)4, (Object)"gtnn.recipe.condition.plant_casing.tier.stainless_steel"), TuplesKt.to((Object)5, (Object)"gtnn.recipe.condition.plant_casing.tier.titanium"), TuplesKt.to((Object)6, (Object)"gtnn.recipe.condition.plant_casing.tier.tungsten_steel")};
        CASING_TIERS = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R&\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Ldev/arbor/gtnn/common/recipe/PlantCasingCondition$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/arbor/gtnn/common/recipe/PlantCasingCondition;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "BRONZE", "", "STEEL", "ALUMINIUM", "STAINLESS_STEEL", "TITANIUM", "TUNGSTEN_STEEL", "CASING_TIERS", "", "", "getCASING_TIERS", "()Ljava/util/Map;", "setCASING_TIERS", "(Ljava/util/Map;)V", "gtnn-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<PlantCasingCondition> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final Map<Integer, String> getCASING_TIERS() {
            return CASING_TIERS;
        }

        public final void setCASING_TIERS(@NotNull Map<Integer, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            CASING_TIERS = map;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

