/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.data;

import com.gregtechceu.gtceu.api.data.worldgen.IWorldGenLayer;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import dev.arbor.gtnn.data.tags.GTNNTags;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006\u0013"}, d2={"Ldev/arbor/gtnn/data/GTNNWorld;", "", "<init>", "()V", "TWILIGHT_FOREST", "Lnet/minecraft/resources/ResourceLocation;", "getTWILIGHT_FOREST", "()Lnet/minecraft/resources/ResourceLocation;", "MOON", "getMOON", "VENUS", "getVENUS", "MARS", "getMARS", "MERCURY", "getMERCURY", "GLACIO", "getGLACIO", "GTNNWorldGenLayers", "gtnn-1.20.1"})
public final class GTNNWorld {
    @NotNull
    public static final GTNNWorld INSTANCE = new GTNNWorld();
    @NotNull
    private static final ResourceLocation TWILIGHT_FOREST = new ResourceLocation("twilightforest", "twilight_forest");
    @NotNull
    private static final ResourceLocation MOON = new ResourceLocation("ad_astra", "moon");
    @NotNull
    private static final ResourceLocation VENUS = new ResourceLocation("ad_astra", "venus");
    @NotNull
    private static final ResourceLocation MARS = new ResourceLocation("ad_astra", "mars");
    @NotNull
    private static final ResourceLocation MERCURY = new ResourceLocation("ad_astra", "mercury");
    @NotNull
    private static final ResourceLocation GLACIO = new ResourceLocation("ad_astra", "glacio");

    private GTNNWorld() {
    }

    @NotNull
    public final ResourceLocation getTWILIGHT_FOREST() {
        return TWILIGHT_FOREST;
    }

    @NotNull
    public final ResourceLocation getMOON() {
        return MOON;
    }

    @NotNull
    public final ResourceLocation getVENUS() {
        return VENUS;
    }

    @NotNull
    public final ResourceLocation getMARS() {
        return MARS;
    }

    @NotNull
    public final ResourceLocation getMERCURY() {
        return MERCURY;
    }

    @NotNull
    public final ResourceLocation getGLACIO() {
        return GLACIO;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u0000 \u00152\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00000\u0003:\u0001\u0015B'\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\b\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0016"}, d2={"Ldev/arbor/gtnn/data/GTNNWorld$GTNNWorldGenLayers;", "Lcom/gregtechceu/gtceu/api/data/worldgen/IWorldGenLayer;", "Lnet/minecraft/util/StringRepresentable;", "", "id", "", "target", "Lnet/minecraft/world/level/levelgen/structure/templatesystem/RuleTest;", "levels", "", "Lnet/minecraft/resources/ResourceLocation;", "<init>", "(Ljava/lang/String;ILjava/lang/String;Lnet/minecraft/world/level/levelgen/structure/templatesystem/RuleTest;Ljava/util/Set;)V", "AD", "TF", "getLevels", "getTarget", "isApplicableForLevel", "", "level", "getSerializedName", "Companion", "gtnn-1.20.1"})
    public static final class GTNNWorldGenLayers
    extends Enum<GTNNWorldGenLayers>
    implements IWorldGenLayer,
    StringRepresentable {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String id;
        @NotNull
        private final RuleTest target;
        @NotNull
        private final Set<ResourceLocation> levels;
        public static final /* enum */ GTNNWorldGenLayers AD;
        public static final /* enum */ GTNNWorldGenLayers TF;
        private static final /* synthetic */ GTNNWorldGenLayers[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private GTNNWorldGenLayers(String id, RuleTest target, Set<? extends ResourceLocation> levels) {
            this.id = id;
            this.target = target;
            this.levels = levels;
            SortedMap sortedMap = WorldGeneratorUtils.WORLD_GEN_LAYERS;
            Intrinsics.checkNotNullExpressionValue((Object)sortedMap, (String)"WORLD_GEN_LAYERS");
            Map map = sortedMap;
            map.put(this.id, this);
        }

        @NotNull
        public Set<ResourceLocation> getLevels() {
            return this.levels;
        }

        @NotNull
        public RuleTest getTarget() {
            return this.target;
        }

        public boolean isApplicableForLevel(@NotNull ResourceLocation level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            return this.levels.contains(level);
        }

        @NotNull
        public String m_7912_() {
            return this.id;
        }

        public static GTNNWorldGenLayers[] values() {
            return (GTNNWorldGenLayers[])$VALUES.clone();
        }

        public static GTNNWorldGenLayers valueOf(String value) {
            return Enum.valueOf(GTNNWorldGenLayers.class, value);
        }

        @NotNull
        public static EnumEntries<GTNNWorldGenLayers> getEntries() {
            return $ENTRIES;
        }

        static {
            Object[] objectArray = new ResourceLocation[]{INSTANCE.getMOON(), INSTANCE.getMARS(), INSTANCE.getMERCURY(), INSTANCE.getVENUS(), INSTANCE.getGLACIO()};
            AD = new GTNNWorldGenLayers("ad", (RuleTest)new TagMatchTest(GTNNTags.INSTANCE.getAD_ASTRA_STONES()), SetsKt.setOf((Object[])objectArray));
            TF = new GTNNWorldGenLayers("tf", (RuleTest)new TagMatchTest(BlockTags.f_144266_), SetsKt.setOf((Object)INSTANCE.getTWILIGHT_FOREST()));
            $VALUES = gTNNWorldGenLayersArray = new GTNNWorldGenLayers[]{GTNNWorldGenLayers.AD, GTNNWorldGenLayers.TF};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Ldev/arbor/gtnn/data/GTNNWorld$GTNNWorldGenLayers$Companion;", "", "<init>", "()V", "init", "", "gtnn-1.20.1"})
        public static final class Companion {
            private Companion() {
            }

            public final void init() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

