/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.data.lang;

import com.gregtechceu.gtceu.api.GTValues;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.arbor.gtnn.api.registry.NNLangProvider;
import dev.arbor.gtnn.data.block.GTNNBlocks;
import dev.arbor.gtnn.data.block.GTNNCasingBlocks;
import dev.arbor.gtnn.data.lang.NNLangHandler;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Ldev/arbor/gtnn/data/lang/BlockLang;", "", "<init>", "()V", "init", "", "provider", "Ldev/arbor/gtnn/api/registry/NNLangProvider;", "getCATier", "", "tier", "", "isEN", "", "gtnn-1.20.1"})
public final class BlockLang {
    @NotNull
    public static final BlockLang INSTANCE = new BlockLang();

    private BlockLang() {
    }

    public final void init(@NotNull NNLangProvider provider) {
        Intrinsics.checkNotNullParameter((Object)((Object)provider), (String)"provider");
        provider.addBlockWithTooltip((NonNullSupplier<? extends Block>)((NonNullSupplier)GTNNBlocks.INSTANCE.getOSMIUM_BOROSILICATE_GLASS()), "Osmium-reinforced Borosilicate Glass", "\u9507\u5f3a\u5316\u787c\u7845\u73bb\u7483", "\u00a77Star of Industry", "\u00a77\u5de5\u4e1a\u4e4b\u661f");
        int[] nArray = GTValues.tiersBetween((int)1, (int)14);
        provider.addTieredBlockWithTooltip(BlockLang::init$lambda$0, BlockLang::init$lambda$1, BlockLang::init$lambda$2, BlockLang::init$lambda$3, BlockLang::init$lambda$4, Arrays.copyOf(nArray, nArray.length));
        provider.addBlockName((NonNullSupplier<? extends Block>)((NonNullSupplier)GTNNCasingBlocks.INSTANCE.getADVANCED_FILTER_CASING()), "Advanced Filter Casing", "\u9ad8\u7ea7\u8fc7\u6ee4\u5668\u673a\u68b0\u65b9\u5757");
        provider.addBlockName((NonNullSupplier<? extends Block>)((NonNullSupplier)GTNNCasingBlocks.INSTANCE.getIRIDIUM_CASING()), "Iridium Casing", "\u94f1\u673a\u68b0\u65b9\u5757");
        provider.addBlockName((NonNullSupplier<? extends Block>)((NonNullSupplier)GTNNCasingBlocks.INSTANCE.getCASING_POLYBENZIMIDAZOLE_PIPE()), "Casing Polybenzimidazole Pipe", "\u805a\u82ef\u5e76\u54aa\u5511\u7ba1\u9053\u65b9\u5757");
        NNLangHandler.INSTANCE.tsl("block.gtnn.clean_machine_casing", "\u6d01\u51c0\u673a\u68b0\u65b9\u5757");
        NNLangHandler.INSTANCE.tsl("block.gtnn.field_restriction_casing", "\u7acb\u573a\u7ea6\u675f\u673a\u68b0\u65b9\u5757");
        NNLangHandler.INSTANCE.tsl("block.gtnn.radiation_proof_machine_casing", "\u9632\u8f90\u5c04\u673a\u68b0\u65b9\u5757");
        NNLangHandler.INSTANCE.tsl("block.gtnn.high_speed_pipe_block", "\u9ad8\u901f\u7ba1\u9053\u65b9\u5757");
    }

    private final String getCATier(int tier, boolean isEN) {
        return switch (tier) {
            case 1 -> {
                if (isEN) {
                    yield "Simple";
                }
                yield "\u7b80\u6613";
            }
            case 2 -> {
                if (isEN) {
                    yield "Crude";
                }
                yield "\u7c97\u5236";
            }
            case 3 -> {
                if (isEN) {
                    yield "Premium";
                }
                yield "\u4f18\u8d28";
            }
            case 4 -> {
                if (isEN) {
                    yield "Advanced";
                }
                yield "\u8fdb\u9636";
            }
            case 5 -> {
                if (isEN) {
                    yield "High-quality";
                }
                yield "\u9ad8\u7ea7";
            }
            case 6 -> {
                if (isEN) {
                    yield "High-precision";
                }
                yield "\u9ad8\u7cbe\u5ea6";
            }
            case 7 -> {
                if (isEN) {
                    yield "Ultra-high Precision";
                }
                yield "\u8d85\u9ad8\u7cbe\u5ea6";
            }
            case 8 -> {
                if (isEN) {
                    yield "Extreme Precision";
                }
                yield "\u6781\u9650\u7cbe\u5ea6";
            }
            case 9 -> {
                if (isEN) {
                    yield "Extremely High-precision";
                }
                yield "\u6781\u9ad8\u7cbe\u5ea6";
            }
            case 10 -> {
                if (isEN) {
                    yield "Structural";
                }
                yield "\u7ed3\u6784";
            }
            case 11 -> {
                if (isEN) {
                    yield "Large-scale Structural";
                }
                yield "\u5927\u5c3a\u5ea6\u7ed3\u6784";
            }
            case 12 -> {
                if (isEN) {
                    yield "Superstructural";
                }
                yield "\u8d85\u7ed3\u6784";
            }
            case 13 -> {
                if (isEN) {
                    yield "Cosmic";
                }
                yield "\u5b87\u5b99";
            }
            default -> isEN ? "Space-time" : "\u65f6\u7a7a";
        };
    }

    private static final String init$lambda$0(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = GTValues.VN[it];
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return "component_assline_casing_" + string2;
    }

    private static final String init$lambda$1(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "Component Assembly Line Casing (" + GTValues.VNF[it] + "\u00a7r)";
    }

    private static final String init$lambda$2(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\u90e8\u4ef6\u88c5\u914d\u7ebf\u5916\u58f3\uff08" + GTValues.VNF[it] + "\u00a7r\uff09";
    }

    private static final String init$lambda$3(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\u00a77" + INSTANCE.getCATier(it, true) + " Assembly Unit";
    }

    private static final String init$lambda$4(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\u00a77" + INSTANCE.getCATier(it, false) + "\u88c5\u914d\u5355\u5143";
    }
}

