/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.data.lang;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import dev.arbor.gtnn.api.registry.NNLangProvider;
import dev.arbor.gtnn.data.GTNNMaterials;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\f\u001a\u00020\u000bH\u0002J\u0006\u0010\r\u001a\u00020\u000bJ\b\u0010\u000e\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u001a\u0010\u0014\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Ldev/arbor/gtnn/data/lang/MaterialLang;", "", "<init>", "()V", "provider", "Ldev/arbor/gtnn/api/registry/NNLangProvider;", "getProvider", "()Ldev/arbor/gtnn/api/registry/NNLangProvider;", "setProvider", "(Ldev/arbor/gtnn/api/registry/NNLangProvider;)V", "init", "", "tagPrefix", "materials", "jeiOreVeins", "tsl", "key", "", "cn", "en", "translateMaterial", "material", "Lcom/gregtechceu/gtceu/api/data/chemical/material/Material;", "translateOreVein", "gtnn-1.20.1"})
public final class MaterialLang {
    @NotNull
    public static final MaterialLang INSTANCE = new MaterialLang();
    public static NNLangProvider provider;

    private MaterialLang() {
    }

    @NotNull
    public final NNLangProvider getProvider() {
        NNLangProvider nNLangProvider = provider;
        if (nNLangProvider != null) {
            return nNLangProvider;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"provider");
        return null;
    }

    public final void setProvider(@NotNull NNLangProvider nNLangProvider) {
        Intrinsics.checkNotNullParameter((Object)((Object)nNLangProvider), (String)"<set-?>");
        provider = nNLangProvider;
    }

    public final void init(@NotNull NNLangProvider provider) {
        Intrinsics.checkNotNullParameter((Object)((Object)provider), (String)"provider");
        this.setProvider(provider);
        this.tagPrefix();
        this.materials();
        this.jeiOreVeins();
    }

    private final void tagPrefix() {
        this.tsl("tagprefix.blackstone", "\u5d4c%s\u9ed1\u77f3", "Blackstone %s Ore");
        this.tsl("tagprefix.glacio_stone", "\u575a\u51b0\u5ca9%s\u77ff\u77f3", "Glacio Stone %s Ore");
        this.tsl("tagprefix.mars_stone", "\u6df1\u7ea2\u5ca9%s\u77ff\u77f3", "Mars Stone %s Ore");
        this.tsl("tagprefix.mercury_stone", "\u65f1\u6d77\u5ca9%s\u77ff\u77f3", "Mercury Stone %s Ore");
        this.tsl("tagprefix.moon_stone", "\u6708\u5ca9%s\u77ff\u77f3", "Moon Stone %s Ore");
        this.tsl("tagprefix.soul_soil", "\u542b%s\u7075\u9b42\u571f", "Soul Soil %s Ore");
        this.tsl("tagprefix.venus_stone", "\u9503\u91d1\u5ca9%s\u77ff\u77f3", "Venus Stone %s Ore");
        this.tsl("tagprefix.catalyst", "%s\u50ac\u5316\u5242", "%s Catalyst");
    }

    public final void materials() {
        this.translateMaterial(GTNNMaterials.AndesiteAlloy, "\u5b89\u5c71\u5408\u91d1");
        this.translateMaterial(GTNNMaterials.SpaceNeutronium, "\u4e2d\u5b50");
        this.translateMaterial(GTNNMaterials.Infinity, "\u65e0\u5c3d");
        this.translateMaterial(GTNNMaterials.InfinityCatalyst, "\u65e0\u5c3d\u50ac\u5316\u5242");
        this.translateMaterial(GTNNMaterials.Desh, "\u6234\u65af");
        this.translateMaterial(GTNNMaterials.Ostrum, "\u7d2b\u91d1");
        this.translateMaterial(GTNNMaterials.Calorite, "\u8010\u70ed\u91d1\u5c5e");
        this.translateMaterial(GTNNMaterials.RP1, "RP-1\u6df7\u5408\u71c3\u6599");
        this.translateMaterial(GTNNMaterials.RP1RocketFuel, "RP-1\u706b\u7bad\u71c3\u6599");
        this.translateMaterial(GTNNMaterials.Kerosene, "\u7164\u6cb9");
        this.translateMaterial(GTNNMaterials.DenseHydrazineMixedFuel, "\u6d53\u7f29\u80bc\u6df7\u5408\u71c3\u6599");
        this.translateMaterial(GTNNMaterials.Hydrazine, "\u80bc");
        this.translateMaterial(GTNNMaterials.HydrogenPeroxide, "\u8fc7\u6c27\u5316\u6c22");
        this.translateMaterial(GTNNMaterials.EthylAnthraQuinone, "\u4e59\u57fa\u84bd\u918c");
        this.translateMaterial(GTNNMaterials.EthylAnthraHydroQuinone, "\u4e59\u57fa\u84bd\u918c\u9187");
        this.translateMaterial(GTNNMaterials.Anthracene, "\u84bd");
        this.translateMaterial(GTNNMaterials.MethylhydrazineNitrateRocketFuel, "CN3H7O3\u706b\u7bad\u71c3\u6599");
        this.translateMaterial(GTNNMaterials.MethylHydrazine, "\u7532\u57fa\u80bc");
        this.translateMaterial(GTNNMaterials.UDMHRocketFuel, "H8N4C2O4\u706b\u7bad\u71c3\u6599");
        this.translateMaterial(GTNNMaterials.UDMH, "\u504f\u4e8c\u7532\u80bc");
        this.translateMaterial(GTNNMaterials.OrangeMetal, "\u6a59\u8272\u91d1\u5c5e");
        this.translateMaterial(GTNNMaterials.PhthalicAnhydride, "\u90bb\u82ef\u4e8c\u7532\u9178\u9150");
        this.translateMaterial(GTNNMaterials.VanadiumPentoxide, "\u4e94\u6c27\u5316\u4e8c\u9492");
        this.translateMaterial(GTNNMaterials.BlackMatter, "\u9ed1\u7269\u8d28");
        this.translateMaterial(GTNNMaterials.Cerrobase140, "\u94cb\u94c5\u5408\u91d1140");
        this.translateMaterial(GTNNMaterials.ShadowSteel, "\u6697\u5f71\u94a2");
        this.translateMaterial(GTNNMaterials.RefinedRadiance, "\u5149\u8f89\u77f3");
        this.translateMaterial(GTNNMaterials.PlatinumSalt, "\u94c2\u76d0");
        this.translateMaterial(GTNNMaterials.PlatinumSlag, "\u94c2\u6e23");
        this.translateMaterial(GTNNMaterials.RefinedPlatinumSalt, "\u7cbe\u70bc\u94c2\u76d0");
        this.translateMaterial(GTNNMaterials.PalladiumSalt, "\u94af\u76d0");
        this.translateMaterial(GTNNMaterials.RhodiumFilterCake, "\u94d1\u6ee4\u997c");
        this.translateMaterial(GTNNMaterials.RhodiumNitrate, "\u785d\u9178\u94d1");
        this.translateMaterial(GTNNMaterials.RoughlyRhodiumMetal, "\u7c97\u5236\u94d1\u91d1\u5c5e");
        this.translateMaterial(GTNNMaterials.PalladiumMetal, "\u94af\u91d1\u5c5e");
        this.translateMaterial(GTNNMaterials.SodiumRutheniate, "\u948c\u9178\u94a0");
        this.translateMaterial(GTNNMaterials.IridiumDioxide, "\u4e8c\u6c27\u5316\u94f1");
        this.translateMaterial(GTNNMaterials.MetalSludge, "\u91d1\u5c5e\u6ce5\u6e23");
        this.translateMaterial(GTNNMaterials.ConcentratedPlatinum, "\u6d53\u7f29\u94c2");
        this.translateMaterial(GTNNMaterials.RhodiumSulfateGas, "\u786b\u9178\u94d1");
        this.translateMaterial(GTNNMaterials.PalladiumRichAmmonia, "\u5bcc\u94af\u6c28");
        this.translateMaterial(GTNNMaterials.RhodiumSalt, "\u94d1\u76d0");
        this.translateMaterial(GTNNMaterials.RutheniumTetroxideHot, "\u70ed\u56db\u6c27\u5316\u948c");
        this.translateMaterial(GTNNMaterials.RutheniumTetroxideLQ, "\u56db\u6c27\u5316\u948c");
        this.translateMaterial(GTNNMaterials.ReprecipitatedRhodium, "\u518d\u6c89\u6dc0\u94d1");
        this.translateMaterial(GTNNMaterials.AcidicIridium, "\u9178\u6027\u94f1");
        this.translateMaterial(GTNNMaterials.PlatinumMetal, "\u94c2\u91d1\u5c5e");
        this.translateMaterial(GTNNMaterials.PotassiumPyrosulfate, "\u7126\u786b\u9178\u94be");
        this.translateMaterial(GTNNMaterials.SodiumFormate, "\u7532\u9178\u94a0");
        this.translateMaterial(GTNNMaterials.SodiumSulfate, "\u786b\u9178\u94a0");
        this.translateMaterial(GTNNMaterials.SodiumNitrate, "\u785d\u9178\u94a0");
        this.translateMaterial(GTNNMaterials.ZincSulfate, "\u786b\u9178\u950c");
        this.translateMaterial(GTNNMaterials.Kaolinite, "\u9ad8\u5cad\u77f3");
        this.translateMaterial(GTNNMaterials.Dolomite, "\u767d\u4e91\u77f3");
        this.translateMaterial(GTNNMaterials.Wollastonite, "\u7845\u7070\u77f3");
        this.translateMaterial(GTNNMaterials.ArcaneCrystal, "\u795e\u79d8\u6c34\u6676");
        this.translateMaterial(GTNNMaterials.NaquadahOxideMixture, "\u6c27\u5316\u7845\u5ca9\u6df7\u5408\u7269");
        this.translateMaterial(GTNNMaterials.EnrichedNaquadahOxideMixture, "\u6c27\u5316\u5bcc\u96c6\u7845\u5ca9\u6df7\u5408\u7269");
        this.translateMaterial(GTNNMaterials.NaquadriaOxideMixture, "\u6c27\u5316\u8d85\u80fd\u7845\u5ca9\u6df7\u5408\u7269");
        this.translateMaterial(GTNNMaterials.HexafluorideEnrichedNaquadahSolution, "\u516d\u6c1f\u5316\u5bcc\u96c6\u7845\u5ca9\u6eb6\u6db2");
        this.translateMaterial(GTNNMaterials.XenonHexafluoroEnrichedNaquadate, "\u516d\u6c1f\u6c19\u9178\u5bcc\u96c6\u7845\u5ca9");
        this.translateMaterial(GTNNMaterials.PalladiumOnCarbon, "\u94af\u78b3");
        this.translateMaterial(GTNNMaterials.GoldTrifluoride, "\u4e09\u6c1f\u5316\u91d1");
        this.translateMaterial(GTNNMaterials.EnrichedNaquadahResidueSolution, "\u5bcc\u96c6\u7845\u5ca9\u6b8b\u4f59\u7269\u6eb6\u6db2");
        this.translateMaterial(GTNNMaterials.XenoauricFluoroantimonicAcid, "\u6c1f\u9511\u9178\u4e8c\u6c19");
        this.translateMaterial(GTNNMaterials.GoldChloride, "\u6c2f\u5316\u91d1");
        this.translateMaterial(GTNNMaterials.BromineTrifluoride, "\u4e09\u6c1f\u5316\u6eb4");
        this.translateMaterial(GTNNMaterials.HexafluorideNaquadriaSolution, "\u516d\u6c1f\u5316\u8d85\u80fd\u7845\u5ca9\u6eb6\u6db2");
        this.translateMaterial(GTNNMaterials.RadonDifluoride, "\u4e8c\u6c1f\u5316\u6c21");
        this.translateMaterial(GTNNMaterials.RadonNaquadriaOctafluoride, "\u516b\u6c1f\u8d85\u80fd\u7845\u5ca9\u9178\u6c21");
        this.translateMaterial(GTNNMaterials.NaquadriaResidueSolution, "\u8d85\u80fd\u7845\u5ca9\u6b8b\u4f59\u7269\u6eb6\u6db2");
        this.translateMaterial(GTNNMaterials.CaesiumFluoride, "\u6c1f\u5316\u94ef");
        this.translateMaterial(GTNNMaterials.XenonTrioxide, "\u4e09\u6c27\u5316\u6c19");
        this.translateMaterial(GTNNMaterials.CaesiumXenontrioxideFluoride, "\u4e8c\u6c1f\u4e09\u6c27\u6c19\u9178\u94ef");
        this.translateMaterial(GTNNMaterials.NaquadriaCaesiumXenonnonfluoride, "\u4e5d\u6c1f\u6c19\u9178\u8d85\u80fd\u7845\u5ca9\u94ef");
        this.translateMaterial(GTNNMaterials.RadonTrioxide, "\u4e09\u6c27\u5316\u6c21");
        this.translateMaterial(GTNNMaterials.NaquadriaCaesiumfluoride, "\u4e8c\u6c1f\u8d85\u80fd\u7845\u5ca9\u9178\u94ef");
        this.translateMaterial(GTNNMaterials.NitrosoniumOctafluoroxenate, "\u516b\u6c1f\u6c19\u9178\u4e9a\u785d\u9170");
        this.translateMaterial(GTNNMaterials.NitrylFluoride, "\u785d\u9170\u6c1f");
        this.translateMaterial(GTNNMaterials.AcidicNaquadriaCaesiumfluoride, "\u786b\u9178\u4e8c\u6c1f\u8d85\u80fd\u7845\u5ca9\u9178\u94ef");
        this.translateMaterial(GTNNMaterials.GraphiteUraniumMixture, "\u77f3\u58a8-\u94c0\u6df7\u5408\u7269");
        this.translateMaterial(GTNNMaterials.PlutoniumOxideUraniumMixture, "\u6c27\u5316\u949a-\u94c0\u6df7\u5408\u7269");
        this.translateMaterial(GTNNMaterials.UraniumCarbideThoriumMixture, "\u78b3\u5316\u94c0-\u948d\u6df7\u5408\u7269");
        this.translateMaterial(GTNNMaterials.ThoriumBasedLiquidFuel, "\u948d\u57fa\u6d41\u4f53\u71c3\u6599");
        this.translateMaterial(GTNNMaterials.ThoriumBasedLiquidFuelExcited, "\u948d\u57fa\u6d41\u4f53\u71c3\u6599(\u6fc0\u53d1\u6001)");
        this.translateMaterial(GTNNMaterials.ThoriumBasedLiquidFuelDepleted, "\u948d\u57fa\u6d41\u4f53\u71c3\u6599(\u67af\u7aed\u6001)");
        this.translateMaterial(GTNNMaterials.UraniumBasedLiquidFuel, "\u94c0\u57fa\u6d41\u4f53\u71c3\u6599");
        this.translateMaterial(GTNNMaterials.UraniumBasedLiquidFuelExcited, "\u94c0\u57fa\u6d41\u4f53\u71c3\u6599(\u6fc0\u53d1\u6001)");
        this.translateMaterial(GTNNMaterials.UraniumBasedLiquidFuelDepleted, "\u94c0\u57fa\u6d41\u4f53\u71c3\u6599(\u67af\u7aed\u6001)");
        this.translateMaterial(GTNNMaterials.PlutoniumBasedLiquidFuel, "\u949a\u57fa\u6d41\u4f53\u71c3\u6599");
        this.translateMaterial(GTNNMaterials.PlutoniumBasedLiquidFuelExcited, "\u949a\u57fa\u6d41\u4f53\u71c3\u6599(\u6fc0\u53d1\u6001)");
        this.translateMaterial(GTNNMaterials.PlutoniumBasedLiquidFuelDepleted, "\u949a\u57fa\u6d41\u4f53\u71c3\u6599(\u67af\u7aed\u6001)");
        this.translateMaterial(GTNNMaterials.RadiationProtection, "\u9632\u8f90\u5c04");
        this.translateMaterial(GTNNMaterials.NaquadahBasedLiquidFuel, "\u7845\u5ca9\u6d41\u4f53\u71c3\u6599");
        this.translateMaterial(GTNNMaterials.NaquadahBasedLiquidFuelExcited, "\u7845\u5ca9\u6d41\u4f53\u71c3\u6599(\u6fc0\u53d1\u6001)");
        this.translateMaterial(GTNNMaterials.NaquadahBasedLiquidFuelDepleted, "\u7845\u5ca9\u6d41\u4f53\u71c3\u6599(\u67af\u7aed\u6001)");
        this.translateMaterial(GTNNMaterials.Thorium232, "\u948d-232");
        this.translateMaterial(GTNNMaterials.IodizedBrine, "\u542b\u7898\u76d0\u6c34");
        this.translateMaterial(GTNNMaterials.IodineBrineMixture, "\u6d53\u7f29\u7898\u76d0\u6c34\u6df7\u5408\u7269");
        this.translateMaterial(GTNNMaterials.BrominatedBrine, "\u542b\u6eb4\u76d0\u6c34");
        this.translateMaterial(GTNNMaterials.IodineSlurry, "\u7898\u6d46\u6db2");
        this.translateMaterial(GTNNMaterials.AcidicBrominatedBrine, "\u9178\u5316\u542b\u6eb4\u76d0\u6c34");
        this.translateMaterial(GTNNMaterials.BromineSulfateSolution, "\u786b\u9178\u6eb4\u6eb6\u6db2");
        this.translateMaterial(GTNNMaterials.OverheatedBromineSulfateSolution, "\u8fc7\u70ed\u786b\u9178\u6eb4\u6c14");
        this.translateMaterial(GTNNMaterials.WetBromine, "\u6e7f\u6eb4\u6c14");
        this.translateMaterial(GTNNMaterials.DebrominatedWater, "\u8131\u6eb4\u76d0\u6c34");
        this.translateMaterial(GTNNMaterials.NeutroniumMixture, "\u4e2d\u5b50\u7d20\u6df7\u5408\u7269");
        this.translateMaterial(GTNNMaterials.ManaSteel, "\u9b54\u529b\u94a2");
        this.translateMaterial(GTNNMaterials.Elementium, "\u6e90\u8d28\u94a2");
        this.translateMaterial(GTNNMaterials.TerraSteel, "\u6cf0\u62c9\u94a2");
        this.translateMaterial(GTNNMaterials.MARM200Steel, "MAR-M200\u7279\u79cd\u94a2");
    }

    private final void jeiOreVeins() {
        this.translateOreVein("kaolinite_vein", "\u9ad8\u5cad\u77f3\u77ff\u8109");
        this.translateOreVein("wollastonite_vein", "\u767d\u4e91\u77f3\u77ff\u8109");
        this.translateOreVein("galena_vein_tf", "\u65b9\u94c5\u77ff\u8109");
        this.translateOreVein("sapphire_vein_tf", "\u84dd\u5b9d\u77f3\u77ff\u8109");
        this.translateOreVein("olivine_vein_tf", "\u6a44\u6984\u77f3\u77ff\u8109");
        this.translateOreVein("nickel_vein_tf", "\u954d\u77ff\u8109");
        this.translateOreVein("diamond_vein_tf", "\u94bb\u77f3\u77ff\u8109");
        this.translateOreVein("lapis_vein_tf", "\u9752\u91d1\u77f3\u77ff\u8109");
        this.translateOreVein("molybdenite_vein_tf", "\u8f89\u94bc\u77ff\u8109");
        this.translateOreVein("coal_vein_tf", "\u7164\u77ff\u8109");
        this.translateOreVein("lubricant_vein_tf", "\u7682\u77f3\u77ff\u8109");
        this.translateOreVein("gold_vein_tf", "\u91d1\u77ff\u8109");
        this.translateOreVein("iron_vein_tf", "\u94c1\u77ff\u8109");
        this.translateOreVein("apatite_vein_tf", "\u78f7\u7070\u77f3\u77ff\u8109");
        this.translateOreVein("salts_vein_tf", "\u76d0\u77ff\u8109");
        this.translateOreVein("cassiterite_vein_tf", "\u9521\u77f3\u77ff\u8109");
        this.translateOreVein("monazite_vein_n", "\u72ec\u5c45\u77f3\u77ff\u8109");
        this.translateOreVein("bauxite_vein", "\u94dd\u571f\u77ff\u8109");
        this.translateOreVein("ilmenite_vein", "\u949b\u94c1\u77ff\u8109");
        this.translateOreVein("quartzite_vein", "\u77f3\u82f1\u5ca9\u77ff\u8109");
        this.translateOreVein("molybdenum_vein_ad", "\u94bc\u77ff\u8109");
        this.translateOreVein("galena_vein_ad", "\u65b9\u94c5\u77ff\u8109");
        this.translateOreVein("copper_vein_ad", "\u94dc\u77ff\u8109");
        this.translateOreVein("cassiterite_vein_ad", "\u9521\u77f3\u77ff\u8109");
        this.translateOreVein("desh_vein_ad", "\u6234\u65af\u77ff\u8109");
        this.translateOreVein("ostrum_vein_ad", "\u7d2b\u91d1\u77ff\u8109");
        this.translateOreVein("arsenic_vein_ad", "\u7837\u77ff\u8109");
        this.translateOreVein("pitchblende_vein_ad", "\u6ca5\u9752\u94c0\u77ff\u8109");
        this.translateOreVein("tuff_uraninite_vein_ad", "\u6676\u8d28\u94c0\u77ff\u8109");
        this.translateOreVein("scheelite_vein_ad", "\u767d\u94a8\u77ff\u8109");
        this.translateOreVein("sulfur_vein_ad", "\u786b\u77ff\u8109");
        this.translateOreVein("redstone_vein_ad", "\u7ea2\u77f3\u77ff\u8109");
        this.translateOreVein("nickel_vein_ad", "\u954d\u77ff\u8109");
        this.translateOreVein("magnetite_vein_ad", "\u78c1\u94c1\u77ff\u8109");
        this.translateOreVein("iron_vein_ad", "\u94c1\u77ff\u8109");
        this.translateOreVein("beryllium_vein_ad", "\u94cd\u77ff\u8109");
        this.translateOreVein("tetrahedrite_vein_ad", "\u9edd\u94dc\u77ff\u8109");
        this.translateOreVein("salts_vein_ad", "\u76d0\u77ff\u8109");
        this.translateOreVein("naquadah_vein_ad_mars", "\u7845\u5ca9\u77ff\u8109");
        this.translateOreVein("chromium_vein_ad", "\u94ec\u77ff\u8109");
        this.translateOreVein("uranium238_vein_ad", "\u94c0238\u77ff\u8109");
        this.translateOreVein("magnesite_vein_ad", "\u83f1\u9541\u77ff\u8109");
        this.translateOreVein("platinum_vein_ad", "\u94c2\u77ff\u8109");
        this.translateOreVein("lapis_vein_ad", "\u9752\u91d1\u77f3\u77ff\u8109");
        this.translateOreVein("olivine_vein_ad", "\u6a44\u6984\u77f3\u77ff\u8109");
        this.translateOreVein("manganese_vein_ad", "\u9530\u77ff\u8109");
        this.translateOreVein("lubricant_vein_ad", "\u7682\u77f3\u77ff\u8109");
        this.translateOreVein("saltpeter_vein_ad", "\u84dd\u77f3\u77ff\u8109");
        this.translateOreVein("calorite_vein_ad", "\u8010\u70ed\u5408\u91d1\u77ff\u8109");
        this.translateOreVein("rutile_vein_ad", "\u91d1\u7ea2\u77f3\u77ff\u8109");
        this.translateOreVein("iridium_vein_ad", "\u94f1\u77ff\u8109");
        this.translateOreVein("pyrolusite_vein_ad", "\u8f6f\u9530\u77ff\u8109");
        this.translateOreVein("naquadah_vein_ad", "\u7845\u5ca9\u77ff\u8109");
        this.translateOreVein("osmium_vein_ad", "\u9507\u77ff\u8109");
        this.translateOreVein("neutronium_vein_ad", "\u4e2d\u5b50\u7d20\u77ff\u8109");
        this.translateOreVein("niobium_vein_ad", "\u94cc\u77ff\u8109");
    }

    private final void tsl(String key, String cn, String en) {
        this.getProvider().add(key, en, cn);
    }

    private final void translateMaterial(Material material, String cn) {
        if (material == null) {
            return;
        }
        String enName = FormattingUtil.toEnglishName((Object)material.getName());
        NNLangProvider nNLangProvider = this.getProvider();
        Intrinsics.checkNotNull((Object)enName);
        nNLangProvider.addMaterial(material, enName, cn);
    }

    private final void translateOreVein(String key, String cn) {
        this.getProvider().addOreVein(key, cn);
    }
}

