/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.data.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.SimpleGeneratorMachine;
import com.gregtechceu.gtceu.api.machine.SimpleTieredMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.OverclockingLogic;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.common.data.GTRecipeModifiers;
import com.gregtechceu.gtceu.common.data.machines.GTMachineUtils;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import dev.arbor.gtnn.GTNN;
import dev.arbor.gtnn.GTNNRegistries;
import dev.arbor.gtnn.api.registry.NNRegistrate;
import dev.arbor.gtnn.common.machine.GTNNGeneratorMachine;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J]\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\n2\u001e\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000f\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J3\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0018J;\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001d"}, d2={"Ldev/arbor/gtnn/data/machine/MachineReg;", "", "<init>", "()V", "registerTieredMachines", "", "Lcom/gregtechceu/gtceu/api/machine/MachineDefinition;", "name", "", "factory", "Ljava/util/function/BiFunction;", "Lcom/gregtechceu/gtceu/api/machine/IMachineBlockEntity;", "", "Lcom/gregtechceu/gtceu/api/machine/MetaMachine;", "builder", "Lcom/gregtechceu/gtceu/api/registry/registrate/MachineBuilder;", "tiers", "", "(Ljava/lang/String;Ljava/util/function/BiFunction;Ljava/util/function/BiFunction;[I)[Lcom/gregtechceu/gtceu/api/machine/MachineDefinition;", "registerSimpleMachines", "recipeType", "Lcom/gregtechceu/gtceu/api/recipe/GTRecipeType;", "tankScalingFunction", "Lit/unimi/dsi/fastutil/ints/Int2IntFunction;", "(Ljava/lang/String;Lcom/gregtechceu/gtceu/api/recipe/GTRecipeType;Lit/unimi/dsi/fastutil/ints/Int2IntFunction;[I)[Lcom/gregtechceu/gtceu/api/machine/MachineDefinition;", "registerGTNNGeneratorMachines", "recipeModifier", "Lcom/gregtechceu/gtceu/api/recipe/modifier/RecipeModifier;", "(Ljava/lang/String;Lcom/gregtechceu/gtceu/api/recipe/GTRecipeType;Lcom/gregtechceu/gtceu/api/recipe/modifier/RecipeModifier;Lit/unimi/dsi/fastutil/ints/Int2IntFunction;[I)[Lcom/gregtechceu/gtceu/api/machine/MachineDefinition;", "gtnn-1.20.1"})
public final class MachineReg {
    @NotNull
    public static final MachineReg INSTANCE = new MachineReg();

    private MachineReg() {
    }

    @NotNull
    public final MachineDefinition[] registerTieredMachines(@NotNull String name, @NotNull BiFunction<IMachineBlockEntity, Integer, MetaMachine> factory, @NotNull BiFunction<Integer, MachineBuilder<MachineDefinition>, MachineDefinition> builder, @NotNull int[] tiers) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)tiers, (String)"tiers");
        int n = GTValues.TIER_COUNT;
        MachineDefinition[] machineDefinitionArray = new MachineDefinition[n];
        for (int i = 0; i < n; ++i) {
            MachineDefinition machineDefinition;
            int n2;
            int n3 = n2 = i;
            MachineDefinition[] machineDefinitionArray2 = machineDefinitionArray;
            if (ArraysKt.contains((int[])tiers, (int)n2)) {
                String string;
                Integer n4 = n2;
                NNRegistrate nNRegistrate = GTNNRegistries.INSTANCE.getREGISTRATE();
                Intrinsics.checkNotNullExpressionValue((Object)GTValues.VN[n2], (String)"get(...)");
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                String string2 = string.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                machineDefinition = builder.apply(n4, (MachineBuilder<MachineDefinition>)nNRegistrate.machine(string2 + "_" + name, arg_0 -> MachineReg.registerTieredMachines$lambda$0(factory, n2, arg_0)).tier(n2));
            } else {
                machineDefinition = null;
            }
            machineDefinitionArray2[n3] = machineDefinition;
        }
        return machineDefinitionArray;
    }

    @NotNull
    public final MachineDefinition[] registerSimpleMachines(@NotNull String name, @NotNull GTRecipeType recipeType, @NotNull Int2IntFunction tankScalingFunction, @NotNull int[] tiers) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)recipeType, (String)"recipeType");
        Intrinsics.checkNotNullParameter((Object)tankScalingFunction, (String)"tankScalingFunction");
        Intrinsics.checkNotNullParameter((Object)tiers, (String)"tiers");
        return this.registerTieredMachines(name, (arg_0, arg_1) -> MachineReg.registerSimpleMachines$lambda$1(tankScalingFunction, arg_0, arg_1), (arg_0, arg_1) -> MachineReg.registerSimpleMachines$lambda$2(name, recipeType, tankScalingFunction, arg_0, arg_1), tiers);
    }

    @NotNull
    public final MachineDefinition[] registerGTNNGeneratorMachines(@NotNull String name, @NotNull GTRecipeType recipeType, @NotNull RecipeModifier recipeModifier, @NotNull Int2IntFunction tankScalingFunction, @NotNull int[] tiers) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)recipeType, (String)"recipeType");
        Intrinsics.checkNotNullParameter((Object)recipeModifier, (String)"recipeModifier");
        Intrinsics.checkNotNullParameter((Object)tankScalingFunction, (String)"tankScalingFunction");
        Intrinsics.checkNotNullParameter((Object)tiers, (String)"tiers");
        return this.registerTieredMachines(name, (arg_0, arg_1) -> MachineReg.registerGTNNGeneratorMachines$lambda$3(name, tankScalingFunction, arg_0, arg_1), (arg_0, arg_1) -> MachineReg.registerGTNNGeneratorMachines$lambda$4(name, recipeType, recipeModifier, tankScalingFunction, arg_0, arg_1), tiers);
    }

    private static final MetaMachine registerTieredMachines$lambda$0(BiFunction $factory, int $tmp, IMachineBlockEntity holder) {
        return (MetaMachine)$factory.apply(holder, $tmp);
    }

    private static final MetaMachine registerSimpleMachines$lambda$1(Int2IntFunction $tankScalingFunction, IMachineBlockEntity holder, Integer tier) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)tier, (String)"tier");
        return (MetaMachine)new SimpleTieredMachine(holder, tier.intValue(), $tankScalingFunction, new Object[0]);
    }

    private static final MachineDefinition registerSimpleMachines$lambda$2(String $name, GTRecipeType $recipeType, Int2IntFunction $tankScalingFunction, Integer tier, MachineBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)tier, (String)"tier");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Component[] componentArray = new Component[]{GTMachineUtils.explosion()};
        MachineBuilder machineBuilder = builder.langValue(GTValues.VLVH[tier] + " " + FormattingUtil.toEnglishName((Object)$name) + " " + GTValues.VLVT[tier]).editableUI((EditableMachineUI)SimpleTieredMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id((String)$name), $recipeType)).rotationState(RotationState.NON_Y_AXIS).recipeType($recipeType).recipeModifier((RecipeModifier)GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK)).workableTieredHullModel(GTNN.INSTANCE.id("block/machines/" + $name)).tooltips(componentArray);
        componentArray = GTMachineUtils.workableTiered((int)tier, (long)GTValues.V[tier], (long)(GTValues.V[tier] * (long)64), (GTRecipeType)$recipeType, (long)((Number)$tankScalingFunction.apply((Object)tier)).intValue(), (boolean)true);
        return machineBuilder.tooltips(Arrays.copyOf(componentArray, componentArray.length)).register();
    }

    private static final MetaMachine registerGTNNGeneratorMachines$lambda$3(String $name, Int2IntFunction $tankScalingFunction, IMachineBlockEntity holder, Integer tier) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)tier, (String)"tier");
        return (MetaMachine)new GTNNGeneratorMachine(holder, tier, $name, $tankScalingFunction, new Object[0]);
    }

    private static final MachineDefinition registerGTNNGeneratorMachines$lambda$4(String $name, GTRecipeType $recipeType, RecipeModifier $recipeModifier, Int2IntFunction $tankScalingFunction, Integer tier, MachineBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)tier, (String)"tier");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Component[] componentArray = new Component[1];
        Object[] objectArray = new Object[]{GTNNGeneratorMachine.Companion.getEfficiency(tier, $name)};
        componentArray[0] = Component.m_237110_((String)("gtnn.machine." + $name + ".tooltip"), (Object[])objectArray);
        MachineBuilder machineBuilder = builder.langValue(GTValues.VLVH[tier] + " " + FormattingUtil.toEnglishName((Object)$name) + " Generator " + GTValues.LVT[tier - 3]).editableUI((EditableMachineUI)SimpleGeneratorMachine.EDITABLE_UI_CREATOR.apply(GTNN.INSTANCE.id($name), $recipeType)).rotationState(RotationState.ALL).recipeType($recipeType).recipeModifier($recipeModifier, true).addOutputLimit((RecipeCapability)ItemRecipeCapability.CAP, 0).addOutputLimit((RecipeCapability)FluidRecipeCapability.CAP, 0).simpleGeneratorModel(GTNN.INSTANCE.id("block/generators/" + $name)).tooltips(componentArray);
        componentArray = new Component[]{GTMachineUtils.explosion()};
        MachineBuilder machineBuilder2 = machineBuilder.tooltips(componentArray);
        componentArray = GTMachineUtils.workableTiered((int)tier, (long)GTValues.V[tier], (long)(GTValues.V[tier] * (long)64), (GTRecipeType)$recipeType, (long)((Number)$tankScalingFunction.apply((Object)tier)).intValue(), (boolean)false);
        return machineBuilder2.tooltips(Arrays.copyOf(componentArray, componentArray.length)).register();
    }
}

