/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.data.recipes.handler;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntCircuitIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.core.mixins.IngredientAccessor;
import com.gregtechceu.gtceu.core.mixins.TagValueAccessor;
import com.gregtechceu.gtceu.data.recipe.CraftingComponent;
import com.gregtechceu.gtceu.data.recipe.GTCraftingComponents;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import dev.arbor.gtnn.GTNN;
import dev.arbor.gtnn.common.recipe.TierCasingCondition;
import dev.arbor.gtnn.data.GTNNRecipeTypes;
import dev.arbor.gtnn.data.item.GTNNWrapItem;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011J\u0014\u0010\u0016\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J \u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0014H\u0002J6\u0010 \u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001eH\u0002J8\u0010(\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u001eH\u0002J6\u0010/\u001a\u00020\u00142\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u00100\u001a\u00020*2\u0006\u0010,\u001a\u00020-2\u0006\u0010'\u001a\u00020\u001eH\u0002R\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Ldev/arbor/gtnn/data/recipes/handler/ComponentAssemblyLineRecipeHandler;", "", "<init>", "()V", "craftComponents", "", "Lcom/gregtechceu/gtceu/data/recipe/CraftingComponent;", "getCraftComponents", "()[Lcom/gregtechceu/gtceu/data/recipe/CraftingComponent;", "setCraftComponents", "([Lcom/gregtechceu/gtceu/data/recipe/CraftingComponent;)V", "[Lcom/gregtechceu/gtceu/data/recipe/CraftingComponent;", "componentItems", "Lit/unimi/dsi/fastutil/objects/Object2IntLinkedOpenHashMap;", "Lnet/minecraft/world/item/Item;", "recipeBuilders", "Ljava/util/ArrayList;", "Lcom/gregtechceu/gtceu/data/recipe/builder/GTRecipeBuilder;", "Lkotlin/collections/ArrayList;", "init", "", "recipeBuilder", "finish", "provider", "Ljava/util/function/Consumer;", "Lnet/minecraft/data/recipes/FinishedRecipe;", "handleComponent", "outputItem", "builder", "tier", "", "initComponentList", "handleMaterialEntry", "newBuilder", "fluidMap", "Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "Lnet/minecraft/world/level/material/Fluid;", "entry", "Lcom/gregtechceu/gtceu/api/data/chemical/material/stack/MaterialEntry;", "count", "conventPrefix", "originalPrefix", "Lcom/gregtechceu/gtceu/api/data/tag/TagPrefix;", "newPrefix", "material", "Lcom/gregtechceu/gtceu/api/data/chemical/material/Material;", "multiple", "conventPrefixToFluid", "prefix", "gtnn-1.20.1"})
@SourceDebugExtension(value={"SMAP\nComponentAssemblyLineRecipeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentAssemblyLineRecipeHandler.kt\ndev/arbor/gtnn/data/recipes/handler/ComponentAssemblyLineRecipeHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,273:1\n1869#2,2:274\n216#3,2:276\n*S KotlinDebug\n*F\n+ 1 ComponentAssemblyLineRecipeHandler.kt\ndev/arbor/gtnn/data/recipes/handler/ComponentAssemblyLineRecipeHandler\n*L\n73#1:274,2\n145#1:276,2\n*E\n"})
public final class ComponentAssemblyLineRecipeHandler {
    @NotNull
    public static final ComponentAssemblyLineRecipeHandler INSTANCE = new ComponentAssemblyLineRecipeHandler();
    @NotNull
    private static CraftingComponent[] craftComponents;
    @NotNull
    private static final Object2IntLinkedOpenHashMap<Item> componentItems;
    @NotNull
    private static final ArrayList<GTRecipeBuilder> recipeBuilders;

    private ComponentAssemblyLineRecipeHandler() {
    }

    @NotNull
    public final CraftingComponent[] getCraftComponents() {
        return craftComponents;
    }

    public final void setCraftComponents(@NotNull CraftingComponent[] craftingComponentArray) {
        Intrinsics.checkNotNullParameter((Object)craftingComponentArray, (String)"<set-?>");
        craftComponents = craftingComponentArray;
    }

    public final void init(@NotNull GTRecipeBuilder recipeBuilder) {
        Intrinsics.checkNotNullParameter((Object)recipeBuilder, (String)"recipeBuilder");
        List outputItems = RecipeHelper.getOutputItems((GTRecipeBuilder)recipeBuilder);
        if (outputItems.isEmpty()) {
            return;
        }
        Object e = outputItems.get(0);
        Intrinsics.checkNotNull(e);
        Item item = ((ItemStack)e).m_41720_();
        if (componentItems.containsKey((Object)item)) {
            Intrinsics.checkNotNull((Object)item);
            this.handleComponent(item, recipeBuilder, componentItems.getInt((Object)item));
        }
    }

    public final void finish(@NotNull Consumer<FinishedRecipe> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Iterable $this$forEach$iv = recipeBuilders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GTRecipeBuilder it = (GTRecipeBuilder)element$iv;
            boolean bl = false;
            it.save(provider);
        }
    }

    private final void handleComponent(Item outputItem, GTRecipeBuilder builder, int tier) {
        Object object;
        List inputItems = RecipeHelper.getInputContents((GTRecipeBuilder)builder, (RecipeCapability)((RecipeCapability)ItemRecipeCapability.CAP));
        List inputFluids = RecipeHelper.getInputContents((GTRecipeBuilder)builder, (RecipeCapability)((RecipeCapability)FluidRecipeCapability.CAP));
        Object2IntOpenHashMap inputFluidMap = new Object2IntOpenHashMap();
        GTRecipeType gTRecipeType = GTNNRecipeTypes.INSTANCE.getCOMPONENT_ASSEMBLY_LINE_RECIPES();
        String string = builder.id.m_135815_();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        GTRecipeBuilder gTRecipeBuilder = gTRecipeType.recipeBuilder(GTNN.INSTANCE.id(string));
        Intrinsics.checkNotNullExpressionValue((Object)gTRecipeBuilder, (String)"recipeBuilder(...)");
        GTRecipeBuilder newBuilder = gTRecipeBuilder;
        for (Ingredient input : inputItems) {
            Ingredient ingredient = input;
            if (ingredient instanceof IntCircuitIngredient) continue;
            if (ingredient instanceof SizedIngredient) {
                int n = ((SizedIngredient)input).getAmount();
                Ingredient ingredient2 = ((SizedIngredient)input).getInner();
                Intrinsics.checkNotNull((Object)ingredient2, (String)"null cannot be cast to non-null type com.gregtechceu.gtceu.core.mixins.IngredientAccessor");
                object = ArrayIteratorKt.iterator((Object[])((IngredientAccessor)ingredient2).getValues());
                while (object.hasNext()) {
                    MaterialEntry entry;
                    Ingredient.Value value = (Ingredient.Value)object.next();
                    if (value instanceof Ingredient.ItemValue) {
                        for (ItemStack stack : ((Ingredient.ItemValue)value).m_6223_()) {
                            entry = ChemicalHelper.getMaterialEntry((ItemLike)((ItemLike)stack.m_41720_()));
                            if (entry != null && entry != MaterialEntry.NULL_ENTRY) {
                                this.handleMaterialEntry(builder, newBuilder, (Object2IntOpenHashMap<Fluid>)inputFluidMap, entry, n);
                                continue;
                            }
                            newBuilder.inputItems(stack.m_255036_(n * 48));
                        }
                        continue;
                    }
                    if (value instanceof Ingredient.TagValue) {
                        TagKey tag = ((TagValueAccessor)value).getTag();
                        ResourceLocation location = tag.f_203868_();
                        if (Intrinsics.areEqual((Object)location.m_135827_(), (Object)"gtceu")) {
                            String string2 = location.m_135815_();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"circuits", (boolean)false, (int)2, null)) {
                                ItemLike warpItem = (ItemLike)GTNNWrapItem.INSTANCE.getWRAP_CIRCUIT_MAP().get((Object)tag);
                                if (warpItem == null) continue;
                                newBuilder.inputItems(new ItemStack(warpItem, n * 3));
                                continue;
                            }
                        }
                        if ((entry = ChemicalHelper.getMaterialEntry((TagKey)tag)) != null && entry != MaterialEntry.NULL_ENTRY) {
                            this.handleMaterialEntry(builder, newBuilder, (Object2IntOpenHashMap<Fluid>)inputFluidMap, entry, n);
                            continue;
                        }
                        newBuilder.inputItems(tag, n * 48);
                        continue;
                    }
                    value.m_6223_().forEach(arg_0 -> ComponentAssemblyLineRecipeHandler.handleComponent$lambda$1(newBuilder, n, arg_0));
                }
                continue;
            }
            Iterator iterator = ArrayIteratorKt.iterator((Object[])input.m_43908_());
            while (iterator.hasNext()) {
                ItemStack stack = (ItemStack)iterator.next();
                newBuilder.inputItems(stack.m_255036_(stack.m_41613_() * 48));
            }
        }
        inputFluids.forEach(arg_0 -> ComponentAssemblyLineRecipeHandler.handleComponent$lambda$2(newBuilder, arg_0));
        Map $this$forEach$iv = (Map)inputFluidMap;
        boolean $i$f$forEach = false;
        for (Map.Entry entry : $this$forEach$iv.entrySet()) {
            object = entry;
            boolean bl = false;
            Object k = object.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            Fluid fluid = (Fluid)k;
            Object v = object.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            Integer amount = (Integer)v;
            newBuilder.inputFluids(new FluidStack(fluid, amount.intValue()));
        }
        newBuilder.outputItems(outputItem, 64);
        newBuilder.EUt((long)GTValues.VA[tier]);
        newBuilder.duration(builder.duration * 48);
        newBuilder.addCondition((RecipeCondition)new TierCasingCondition(tier));
        String string3 = builder.id.m_135815_();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
        if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"electric_motor", (boolean)false, (int)2, null)) {
            newBuilder.circuitMeta(1);
        } else {
            String string4 = builder.id.m_135815_();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
            if (StringsKt.contains$default((CharSequence)string4, (CharSequence)"electric_pump", (boolean)false, (int)2, null)) {
                newBuilder.circuitMeta(2);
            } else {
                String string5 = builder.id.m_135815_();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getPath(...)");
                if (StringsKt.contains$default((CharSequence)string5, (CharSequence)"conveyor_module", (boolean)false, (int)2, null)) {
                    newBuilder.circuitMeta(3);
                } else {
                    String string6 = builder.id.m_135815_();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getPath(...)");
                    if (StringsKt.contains$default((CharSequence)string6, (CharSequence)"electric_piston", (boolean)false, (int)2, null)) {
                        newBuilder.circuitMeta(4);
                    } else {
                        String string7 = builder.id.m_135815_();
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getPath(...)");
                        if (StringsKt.contains$default((CharSequence)string7, (CharSequence)"robot_arm", (boolean)false, (int)2, null)) {
                            newBuilder.circuitMeta(5);
                        } else {
                            String string8 = builder.id.m_135815_();
                            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getPath(...)");
                            if (StringsKt.contains$default((CharSequence)string8, (CharSequence)"field_generator", (boolean)false, (int)2, null)) {
                                newBuilder.circuitMeta(6);
                            } else {
                                String string9 = builder.id.m_135815_();
                                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getPath(...)");
                                if (StringsKt.contains$default((CharSequence)string9, (CharSequence)"emitter", (boolean)false, (int)2, null)) {
                                    newBuilder.circuitMeta(7);
                                } else {
                                    String string10 = builder.id.m_135815_();
                                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"getPath(...)");
                                    if (StringsKt.contains$default((CharSequence)string10, (CharSequence)"sensor", (boolean)false, (int)2, null)) {
                                        newBuilder.circuitMeta(8);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        recipeBuilders.add(newBuilder);
    }

    private final void initComponentList() {
        int n = GTValues.TIER_COUNT;
        for (int i = 0; i < n; ++i) {
            for (CraftingComponent component : craftComponents) {
                Object stack;
                Intrinsics.checkNotNullExpressionValue((Object)component.get(i), (String)"get(...)");
                if (!(stack instanceof ItemStack)) continue;
                componentItems.put((Object)((ItemStack)stack).m_41720_(), i);
            }
        }
    }

    private final void handleMaterialEntry(GTRecipeBuilder builder, GTRecipeBuilder newBuilder, Object2IntOpenHashMap<Fluid> fluidMap, MaterialEntry entry, int count) {
        Material material = entry.material();
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"material(...)");
        Material material2 = material;
        TagPrefix tagPrefix = entry.tagPrefix();
        Intrinsics.checkNotNullExpressionValue((Object)tagPrefix, (String)"tagPrefix(...)");
        TagPrefix prefix = tagPrefix;
        if (prefix == TagPrefix.cableGtSingle) {
            TagPrefix tagPrefix2 = TagPrefix.cableGtSingle;
            Intrinsics.checkNotNullExpressionValue((Object)tagPrefix2, (String)"cableGtSingle");
            TagPrefix tagPrefix3 = TagPrefix.cableGtHex;
            Intrinsics.checkNotNullExpressionValue((Object)tagPrefix3, (String)"cableGtHex");
            this.conventPrefix(newBuilder, tagPrefix2, tagPrefix3, material2, count, 16);
            return;
        }
        if (prefix == TagPrefix.cableGtDouble) {
            TagPrefix tagPrefix4 = TagPrefix.cableGtDouble;
            Intrinsics.checkNotNullExpressionValue((Object)tagPrefix4, (String)"cableGtDouble");
            TagPrefix tagPrefix5 = TagPrefix.cableGtHex;
            Intrinsics.checkNotNullExpressionValue((Object)tagPrefix5, (String)"cableGtHex");
            this.conventPrefix(newBuilder, tagPrefix4, tagPrefix5, material2, count, 8);
            return;
        }
        if (prefix == TagPrefix.cableGtQuadruple) {
            TagPrefix tagPrefix6 = TagPrefix.cableGtQuadruple;
            Intrinsics.checkNotNullExpressionValue((Object)tagPrefix6, (String)"cableGtQuadruple");
            TagPrefix tagPrefix7 = TagPrefix.cableGtHex;
            Intrinsics.checkNotNullExpressionValue((Object)tagPrefix7, (String)"cableGtHex");
            this.conventPrefix(newBuilder, tagPrefix6, tagPrefix7, material2, count, 4);
            return;
        }
        if (prefix == TagPrefix.cableGtOctal) {
            TagPrefix tagPrefix8 = TagPrefix.cableGtOctal;
            Intrinsics.checkNotNullExpressionValue((Object)tagPrefix8, (String)"cableGtOctal");
            TagPrefix tagPrefix9 = TagPrefix.cableGtHex;
            Intrinsics.checkNotNullExpressionValue((Object)tagPrefix9, (String)"cableGtHex");
            this.conventPrefix(newBuilder, tagPrefix8, tagPrefix9, material2, count, 2);
            return;
        }
        if (builder.recipeType == GTRecipeTypes.ASSEMBLY_LINE_RECIPES) {
            this.conventPrefixToFluid(fluidMap, newBuilder, prefix, material2, count);
        } else {
            if (prefix == TagPrefix.rod) {
                TagPrefix tagPrefix10 = TagPrefix.rod;
                Intrinsics.checkNotNullExpressionValue((Object)tagPrefix10, (String)"rod");
                TagPrefix tagPrefix11 = TagPrefix.rodLong;
                Intrinsics.checkNotNullExpressionValue((Object)tagPrefix11, (String)"rodLong");
                this.conventPrefix(newBuilder, tagPrefix10, tagPrefix11, material2, count, 2);
                return;
            }
            if (prefix == TagPrefix.plate) {
                TagPrefix tagPrefix12 = TagPrefix.plate;
                Intrinsics.checkNotNullExpressionValue((Object)tagPrefix12, (String)"plate");
                TagPrefix tagPrefix13 = TagPrefix.plateDense;
                Intrinsics.checkNotNullExpressionValue((Object)tagPrefix13, (String)"plateDense");
                this.conventPrefix(newBuilder, tagPrefix12, tagPrefix13, material2, count, 9);
                return;
            }
            if (prefix == TagPrefix.gearSmall) {
                TagPrefix tagPrefix14 = TagPrefix.gearSmall;
                Intrinsics.checkNotNullExpressionValue((Object)tagPrefix14, (String)"gearSmall");
                TagPrefix tagPrefix15 = TagPrefix.gear;
                Intrinsics.checkNotNullExpressionValue((Object)tagPrefix15, (String)"gear");
                this.conventPrefix(newBuilder, tagPrefix14, tagPrefix15, material2, count, 4);
                return;
            }
            if (material2 == GTMaterials.Rubber || material2 == GTMaterials.SiliconeRubber || material2 == GTMaterials.StyreneButadieneRubber) {
                this.conventPrefixToFluid(fluidMap, newBuilder, prefix, material2, count);
                return;
            }
            newBuilder.inputItems(prefix, material2, count * 48);
        }
    }

    private final void conventPrefix(GTRecipeBuilder builder, TagPrefix originalPrefix, TagPrefix newPrefix, Material material, int count, int multiple) {
        ItemStack stack = ChemicalHelper.get((TagPrefix)newPrefix, (Material)material);
        GTRecipeBuilder gTRecipeBuilder = stack.m_41619_() ? builder.inputItems(originalPrefix, material, count * 48) : builder.inputItems(newPrefix, material, count * 48 / multiple);
    }

    private final void conventPrefixToFluid(Object2IntOpenHashMap<Fluid> fluidMap, GTRecipeBuilder builder, TagPrefix prefix, Material material, int count) {
        if (material.hasFluid() && prefix.materialAmount() != -1L) {
            int fluidCount = (int)prefix.materialAmount() / 25200;
            FluidStack fluidStack = material.getFluid(fluidCount * count * 48);
            Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"getFluid(...)");
            FluidStack fluid = fluidStack;
            v1 = fluidMap.addTo((Object)fluid.getFluid(), fluid.getAmount());
        } else {
            v1 = builder.inputItems(prefix, material, count * 48);
        }
    }

    private static final void handleComponent$lambda$1(GTRecipeBuilder $newBuilder, int $count, ItemStack stack) {
        ItemStack itemStack = stack;
        Intrinsics.checkNotNull((Object)itemStack);
        $newBuilder.inputItems(itemStack.m_255036_($count * 48));
    }

    private static final void handleComponent$lambda$2(GTRecipeBuilder $newBuilder, FluidIngredient fluidIngredient) {
        FluidIngredient fluidIngredient2 = fluidIngredient;
        Intrinsics.checkNotNull((Object)fluidIngredient2);
        FluidIngredient copy = fluidIngredient2.copy();
        copy.setAmount(copy.getAmount() * 48);
        FluidIngredient[] fluidIngredientArray = new FluidIngredient[]{copy};
        $newBuilder.inputFluids(fluidIngredientArray);
    }

    static {
        componentItems = new Object2IntLinkedOpenHashMap();
        recipeBuilders = new ArrayList();
        GTCraftingComponents.init();
        CraftingComponent[] craftingComponentArray = new CraftingComponent[]{GTCraftingComponents.MOTOR, GTCraftingComponents.PUMP, GTCraftingComponents.PISTON, GTCraftingComponents.CONVEYOR, GTCraftingComponents.ROBOT_ARM, GTCraftingComponents.FIELD_GENERATOR, GTCraftingComponents.EMITTER, GTCraftingComponents.SENSOR};
        craftComponents = craftingComponentArray;
        INSTANCE.initComponentList();
    }
}

