/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.extension;

import kotlin.Metadata;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\r\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005\u00a8\u0006\u000f"}, d2={"Ldev/arbor/gtnn/extension/ColorUtils;", "", "<init>", "()V", "mkHSBtoRGB", "", "hue", "", "saturation", "brightness", "mkRGBtoHSB", "", "color", "ARGB32", "ABGR32", "gtnn-1.20.1"})
public final class ColorUtils {
    @NotNull
    public static final ColorUtils INSTANCE = new ColorUtils();

    private ColorUtils() {
    }

    public final int mkHSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            r = g = (b = (int)(brightness * 255.0f + 0.5f));
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    @NotNull
    public final float[] mkRGBtoHSB(int color) {
        int cmin;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        float hue = 0.0f;
        float saturation = 0.0f;
        float brightness = 0.0f;
        int cmax = Math.max(r, g);
        if (b > cmax) {
            cmax = b;
        }
        if (b < (cmin = Math.min(r, g))) {
            cmin = b;
        }
        brightness = (float)cmax / 255.0f;
        saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        float[] fArray = new float[]{hue, saturation, brightness};
        return fArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J&\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005\u00a8\u0006\f"}, d2={"Ldev/arbor/gtnn/extension/ColorUtils$ABGR32;", "", "<init>", "()V", "alpha", "", "packedColor", "", "blue", "green", "red", "color", "gtnn-1.20.1"})
    public static final class ABGR32 {
        @NotNull
        public static final ABGR32 INSTANCE = new ABGR32();

        private ABGR32() {
        }

        public final float alpha(int packedColor) {
            return (float)FastColor.ABGR32.m_266503_((int)packedColor) / 255.0f;
        }

        public final float blue(int packedColor) {
            return (float)FastColor.ABGR32.m_266247_((int)packedColor) / 255.0f;
        }

        public final float green(int packedColor) {
            return (float)FastColor.ABGR32.m_266446_((int)packedColor) / 255.0f;
        }

        public final float red(int packedColor) {
            return (float)FastColor.ABGR32.m_266313_((int)packedColor) / 255.0f;
        }

        public final int color(float alpha, float blue, float green, float red) {
            return FastColor.ABGR32.m_266248_((int)((int)(alpha * (float)255)), (int)((int)(blue * (float)255)), (int)((int)(green * (float)255)), (int)((int)(red * (float)255)));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J&\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005\u00a8\u0006\f"}, d2={"Ldev/arbor/gtnn/extension/ColorUtils$ARGB32;", "", "<init>", "()V", "alpha", "", "packedColor", "", "red", "green", "blue", "color", "gtnn-1.20.1"})
    public static final class ARGB32 {
        @NotNull
        public static final ARGB32 INSTANCE = new ARGB32();

        private ARGB32() {
        }

        public final float alpha(int packedColor) {
            return (float)FastColor.ARGB32.m_13655_((int)packedColor) / 255.0f;
        }

        public final float red(int packedColor) {
            return (float)FastColor.ARGB32.m_13665_((int)packedColor) / 255.0f;
        }

        public final float green(int packedColor) {
            return (float)FastColor.ARGB32.m_13667_((int)packedColor) / 255.0f;
        }

        public final float blue(int packedColor) {
            return (float)FastColor.ARGB32.m_13669_((int)packedColor) / 255.0f;
        }

        public final int color(float alpha, float red, float green, float blue) {
            return FastColor.ARGB32.m_13660_((int)((int)(alpha * (float)255)), (int)((int)(red * (float)255)), (int)((int)(green * (float)255)), (int)((int)(blue * (float)255)));
        }
    }
}

