/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.extension;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.arbor.gtnn.extension.ColorUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0005J\u0006\u0010\t\u001a\u00020\u0005J\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u000e\u001a\u00020\u0005J\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u000b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Ldev/arbor/gtnn/extension/RenderOps;", "", "<init>", "()V", "bindTexture", "", "location", "Lnet/minecraft/resources/ResourceLocation;", "bindBlockAtlas", "setPositionShader", "setPositionColorShader", "positionColorTexShader", "getPositionColorTexShader", "()Lkotlin/Unit;", "setPositionTexShader", "setPositionTexColorShader", "setColor", "argb", "", "gtnn-1.20.1"})
public final class RenderOps {
    @NotNull
    public static final RenderOps INSTANCE = new RenderOps();

    private RenderOps() {
    }

    public final void bindTexture(@NotNull ResourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
    }

    public final void bindBlockAtlas() {
        ResourceLocation resourceLocation = InventoryMenu.f_39692_;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"BLOCK_ATLAS");
        this.bindTexture(resourceLocation);
    }

    public final void setPositionShader() {
        RenderSystem.setShader(RenderOps::setPositionShader$lambda$0);
    }

    public final void setPositionColorShader() {
        RenderSystem.setShader(RenderOps::setPositionColorShader$lambda$1);
    }

    @NotNull
    public final Unit getPositionColorTexShader() {
        RenderSystem.setShader(RenderOps::_get_positionColorTexShader_$lambda$2);
        return Unit.INSTANCE;
    }

    public final void setPositionTexShader() {
        RenderSystem.setShader(RenderOps::setPositionTexShader$lambda$3);
    }

    public final void setPositionTexColorShader() {
        RenderSystem.setShader(RenderOps::setPositionTexColorShader$lambda$4);
    }

    public final void setColor(int argb) {
        float r = ColorUtils.ARGB32.INSTANCE.red(argb);
        float g = ColorUtils.ARGB32.INSTANCE.green(argb);
        float b = ColorUtils.ARGB32.INSTANCE.blue(argb);
        float a = ColorUtils.ARGB32.INSTANCE.alpha(argb);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    private static final ShaderInstance setPositionShader$lambda$0() {
        return GameRenderer.m_172808_();
    }

    private static final ShaderInstance setPositionColorShader$lambda$1() {
        return GameRenderer.m_172811_();
    }

    private static final ShaderInstance _get_positionColorTexShader_$lambda$2() {
        return GameRenderer.m_172814_();
    }

    private static final ShaderInstance setPositionTexShader$lambda$3() {
        return GameRenderer.m_172817_();
    }

    private static final ShaderInstance setPositionTexColorShader$lambda$4() {
        return GameRenderer.m_172820_();
    }
}

