/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.extension;

import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.MultiblockShapeInfo;
import dev.arbor.gtnn.api.pattern.NNBlockPattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJE\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015JM\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\f\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\u0016\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0017JE\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\f\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H\u0002\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"Ldev/arbor/gtnn/extension/StructureUtil;", "", "<init>", "()V", "getMatchingShapes", "", "Lcom/gregtechceu/gtceu/api/pattern/MultiblockShapeInfo;", "blockPattern", "Ldev/arbor/gtnn/api/pattern/NNBlockPattern;", "maxIndex", "", "repetitionDFS", "pattern", "Lcom/gregtechceu/gtceu/api/pattern/BlockPattern;", "pages", "", "aisleRepetitions", "", "", "repetitionStack", "Ljava/util/Stack;", "(Lcom/gregtechceu/gtceu/api/pattern/BlockPattern;Ljava/util/List;[[ILjava/util/Stack;)Ljava/util/List;", "index", "(Ldev/arbor/gtnn/api/pattern/NNBlockPattern;Ljava/util/List;[[ILjava/util/Stack;I)Ljava/util/List;", "repetitionCandidates", "(Ldev/arbor/gtnn/api/pattern/NNBlockPattern;Ljava/util/List;[[ILjava/util/Stack;)Ljava/util/List;", "gtnn-1.20.1"})
public final class StructureUtil {
    @NotNull
    public static final StructureUtil INSTANCE = new StructureUtil();

    private StructureUtil() {
    }

    @NotNull
    public final List<MultiblockShapeInfo> getMatchingShapes(@NotNull NNBlockPattern blockPattern, int maxIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockPattern), (String)"blockPattern");
        int[][] aisleRepetitions = blockPattern.aisleRepetitions;
        List list = new ArrayList();
        Intrinsics.checkNotNull((Object)aisleRepetitions);
        List<MultiblockShapeInfo> pages = this.repetitionCandidates(blockPattern, list, aisleRepetitions, new Stack<Integer>());
        if (pages.size() < maxIndex) {
            int n = 0;
            int n2 = ((Object[])aisleRepetitions).length;
            int[] nArray = new int[n2];
            while (n < n2) {
                int n3 = n++;
                nArray[n3] = aisleRepetitions[n3][1];
            }
            int[] repetition = nArray;
            for (int i = pages.size(); i < maxIndex; ++i) {
                pages.add(new MultiblockShapeInfo(blockPattern.getPreview(repetition, i)));
            }
        }
        return pages;
    }

    private final List<MultiblockShapeInfo> repetitionDFS(BlockPattern pattern, List<MultiblockShapeInfo> pages, int[][] aisleRepetitions, Stack<Integer> repetitionStack) {
        if (repetitionStack.size() == ((Object[])aisleRepetitions).length) {
            int n = 0;
            int n2 = repetitionStack.size();
            int[] nArray = new int[n2];
            while (n < n2) {
                int n3 = n++;
                Object e = repetitionStack.get(n3);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                nArray[n3] = ((Number)e).intValue();
            }
            int[] repetition = nArray;
            pages.add(new MultiblockShapeInfo(pattern.getPreview(repetition)));
        } else {
            int n;
            int currentLevel = repetitionStack.size();
            int i = aisleRepetitions[currentLevel][0];
            if (i <= (n = aisleRepetitions[currentLevel][1])) {
                while (true) {
                    repetitionStack.push(i);
                    this.repetitionDFS(pattern, pages, aisleRepetitions, repetitionStack);
                    repetitionStack.pop();
                    if (i == n) break;
                    ++i;
                }
            }
        }
        return pages;
    }

    private final List<MultiblockShapeInfo> repetitionDFS(NNBlockPattern pattern, List<MultiblockShapeInfo> pages, int[][] aisleRepetitions, Stack<Integer> repetitionStack, int index) {
        if (repetitionStack.size() == ((Object[])aisleRepetitions).length) {
            int n = 0;
            int n2 = repetitionStack.size();
            int[] nArray = new int[n2];
            while (n < n2) {
                int n3 = n++;
                Object e = repetitionStack.get(n3);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                nArray[n3] = ((Number)e).intValue();
            }
            int[] repetition = nArray;
            pages.add(new MultiblockShapeInfo(pattern.getPreview(repetition, index)));
        } else {
            int n;
            int currentLevel = repetitionStack.size();
            int i = aisleRepetitions[currentLevel][0];
            if (i <= (n = aisleRepetitions[currentLevel][1])) {
                while (true) {
                    repetitionStack.push(i);
                    this.repetitionDFS(pattern, pages, aisleRepetitions, repetitionStack, index);
                    repetitionStack.pop();
                    if (i == n) break;
                    ++i;
                }
            }
        }
        return pages;
    }

    private final List<MultiblockShapeInfo> repetitionCandidates(NNBlockPattern pattern, List<MultiblockShapeInfo> pages, int[][] aisleRepetitions, Stack<Integer> repetitionStack) {
        if (repetitionStack.size() == ((Object[])aisleRepetitions).length) {
            int n = 0;
            int n2 = repetitionStack.size();
            int[] nArray = new int[n2];
            while (n < n2) {
                int n3 = n++;
                Object e = repetitionStack.get(n3);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                nArray[n3] = ((Number)e).intValue();
            }
            int[] repetition = nArray;
            pages.add(new MultiblockShapeInfo(pattern.getPreview(repetition, pages.size())));
        } else {
            int n;
            int currentLevel = repetitionStack.size();
            int i = aisleRepetitions[currentLevel][0];
            if (i <= (n = aisleRepetitions[currentLevel][1])) {
                while (true) {
                    repetitionStack.push(i);
                    this.repetitionCandidates(pattern, pages, aisleRepetitions, repetitionStack);
                    repetitionStack.pop();
                    if (i == n) break;
                    ++i;
                }
            }
        }
        return pages;
    }
}

