/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import dev.arbor.gtnn.GTNN;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={ChatComponent.class})
public class ChatMixin {
    @Shadow
    private int f_93763_;
    @Shadow
    @Final
    private List<GuiMessage.Line> f_93761_;
    @Unique
    private final ArrayList<Long> arborCore$messageTimestamps = new ArrayList();
    @Unique
    private final float arborCore$fadeOffsetYScale = 0.8f;
    @Unique
    private final float arborCore$fadeTime = 130.0f;
    @Unique
    private int arborCore$chatLineIndex;
    @Unique
    private int arborCore$chatDisplacementY = 0;

    @Shadow
    private int m_240691_() {
        return 0;
    }

    @Unique
    private void arborCore$calculateYOffset() {
        try {
            int lineHeight = this.m_240691_();
            float maxDisplacement = (float)lineHeight * 0.8f;
            long timestamp = this.arborCore$messageTimestamps.get(this.arborCore$chatLineIndex);
            long timeAlive = System.currentTimeMillis() - timestamp;
            if (this.arborCore$chatLineIndex == 0 && (float)timeAlive < 130.0f && this.f_93763_ == 0) {
                this.arborCore$chatDisplacementY = (int)(maxDisplacement - (float)timeAlive / 130.0f * maxDisplacement);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/GuiMessage$Line;addedTime()I")})
    public void getChatLineIndex(CallbackInfo ci, @Local(ordinal=13) int chatLineIndex) {
        this.arborCore$chatLineIndex = chatLineIndex;
    }

    @ModifyArg(method={"render"}, index=1, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V", ordinal=1))
    private float applyYOffset(float y) {
        if (GTNN.getClientConfig().addChatAnimation) {
            this.arborCore$calculateYOffset();
        }
        return y + (float)this.arborCore$chatDisplacementY;
    }

    @ModifyVariable(method={"render"}, ordinal=3, at=@At(value="STORE"))
    private double modifyOpacity(double originalOpacity) {
        double opacity = originalOpacity;
        if (GTNN.getClientConfig().addChatAnimation) {
            try {
                long timestamp = this.arborCore$messageTimestamps.get(this.arborCore$chatLineIndex);
                long timeAlive = System.currentTimeMillis() - timestamp;
                if ((float)timeAlive < 130.0f && this.f_93763_ == 0) {
                    opacity *= 0.5 + (double)(Mth.m_14036_((float)((float)timeAlive / 130.0f), (float)0.0f, (float)1.0f) / 2.0f);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return opacity;
    }

    @ModifyVariable(method={"render"}, at=@At(value="STORE"))
    private GuiMessageTag removeMessageIndicator(GuiMessageTag messageIndicator) {
        if (!GTNN.getClientConfig().addChatAnimation) {
            return messageIndicator;
        }
        return null;
    }

    @Inject(method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;ILnet/minecraft/client/GuiMessageTag;Z)V"}, at={@At(value="TAIL")})
    private void addMessage(Component message, MessageSignature signature, int ticks, GuiMessageTag indicator, boolean refresh, CallbackInfo ci) {
        if (GTNN.getClientConfig().addChatAnimation) {
            this.arborCore$messageTimestamps.add(0, System.currentTimeMillis());
            while (this.arborCore$messageTimestamps.size() > this.f_93761_.size()) {
                this.arborCore$messageTimestamps.remove(this.arborCore$messageTimestamps.size() - 1);
            }
        }
    }
}

