/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.gtnn.mixin.gt;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.IWorldGenLayer;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreGenerator;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.config.ConfigHolder;
import dev.arbor.gtnn.GTNN;
import dev.arbor.gtnn.api.vein.VeinConfiguration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={OreGenerator.class}, remap=false)
public abstract class OreGeneratorMixin {
    @Unique
    @NotNull
    private static Optional<BlockPos> gtnn$computeVeinOrigin(WorldGenLevel level, ChunkGenerator generator, RandomSource random, BlockPos veinCenter, GTOreDefinition entry) {
        int layerSeed = WorldGeneratorUtils.getWorldGenLayerKey((IWorldGenLayer)entry.layer()).map(String::hashCode).orElse(0);
        XoroshiroRandomSource layeredRandom = new XoroshiroRandomSource(random.m_188505_() ^ (long)layerSeed);
        return entry.range().m_213676_(new PlacementContext(level, generator, Optional.empty()), (RandomSource)layeredRandom, veinCenter).findFirst();
    }

    @Unique
    private static VeinConfiguration gtnn$logVeinGeneration(VeinConfiguration config) {
        if (ConfigHolder.INSTANCE.dev.debugWorldgen) {
            GTCEu.LOGGER.debug("Generating vein {} at {}", (Object)config.data().id(), (Object)config.data().center());
        }
        return config;
    }

    @Unique
    private static Optional<BlockPos> gtnn$getVeinCenter(ChunkPos chunkPos) {
        int gridSize = ConfigHolder.INSTANCE.worldgen.oreVeins.oreVeinGridSize;
        if (chunkPos.f_45578_ % gridSize == 0 && chunkPos.f_45579_ % gridSize == 0) {
            BlockPos chunkCenter = chunkPos.m_151394_(0);
            return Optional.of(chunkCenter);
        }
        return Optional.empty();
    }

    @Inject(method={"generateMetadata"}, at={@At(value="HEAD")}, cancellable=true)
    private void generateMetadata(WorldGenLevel level, ChunkGenerator chunkGenerator, ChunkPos chunkPos, CallbackInfoReturnable<List<GeneratedVeinMetadata>> cir) {
        if (GTNN.getServerConfig().timesOreVeins != 1) {
            cir.setReturnValue(this.gtnn$createConfigs(level, chunkGenerator, chunkPos).stream().map(OreGeneratorMixin::gtnn$logVeinGeneration).map(VeinConfiguration::data).toList());
        }
    }

    @Shadow
    protected abstract Stream<GTOreDefinition> getEntries(WorldGenLevel var1, BlockPos var2, XoroshiroRandomSource var3);

    @Unique
    private List<VeinConfiguration> gtnn$createConfigs(WorldGenLevel level, ChunkGenerator generator, ChunkPos chunkPos) {
        ArrayList<VeinConfiguration> list = new ArrayList<VeinConfiguration>();
        HashSet oreVeins = new HashSet();
        for (int i = 0; i < GTNN.getServerConfig().timesOreVeins; ++i) {
            XoroshiroRandomSource random = new XoroshiroRandomSource(level.m_7328_() ^ chunkPos.m_45588_() + (long)i);
            list.addAll(OreGeneratorMixin.gtnn$getVeinCenter(chunkPos).stream().flatMap(veinCenter -> {
                List<GTOreDefinition> oreVeinList = this.getEntries(level, (BlockPos)veinCenter, random).toList();
                while (oreVeins.containsAll(oreVeinList)) {
                    oreVeinList = this.getEntries(level, (BlockPos)veinCenter, new XoroshiroRandomSource(random.m_188505_())).toList();
                }
                oreVeins.addAll(oreVeinList);
                return oreVeinList.stream().map(entry -> {
                    ResourceLocation id = (ResourceLocation)GTRegistries.ORE_VEINS.getKey(entry);
                    if (entry == null) {
                        return null;
                    }
                    BlockPos origin = OreGeneratorMixin.gtnn$computeVeinOrigin(level, generator, (RandomSource)random, veinCenter, entry).orElseThrow(() -> new IllegalStateException("Cannot determine y coordinate for the vein at " + veinCenter));
                    return new VeinConfiguration(new GeneratedVeinMetadata(id, chunkPos, origin, entry), (RandomSource)random);
                });
            }).toList());
        }
        return list;
    }
}

