/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.basics;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mrbysco.constructionstick.ConstructionStick;
import mrbysco.constructionstick.config.ConstructionConfig;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ReplacementRegistry {
    private static final HashSet<HashSet<Item>> replacements = new HashSet();

    public static void init() {
        replacements.clear();
        for (String key : (List)ConstructionConfig.SIMILAR_BLOCKS.get()) {
            if (!(key instanceof String)) continue;
            HashSet<Item> set = new HashSet<Item>();
            for (String id : key.split(";")) {
                Item item = (Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.tryParse((String)id));
                if (item == null || item == Items.AIR) {
                    ConstructionStick.LOGGER.warn("Replacement Registry: Could not find item {}", (Object)id);
                    continue;
                }
                set.add(item);
            }
            if (set.isEmpty()) continue;
            replacements.add(set);
        }
    }

    public static Set<Item> getMatchingSet(Item item) {
        HashSet<Item> res = new HashSet<Item>();
        for (HashSet<Item> set : replacements) {
            if (!set.contains(item)) continue;
            res.addAll(set);
        }
        res.remove(item);
        return res;
    }

    public static boolean matchBlocks(Block b1, Block b2) {
        if (b1 == b2) {
            return true;
        }
        if (b1 == Blocks.AIR || b2 == Blocks.AIR) {
            return false;
        }
        for (HashSet<Item> set : replacements) {
            if (!set.contains(b1.asItem()) || !set.contains(b2.asItem())) continue;
            return true;
        }
        return false;
    }
}

