/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.client;

import mrbysco.constructionstick.ConstructionStick;
import mrbysco.constructionstick.basics.StickUtil;
import mrbysco.constructionstick.basics.option.StickOptions;
import mrbysco.constructionstick.client.StickScreen;
import mrbysco.constructionstick.network.PacketQueryUndo;
import mrbysco.constructionstick.network.PacketStickOption;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

@EventBusSubscriber(value={Dist.CLIENT})
public class KeybindHandler {
    public static KeyMapping.Category CATEGORY = new KeyMapping.Category(ConstructionStick.modLoc("category"));
    public static final KeyMapping KEY_CHANGE_RESTRICTION = new KeyMapping(KeybindHandler.getKey("change_restriction"), -1, CATEGORY);
    public static final KeyMapping KEY_CHANGE_UPGRADE = new KeyMapping(KeybindHandler.getKey("change_upgrade"), -1, CATEGORY);
    public static final KeyMapping KEY_CHANGE_DIRECTION = new KeyMapping(KeybindHandler.getKey("change_direction"), -1, CATEGORY);
    public static final KeyMapping KEY_OPEN_GUI = new KeyMapping(KeybindHandler.getKey("open_gui"), -1, CATEGORY);
    public static final KeyMapping KEY_UNDO = new KeyMapping(KeybindHandler.getKey("undo"), -1, CATEGORY);
    public static final KeyMapping KEY_SHOW_PREVIOUS = new KeyMapping(KeybindHandler.getKey("show_previous"), -1, CATEGORY);
    private static boolean undoPressed;

    private static String getKey(String name) {
        return String.join((CharSequence)".", "key", "constructionstick", name);
    }

    public KeybindHandler() {
        undoPressed = false;
    }

    @SubscribeEvent
    public static void KeyEvent(InputEvent.Key event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (StickUtil.holdingStick((Player)player) == null) {
            return;
        }
        boolean undoDown = KEY_UNDO.isDown();
        if (undoPressed != undoDown) {
            undoPressed = undoDown;
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new PacketQueryUndo(undoPressed), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        StickOptions stickOptions;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (StickUtil.holdingStick((Player)player) == null) {
            return;
        }
        ItemStack stick = player.getItemInHand(player.getUsedItemHand());
        if (KEY_CHANGE_UPGRADE.consumeClick()) {
            stickOptions = new StickOptions(stick);
            stickOptions.upgrades.next();
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new PacketStickOption(stickOptions.upgrades, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (KEY_CHANGE_RESTRICTION.consumeClick()) {
            stickOptions = new StickOptions(stick);
            stickOptions.lock.next();
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new PacketStickOption(stickOptions.lock, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (KEY_CHANGE_DIRECTION.consumeClick()) {
            stickOptions = new StickOptions(stick);
            stickOptions.direction.next();
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new PacketStickOption(stickOptions.direction, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (KEY_OPEN_GUI.consumeClick()) {
            Minecraft.getInstance().setScreen((Screen)new StickScreen(stick));
        }
    }
}

