/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Set;
import mrbysco.constructionstick.basics.StickUtil;
import mrbysco.constructionstick.client.KeybindHandler;
import mrbysco.constructionstick.items.stick.ItemStick;
import mrbysco.constructionstick.stick.StickJob;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.client.renderer.state.BlockOutlineRenderState;
import net.minecraft.client.renderer.state.LevelRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.CustomBlockOutlineRenderer;
import net.neoforged.neoforge.client.event.ExtractBlockOutlineRenderStateEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class RenderBlockPreview {
    private static StickJob stickJob;
    public static Set<BlockPos> undoBlocks;

    @SubscribeEvent
    public static void onExtractBlockOutlineRenderStateEvent(ExtractBlockOutlineRenderStateEvent event) {
        event.addCustomRenderer((CustomBlockOutlineRenderer)new PreviewRender(event.getHitResult(), event.getCamera()));
    }

    public static void reset() {
        stickJob = null;
    }

    private static boolean compareRTR(BlockHitResult rtr1, BlockHitResult rtr2) {
        return rtr1.getBlockPos().equals((Object)rtr2.getBlockPos()) && rtr1.getDirection().equals((Object)rtr2.getDirection());
    }

    private static class PreviewRender
    implements CustomBlockOutlineRenderer {
        private final BlockHitResult target;
        private final Camera camera;

        public PreviewRender(BlockHitResult hitResult, Camera camera) {
            this.target = hitResult;
            this.camera = camera;
        }

        public boolean render(BlockOutlineRenderState renderState, MultiBufferSource.BufferSource buffer, PoseStack poseStack, boolean translucentPass, LevelRenderState levelRenderState) {
            Set<BlockPos> blocks;
            Entity entity = this.camera.getEntity();
            if (!(entity instanceof Player)) {
                return false;
            }
            Player player = (Player)entity;
            float colorR = 0.0f;
            float colorG = 0.0f;
            float colorB = 0.0f;
            ItemStack stick = StickUtil.holdingStick(player);
            if (stick == null) {
                return false;
            }
            if (!KeybindHandler.KEY_SHOW_PREVIOUS.isDown()) {
                if (stickJob == null || !RenderBlockPreview.compareRTR(RenderBlockPreview.stickJob.blockHitResult, this.target) || !RenderBlockPreview.stickJob.stick.equals(stick) || stickJob.blockCount() < 2) {
                    stickJob = ItemStick.getStickJob(player, player.level(), this.target, stick);
                }
                blocks = stickJob.getBlockPositions();
            } else {
                blocks = undoBlocks;
                colorG = 1.0f;
            }
            if (blocks == null || blocks.isEmpty()) {
                return false;
            }
            VertexConsumer lineBuilder = buffer.getBuffer((RenderType)RenderType.LINES);
            double d0 = this.camera.getPosition().x();
            double d1 = this.camera.getPosition().y();
            double d2 = this.camera.getPosition().z();
            for (BlockPos block : blocks) {
                AABB aabb = new AABB(block).move(-d0, -d1, -d2);
                ShapeRenderer.renderLineBox((PoseStack.Pose)poseStack.last(), (VertexConsumer)lineBuilder, (AABB)aabb, (float)colorR, (float)colorG, (float)colorB, (float)0.4f);
            }
            return true;
        }
    }
}

