/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.containers.handlers;

import mrbysco.constructionstick.api.IContainerHandler;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class HandlerCapability
implements IContainerHandler {
    @Override
    public boolean matches(Player player, ItemStack itemStack, ItemStack inventoryStack) {
        return inventoryStack != null && inventoryStack.getCapability(Capabilities.Item.ITEM, null) != null;
    }

    @Override
    public int countItems(Player player, ItemStack itemStack, ItemStack inventoryStack) {
        ResourceHandler resourceHandler = (ResourceHandler)inventoryStack.getCapability(Capabilities.Item.ITEM, null);
        if (resourceHandler == null) {
            return 0;
        }
        int total = 0;
        for (int i = 0; i < resourceHandler.size(); ++i) {
            ItemResource containerResource = (ItemResource)resourceHandler.getResource(i);
            if (containerResource.isEmpty() || !containerResource.matches(itemStack)) continue;
            total += Math.max(0, resourceHandler.getAmountAsInt(i));
        }
        return total;
    }

    @Override
    public int useItems(Player player, ItemStack itemStack, ItemStack inventoryStack, int count) {
        ResourceHandler resourceHandler = (ResourceHandler)inventoryStack.getCapability(Capabilities.Item.ITEM, null);
        if (resourceHandler == null) {
            return 0;
        }
        try (Transaction tx = Transaction.openRoot();){
            int extracted;
            ItemResource handlerResource;
            int initialCount = count;
            for (int i = 0; i < resourceHandler.size() && ((handlerResource = (ItemResource)resourceHandler.getResource(i)).isEmpty() || !handlerResource.matches(itemStack) || (extracted = resourceHandler.extract(i, (Resource)handlerResource, count, (TransactionContext)tx)) <= 0 || (count -= extracted) > 0); ++i) {
            }
            if (initialCount != count) {
                tx.commit();
            }
            int n = count;
            return n;
        }
    }
}

