/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.data.client;

import java.util.ArrayList;
import mrbysco.constructionstick.ConstructionStick;
import mrbysco.constructionstick.client.property.SelectStickUpgrade;
import mrbysco.constructionstick.items.stick.ItemStick;
import mrbysco.constructionstick.registry.ModItems;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.SelectItemModel;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class ModelGenerator
extends ModelProvider {
    public static final ModelTemplate TWO_LAYERED_HANDHELD = ModelTemplates.createItem((String)"handheld", (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0, TextureSlot.LAYER1});

    public ModelGenerator(PackOutput output) {
        super(output, "constructionstick");
    }

    protected void registerModels(@NotNull BlockModelGenerators blockModels, @NotNull ItemModelGenerators itemModels) {
        for (DeferredHolder deferredHolder : ModItems.ITEMS.getEntries()) {
            Item item = (Item)deferredHolder.get();
            String name = deferredHolder.getId().getPath();
            if (item instanceof ItemStick) {
                this.generateStick(itemModels, item);
                continue;
            }
            if (item instanceof BlockItem) {
                blockModels.registerSimpleItemModel(item, ConstructionStick.modLoc("block/" + name));
                continue;
            }
            itemModels.generateFlatItem(item, ModelTemplates.FLAT_ITEM);
        }
    }

    private void generateStick(ItemModelGenerators itemModels, Item item) {
        ResourceLocation location = ModelLocationUtils.getModelLocation((Item)item);
        ItemModel.Unbaked model = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel(item, ModelTemplates.FLAT_HANDHELD_ITEM));
        ItemModel.Unbaked angelModel = ItemModelUtils.plainModel((ResourceLocation)this.generateLayeredItem(itemModels, location.withSuffix("_angel"), ModelLocationUtils.getModelLocation((Item)item), ConstructionStick.modLoc("item/overlay_angel")));
        ItemModel.Unbaked destructionModel = ItemModelUtils.plainModel((ResourceLocation)this.generateLayeredItem(itemModels, location.withSuffix("_destruction"), ModelLocationUtils.getModelLocation((Item)item), ConstructionStick.modLoc("item/overlay_destruction")));
        ArrayList<SelectItemModel.SwitchCase> list = new ArrayList<SelectItemModel.SwitchCase>(1);
        list.add(ItemModelUtils.when((Object)"angel", (ItemModel.Unbaked)angelModel));
        list.add(ItemModelUtils.when((Object)"destruction", (ItemModel.Unbaked)destructionModel));
        itemModels.itemModelOutput.accept(item, ItemModelUtils.select((SelectItemModelProperty)new SelectStickUpgrade(), (ItemModel.Unbaked)model, list));
    }

    public ResourceLocation generateLayeredItem(ItemModelGenerators itemModels, ResourceLocation modelLocation, ResourceLocation layer0, ResourceLocation layer1) {
        return TWO_LAYERED_HANDHELD.create(modelLocation, TextureMapping.layered((ResourceLocation)layer0, (ResourceLocation)layer1), itemModels.modelOutput);
    }
}

