/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.data.server;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import mrbysco.constructionstick.ConstructionStick;
import mrbysco.constructionstick.basics.ModTags;
import mrbysco.constructionstick.registry.ModItems;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.ClientAsset;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.data.advancements.AdvancementSubProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredHolder;

public class AdvancementGenerator
extends AdvancementProvider {
    public AdvancementGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, List.of(new StickAdvancementGenerator()));
    }

    public static class StickAdvancementGenerator
    implements AdvancementSubProvider {
        public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> consumer) {
            AdvancementHolder root = Advancement.Builder.advancement().display(StickAdvancementGenerator.rootDisplay(ModItems.STICK_WOODEN, StickAdvancementGenerator.advancementPrefix("root.title"), StickAdvancementGenerator.advancementPrefix("root.desc"), StickAdvancementGenerator.mcLoc("textures/block/oak_planks.png"))).addCriterion("stick", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of((HolderGetter)registries.lookupOrThrow(Registries.ITEM), Tags.Items.RODS_WOODEN)})).save(consumer, StickAdvancementGenerator.rootID("root"));
            AdvancementHolder sticks = StickAdvancementGenerator.onHasItems(registries, consumer, ModItems.STICK_IRON, ModTags.CONSTRUCTION_STICKS, AdvancementType.TASK, root);
            AdvancementHolder angelTemplate = StickAdvancementGenerator.onHasItems(consumer, ModItems.TEMPLATE_ANGEL, AdvancementType.TASK, sticks);
            AdvancementHolder destructionTemplate = StickAdvancementGenerator.onHasItems(consumer, ModItems.TEMPLATE_DESTRUCTION, AdvancementType.TASK, sticks);
            AdvancementHolder replacementTemplate = StickAdvancementGenerator.onHasItems(consumer, ModItems.TEMPLATE_REPLACEMENT, AdvancementType.TASK, sticks);
            AdvancementHolder unbreakableTemplate = StickAdvancementGenerator.onHasItems(consumer, ModItems.TEMPLATE_UNBREAKABLE, AdvancementType.TASK, sticks);
            AdvancementHolder batteryTemplate = StickAdvancementGenerator.onHasItems(consumer, ModItems.TEMPLATE_BATTERY, AdvancementType.TASK, sticks);
        }

        protected static AdvancementHolder onHasItems(Consumer<AdvancementHolder> consumer, DeferredHolder<Item, ? extends Item> iconItem, AdvancementType type, AdvancementHolder root) {
            String path = iconItem.getId().getPath();
            ResourceLocation registryLocation = StickAdvancementGenerator.modLoc(path);
            DisplayInfo info = StickAdvancementGenerator.simpleDisplay((ItemLike)iconItem.get(), path, type);
            return Advancement.Builder.advancement().display(info).parent(root).addCriterion(path, StickAdvancementGenerator.hasItemsTrigger((ItemLike)iconItem.get())).save(consumer, StickAdvancementGenerator.rootID(registryLocation.getPath()));
        }

        protected static Criterion<InventoryChangeTrigger.TriggerInstance> hasItemsTrigger(ItemLike ... items) {
            return InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])items);
        }

        protected static AdvancementHolder onHasItems(HolderLookup.Provider registries, Consumer<AdvancementHolder> consumer, DeferredHolder<Item, ? extends Item> iconItem, TagKey<Item> itemTag, AdvancementType type, AdvancementHolder root) {
            String path = iconItem.getId().getPath();
            ResourceLocation registryLocation = StickAdvancementGenerator.modLoc(path);
            DisplayInfo info = StickAdvancementGenerator.simpleDisplay((ItemLike)iconItem.get(), path, type);
            return Advancement.Builder.advancement().display(info).parent(root).addCriterion(path, StickAdvancementGenerator.hasItemsTrigger(registries, itemTag)).save(consumer, StickAdvancementGenerator.rootID(registryLocation.getPath()));
        }

        protected static Criterion<InventoryChangeTrigger.TriggerInstance> hasItemsTrigger(HolderLookup.Provider registries, TagKey<Item> itemTag) {
            return InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of((HolderGetter)registries.lookupOrThrow(Registries.ITEM), itemTag)});
        }

        protected static DisplayInfo rootDisplay(ItemLike icon, String titleKey, String descKey, ResourceLocation background) {
            return new DisplayInfo(new ItemStack(icon), (Component)Component.translatable((String)titleKey), (Component)Component.translatable((String)descKey), Optional.of(new ClientAsset.ResourceTexture(background)), AdvancementType.TASK, false, false, false);
        }

        protected static DisplayInfo simpleDisplay(ItemLike icon, String name, AdvancementType type) {
            return new DisplayInfo(new ItemStack(icon), (Component)Component.translatable((String)StickAdvancementGenerator.advancementPrefix(name + ".title")), (Component)Component.translatable((String)StickAdvancementGenerator.advancementPrefix(name + ".desc")), Optional.empty(), type, true, true, false);
        }

        private static ResourceLocation modLoc(String path) {
            return ConstructionStick.modLoc(path);
        }

        private static ResourceLocation mcLoc(String path) {
            return ResourceLocation.withDefaultNamespace((String)path);
        }

        private static String advancementPrefix(String name) {
            return "advancement.constructionstick." + name;
        }

        private static String rootID(String name) {
            return StickAdvancementGenerator.modLoc(name).toString();
        }
    }
}

