/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.data.server;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import mrbysco.constructionstick.data.server.recipe.IngredientPredicate;
import mrbysco.constructionstick.data.server.recipe.SmithingApplyUpgradeRecipeBuilder;
import mrbysco.constructionstick.items.stick.ItemStick;
import mrbysco.constructionstick.items.template.ItemUpgradeTemplate;
import mrbysco.constructionstick.registry.ModDataComponents;
import mrbysco.constructionstick.registry.ModItems;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredItem;

public class RecipeGenerator
extends RecipeProvider {
    public RecipeGenerator(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
        super(provider, recipeOutput);
    }

    protected void buildRecipes() {
        this.stickRecipe(this.output, (ItemLike)ModItems.STICK_WOODEN.get(), IngredientPredicate.fromTag(this.registries, (TagKey<Item>)Tags.Items.RODS_WOODEN));
        this.stickRecipe(this.output, (ItemLike)ModItems.STICK_COPPER.get(), IngredientPredicate.fromTag(this.registries, (TagKey<Item>)Tags.Items.INGOTS_COPPER));
        this.stickRecipe(this.output, (ItemLike)ModItems.STICK_IRON.get(), IngredientPredicate.fromTag(this.registries, (TagKey<Item>)Tags.Items.INGOTS_IRON));
        this.stickRecipe(this.output, (ItemLike)ModItems.STICK_DIAMOND.get(), IngredientPredicate.fromTag(this.registries, (TagKey<Item>)Tags.Items.GEMS_DIAMOND));
        this.stickRecipe(this.output, (ItemLike)ModItems.STICK_NETHERITE.get(), IngredientPredicate.fromTag(this.registries, (TagKey<Item>)Tags.Items.INGOTS_NETHERITE));
        this.templateRecipe(this.output, (ItemLike)ModItems.TEMPLATE_ANGEL.get(), IngredientPredicate.fromTag(this.registries, (TagKey<Item>)Tags.Items.FEATHERS), IngredientPredicate.fromTag(this.registries, (TagKey<Item>)Tags.Items.INGOTS_GOLD));
        this.templateRecipe(this.output, (ItemLike)ModItems.TEMPLATE_DESTRUCTION.get(), IngredientPredicate.fromItem(this.registries, (ItemLike)Items.TNT), IngredientPredicate.fromItem(this.registries, (ItemLike)Items.DIAMOND_PICKAXE));
        this.templateRecipe(this.output, (ItemLike)ModItems.TEMPLATE_REPLACEMENT.get(), IngredientPredicate.fromTag(this.registries, (TagKey<Item>)Tags.Items.ENDER_PEARLS), IngredientPredicate.fromItem(this.registries, (ItemLike)Items.SCULK));
        this.templateRecipe(this.output, (ItemLike)ModItems.TEMPLATE_UNBREAKABLE.get(), IngredientPredicate.fromTag(this.registries, (TagKey<Item>)Tags.Items.NETHER_STARS), IngredientPredicate.fromTag(this.registries, (TagKey<Item>)Tags.Items.OBSIDIANS_CRYING));
        this.templateRecipe(this.output, (ItemLike)ModItems.TEMPLATE_BATTERY.get(), IngredientPredicate.fromItem(this.registries, (ItemLike)Items.POTATO), IngredientPredicate.fromTag(this.registries, (TagKey<Item>)Tags.Items.DUSTS_REDSTONE));
        this.templateUpgradeRecipe(this.output, (DeferredItem<? extends ItemUpgradeTemplate>)ModItems.TEMPLATE_ANGEL, IngredientPredicate.fromTag(this.registries, (TagKey<Item>)Tags.Items.FEATHERS), (Supplier)ModDataComponents.ANGEL, true);
        this.templateUpgradeRecipe(this.output, (DeferredItem<? extends ItemUpgradeTemplate>)ModItems.TEMPLATE_DESTRUCTION, IngredientPredicate.fromTag(this.registries, (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_REDSTONE), (Supplier)ModDataComponents.DESTRUCTION, true);
        this.templateUpgradeRecipe(this.output, ModItems.TEMPLATE_REPLACEMENT, IngredientPredicate.fromTag(this.registries, (TagKey<Item>)Tags.Items.ENDER_PEARLS), ModDataComponents.REPLACEMENT, true);
        this.templateUpgradeRecipe(this.output, (DeferredItem<? extends ItemUpgradeTemplate>)ModItems.TEMPLATE_UNBREAKABLE, IngredientPredicate.fromTag(this.registries, (TagKey<Item>)Tags.Items.OBSIDIANS_CRYING), (Supplier)ModDataComponents.UNBREAKABLE, true);
        this.templateUpgradeRecipe(this.output, (DeferredItem<? extends ItemUpgradeTemplate>)ModItems.TEMPLATE_BATTERY, IngredientPredicate.fromTag(this.registries, (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COPPER), (Supplier)ModDataComponents.BATTERY_ENABLED, true);
    }

    private void stickRecipe(RecipeOutput output, ItemLike stick, IngredientPredicate material) {
        this.shaped(RecipeCategory.TOOLS, stick).define(Character.valueOf('X'), material.ingredient()).define(Character.valueOf('#'), Tags.Items.RODS_WOODEN).pattern("  X").pattern(" # ").pattern("#  ").unlockedBy("has_item", RecipeGenerator.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{material.predicate()})).save(output);
    }

    private <T> void templateUpgradeRecipe(RecipeOutput output, DeferredItem<? extends ItemUpgradeTemplate> template, IngredientPredicate item1, Supplier<DataComponentType<T>> component, T defaultValue) {
        for (DeferredItem<ItemStick> stickHolder : ModItems.STICKS) {
            ItemStack stack = stickHolder.toStack();
            stack.set(component, defaultValue);
            SmithingApplyUpgradeRecipeBuilder.smithing(Ingredient.of((ItemLike)((ItemLike)template.get())), Ingredient.of(stickHolder), item1.ingredient(), RecipeCategory.TOOLS, stack, ((ItemUpgradeTemplate)template.get()).getRegistryName()).unlocks("has_template", this.has((ItemLike)template.get())).unlocks("has_stick", this.has((ItemLike)template.get())).unlocks("has_addition", RecipeGenerator.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{item1.predicate()})).save(output, template.getId().withPrefix("smithing_upgrade/" + stickHolder.getId().getPath() + "_with_"));
        }
    }

    private void templateRecipe(RecipeOutput output, ItemLike template, IngredientPredicate item1, IngredientPredicate item2) {
        this.shaped(RecipeCategory.MISC, template).define(Character.valueOf('O'), item1.ingredient()).define(Character.valueOf('X'), item2.ingredient()).define(Character.valueOf('#'), Tags.Items.GLASS_BLOCKS).pattern(" #X").pattern("#O#").pattern("X# ").unlockedBy("has_item", RecipeGenerator.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{item1.predicate()})).save(output);
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> completableFuture) {
            super(output, completableFuture);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
            return new RecipeGenerator(provider, recipeOutput);
        }

        public String getName() {
            return "Construction Sticks Recipes";
        }
    }
}

