/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.items.stick;

import java.text.NumberFormat;
import java.util.function.Consumer;
import mrbysco.constructionstick.ConstructionStick;
import mrbysco.constructionstick.api.IStickTemplate;
import mrbysco.constructionstick.basics.StickUtil;
import mrbysco.constructionstick.basics.option.IOption;
import mrbysco.constructionstick.basics.option.StickOptions;
import mrbysco.constructionstick.basics.option.StickUpgradesSelectable;
import mrbysco.constructionstick.config.ConstructionConfig;
import mrbysco.constructionstick.registry.ModDataComponents;
import mrbysco.constructionstick.stick.StickJob;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ItemStick
extends Item {
    public ItemStick(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        Level level = context.getLevel();
        if (level.isClientSide() || player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (ConstructionStick.undoHistory.isUndoActive(player)) {
            return ConstructionStick.undoHistory.undo(player, level, context.getClickedPos()) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        StickJob job = ItemStick.getStickJob(player, level, new BlockHitResult(context.getClickLocation(), context.getClickedFace(), context.getClickedPos(), false), stack);
        return job.doIt() ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    @NotNull
    public InteractionResult use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!player.isCrouching()) {
            if (level.isClientSide()) {
                return InteractionResult.FAIL;
            }
            StickJob job = ItemStick.getStickJob(player, level, BlockHitResult.miss((Vec3)player.getLookAngle(), (Direction)StickUtil.fromVector(player.getLookAngle()), (BlockPos)player.blockPosition()), stack);
            return job.doIt() ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    public static StickJob getStickJob(Player player, Level level, @Nullable BlockHitResult rayTraceResult, ItemStack stick) {
        StickJob stickJob = new StickJob(player, level, rayTraceResult, stick);
        stickJob.getSnapshots();
        return stickJob;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return false;
    }

    public int remainingDurability(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    public void hurtItem(ItemStack stack, int amount, LivingEntity entity, EquipmentSlot slot) {
        if (stack.has(ModDataComponents.BATTERY_ENABLED)) {
            if (entity.hasInfiniteMaterials()) {
                return;
            }
            EnergyHandler storage = (EnergyHandler)stack.getCapability(Capabilities.Energy.ITEM, null);
            if (storage != null) {
                int usage = ConstructionConfig.getStickProperties(this).getBatteryUsage();
                try (Transaction tx = Transaction.openRoot();){
                    if (storage.extract(usage, (TransactionContext)tx) != usage) {
                        return;
                    }
                    tx.commit();
                }
            }
        } else {
            stack.hurtAndBreak(amount, entity, slot);
        }
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        super.inventoryTick(stack, level, entity, slot);
        if (stack.has(ModDataComponents.UNBREAKABLE) && !stack.has(DataComponents.UNBREAKABLE)) {
            stack.set(DataComponents.UNBREAKABLE, (Object)Unit.INSTANCE);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> components, TooltipFlag flag) {
        StickOptions options = new StickOptions(stack);
        int limit = ((IStickTemplate)options.upgrades.get()).getStickAction().getLimit(stack);
        String langTooltip = "constructionstick.tooltip.";
        if (flag.hasShiftDown()) {
            for (int i = 1; i < options.allOptions.length; ++i) {
                IOption<?> opt = options.allOptions[i];
                components.accept((Component)Component.translatable((String)opt.getKeyTranslation()).withStyle(ChatFormatting.AQUA).append((Component)Component.translatable((String)opt.getValueTranslation()).withStyle(ChatFormatting.GRAY)));
            }
            if (!options.upgrades.getUpgrades().isEmpty()) {
                components.accept((Component)Component.literal((String)""));
                components.accept((Component)Component.translatable((String)(langTooltip + "upgrades")).withStyle(ChatFormatting.GRAY));
                for (IStickTemplate upgrades : options.upgrades.getUpgrades()) {
                    components.accept((Component)Component.translatable((String)(options.upgrades.getKeyTranslation() + "." + upgrades.getRegistryName().toString())));
                }
                for (IStickTemplate specialUpgrades : options.upgrades.getSpecialUpgrades()) {
                    components.accept((Component)Component.translatable((String)(options.upgrades.getKeyTranslation() + "." + specialUpgrades.getRegistryName().toString())));
                }
            }
        } else {
            EnergyHandler storage;
            StickUpgradesSelectable<IStickTemplate> upgrades = options.upgrades;
            components.accept((Component)Component.translatable((String)(langTooltip + "blocks"), (Object[])new Object[]{limit}).withStyle(ChatFormatting.GRAY));
            if (stack.has(ModDataComponents.BATTERY_ENABLED) && (storage = (EnergyHandler)stack.getCapability(Capabilities.Energy.ITEM, null)) != null) {
                int energy = storage.getAmountAsInt();
                NumberFormat format = NumberFormat.getInstance();
                components.accept((Component)Component.translatable((String)"constructionstick.tooltip.storage", (Object[])new Object[]{format.format(energy), format.format(storage.getCapacityAsInt())}).withStyle(ChatFormatting.RED));
            }
            components.accept((Component)Component.translatable((String)upgrades.getKeyTranslation()).withStyle(ChatFormatting.AQUA).append((Component)Component.translatable((String)upgrades.getValueTranslation()).withStyle(ChatFormatting.WHITE)));
            components.accept((Component)Component.translatable((String)(langTooltip + "shift")).withStyle(ChatFormatting.AQUA));
        }
    }

    public static void optionMessage(Player player, IOption<?> option) {
        player.displayClientMessage((Component)Component.translatable((String)option.getKeyTranslation()).withStyle(ChatFormatting.AQUA).append((Component)Component.translatable((String)option.getValueTranslation()).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" - ").withStyle(ChatFormatting.GRAY)).append((Component)Component.translatable((String)option.getDescTranslation()).withStyle(ChatFormatting.WHITE)), true);
    }
}

