/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.items.stick;

import mrbysco.constructionstick.config.ConstructionConfig;
import mrbysco.constructionstick.items.stick.ItemStick;
import mrbysco.constructionstick.registry.ModDataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;

public class ItemStickBasic
extends ItemStick {
    public ItemStickBasic(Item.Properties properties, ToolMaterial tier) {
        super(properties.durability(tier.durability()).repairable(tier.repairItems()));
    }

    public boolean isDamageable(ItemStack stack) {
        return !stack.has(ModDataComponents.UNBREAKABLE) && super.isDamageable(stack);
    }

    public boolean isBarVisible(ItemStack stack) {
        return super.isBarVisible(stack) || stack.has(ModDataComponents.BATTERY);
    }

    public int getBarWidth(ItemStack stack) {
        EnergyHandler storage;
        if (stack.has(ModDataComponents.BATTERY_ENABLED) && (storage = (EnergyHandler)stack.getCapability(Capabilities.Energy.ITEM, null)) != null) {
            return Math.round(13.0f / (float)storage.getCapacityAsInt() * (float)storage.getAmountAsInt());
        }
        return super.getBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        if (stack.has(ModDataComponents.BATTERY_ENABLED)) {
            return 9901575;
        }
        return super.getBarColor(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return ConstructionConfig.getStickProperties(this).getDurability();
    }

    @Override
    public int remainingDurability(ItemStack stack) {
        EnergyHandler storage;
        if (stack.has(ModDataComponents.UNBREAKABLE)) {
            return Integer.MAX_VALUE;
        }
        if (stack.has(ModDataComponents.BATTERY_ENABLED) && (storage = (EnergyHandler)stack.getCapability(Capabilities.Energy.ITEM, null)) != null) {
            int usage = ConstructionConfig.getStickProperties(this).getBatteryUsage();
            return storage.getAmountAsInt() / usage;
        }
        return stack.getMaxDamage() - stack.getDamageValue();
    }
}

