/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.network;

import mrbysco.constructionstick.ConstructionStick;
import mrbysco.constructionstick.basics.StickUtil;
import mrbysco.constructionstick.basics.option.IOption;
import mrbysco.constructionstick.basics.option.StickOptions;
import mrbysco.constructionstick.items.stick.ItemStick;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketStickOption(String key, String value, boolean notifyMessage) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketStickOption> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, option -> option.key, (StreamCodec)ByteBufCodecs.STRING_UTF8, option -> option.value, (StreamCodec)ByteBufCodecs.BOOL, option -> option.notifyMessage, PacketStickOption::new);
    public static final CustomPacketPayload.Type<PacketStickOption> ID = new CustomPacketPayload.Type(ConstructionStick.modLoc("stick_option"));

    public PacketStickOption(IOption<?> option, boolean notify) {
        this(option.getKey(), option.getValueString(), notify);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static class Handler {
        public static void handle(PacketStickOption msg, IPayloadContext ctx) {
            ctx.enqueueWork(() -> {
                Player patt0$temp;
                if (ctx.flow().isServerbound() && (patt0$temp = ctx.player()) instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    ItemStack stick = StickUtil.holdingStick((Player)player);
                    if (stick == null) {
                        return;
                    }
                    StickOptions options = new StickOptions(stick);
                    IOption<?> option = options.get(msg.key);
                    if (option == null) {
                        return;
                    }
                    option.setValueString(msg.value);
                    if (msg.notifyMessage) {
                        ItemStick.optionMessage((Player)player, option);
                    }
                    player.getInventory().setChanged();
                }
            }).exceptionally(e -> {
                ctx.disconnect((Component)Component.translatable((String)"constructionstick.networking.stick_option.failed", (Object[])new Object[]{e.getMessage()}));
                return null;
            });
        }
    }
}

