/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.network;

import java.util.HashSet;
import java.util.Set;
import mrbysco.constructionstick.ConstructionStick;
import mrbysco.constructionstick.client.RenderBlockPreview;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketUndoBlocks(HashSet<BlockPos> undoBlocks) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, PacketUndoBlocks> CODEC = CustomPacketPayload.codec(PacketUndoBlocks::encode, PacketUndoBlocks::new);
    public static final CustomPacketPayload.Type<PacketUndoBlocks> ID = new CustomPacketPayload.Type(ConstructionStick.modLoc("undo_blocks"));

    public PacketUndoBlocks(FriendlyByteBuf buffer) {
        this(PacketUndoBlocks.getSet(buffer));
    }

    public PacketUndoBlocks(Set<BlockPos> undoBlocks) {
        this(new HashSet<BlockPos>(undoBlocks));
    }

    private static HashSet<BlockPos> getSet(FriendlyByteBuf buffer) {
        HashSet<BlockPos> undoBlocks = new HashSet<BlockPos>();
        while (buffer.isReadable()) {
            undoBlocks.add(buffer.readBlockPos());
        }
        return undoBlocks;
    }

    public void encode(FriendlyByteBuf buffer) {
        for (BlockPos pos : this.undoBlocks) {
            buffer.writeBlockPos(pos);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static class Handler {
        public static void handle(PacketUndoBlocks msg, IPayloadContext ctx) {
            ctx.enqueueWork(() -> {
                RenderBlockPreview.undoBlocks = msg.undoBlocks;
            }).exceptionally(e -> {
                ctx.disconnect((Component)Component.translatable((String)"constructionstick.networking.undo_blocks.failed", (Object[])new Object[]{e.getMessage()}));
                return null;
            });
        }
    }
}

