/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mrbysco.constructionstick.api.IStickTemplate;
import mrbysco.constructionstick.basics.StickUtil;
import mrbysco.constructionstick.basics.option.StickOptions;
import mrbysco.constructionstick.config.ConstructionConfig;
import mrbysco.constructionstick.registry.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SmithingRecipeDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SmithingApplyUpgradeRecipe
implements SmithingRecipe {
    final Ingredient template;
    final Ingredient base;
    final Ingredient addition;
    final ItemStack result;
    final IStickTemplate upgrade;
    @Nullable
    private PlacementInfo placementInfo;

    public SmithingApplyUpgradeRecipe(Ingredient template, Ingredient base, Ingredient addition, ItemStack result, IStickTemplate upgrade) {
        this.template = template;
        this.base = base;
        this.addition = addition;
        this.result = result;
        this.upgrade = upgrade;
    }

    public SmithingApplyUpgradeRecipe(Ingredient template, Ingredient base, Ingredient addition, ItemStack result, ResourceLocation upgrade) {
        this(template, base, addition, result, StickUtil.getUpgrade(upgrade).orElseThrow(() -> new IllegalArgumentException("Unknown upgrade: " + String.valueOf(upgrade))));
    }

    public boolean matches(SmithingRecipeInput input, Level level) {
        ItemStack base = input.base();
        if (base.has(this.upgrade.getStickComponent()) || !new StickOptions((ItemStack)base).upgrades.isCompatible(this.upgrade) || !ConstructionConfig.getStickProperties(base.getItem()).isUpgradeable()) {
            return false;
        }
        return this.template.test(input.template()) && this.base.test(base) && this.addition.test(input.addition());
    }

    public ItemStack assemble(SmithingRecipeInput input, HolderLookup.Provider registries) {
        ItemStack resultStack = this.getResult();
        ItemStack itemstack = input.base().transmuteCopy((ItemLike)resultStack.getItem(), resultStack.getCount());
        itemstack.applyComponents(resultStack.getComponentsPatch());
        return itemstack;
    }

    public ItemStack getResult() {
        return this.result.copy();
    }

    public Optional<Ingredient> templateIngredient() {
        return Optional.of(this.template);
    }

    public Ingredient baseIngredient() {
        return this.base;
    }

    public Optional<Ingredient> additionIngredient() {
        return Optional.of(this.addition);
    }

    public RecipeSerializer<SmithingApplyUpgradeRecipe> getSerializer() {
        return ModRecipes.SMITHING_UPGRADE.get();
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.createFromOptionals(List.of(this.templateIngredient(), Optional.of(this.baseIngredient()), this.additionIngredient()));
        }
        return this.placementInfo;
    }

    public List<RecipeDisplay> display() {
        return List.of(new SmithingRecipeDisplay(Ingredient.optionalIngredientToDisplay(Optional.of(this.template)), Ingredient.optionalIngredientToDisplay(Optional.of(this.base)), Ingredient.optionalIngredientToDisplay(Optional.of(this.addition)), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(this.result), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(Items.SMITHING_TABLE)));
    }

    public static class Serializer
    implements RecipeSerializer<SmithingApplyUpgradeRecipe> {
        private static final MapCodec<SmithingApplyUpgradeRecipe> CODEC = RecordCodecBuilder.mapCodec(p_340782_ -> p_340782_.group((App)Ingredient.CODEC.fieldOf("template").forGetter(p_301310_ -> p_301310_.template), (App)Ingredient.CODEC.fieldOf("base").forGetter(p_300938_ -> p_300938_.base), (App)Ingredient.CODEC.fieldOf("addition").forGetter(p_301153_ -> p_301153_.addition), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_300935_ -> p_300935_.result), (App)ResourceLocation.CODEC.fieldOf("upgrade").forGetter(p_300935_ -> p_300935_.upgrade.getRegistryName())).apply((Applicative)p_340782_, SmithingApplyUpgradeRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SmithingApplyUpgradeRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<SmithingApplyUpgradeRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, SmithingApplyUpgradeRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static SmithingApplyUpgradeRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient ingredient1 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient ingredient2 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            ResourceLocation upgrade = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer);
            return new SmithingApplyUpgradeRecipe(ingredient, ingredient1, ingredient2, itemstack, upgrade);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, SmithingApplyUpgradeRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.template);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.base);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.addition);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)recipe.upgrade.getRegistryName());
        }
    }
}

