/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.registry;

import java.util.List;
import java.util.function.Supplier;
import mrbysco.constructionstick.config.ConstructionConfig;
import mrbysco.constructionstick.items.stick.ItemStick;
import mrbysco.constructionstick.items.stick.ItemStickBasic;
import mrbysco.constructionstick.items.template.ItemAngelTemplate;
import mrbysco.constructionstick.items.template.ItemBatteryTemplate;
import mrbysco.constructionstick.items.template.ItemDestructionTemplate;
import mrbysco.constructionstick.items.template.ItemReplacementTemplate;
import mrbysco.constructionstick.items.template.ItemUnbreakableTemplate;
import mrbysco.constructionstick.items.template.ItemUpgradeTemplate;
import mrbysco.constructionstick.registry.ModDataComponents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.energy.ItemAccessEnergyHandler;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

@EventBusSubscriber(modid="constructionstick")
public class ModItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"constructionstick");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"constructionstick");
    public static final DeferredItem<ItemStick> STICK_WOODEN = ITEMS.registerItem("wooden_stick", properties -> new ItemStickBasic((Item.Properties)properties, ToolMaterial.WOOD));
    public static final DeferredItem<ItemStick> STICK_COPPER = ITEMS.registerItem("copper_stick", properties -> new ItemStickBasic((Item.Properties)properties, ToolMaterial.STONE));
    public static final DeferredItem<ItemStick> STICK_IRON = ITEMS.registerItem("iron_stick", properties -> new ItemStickBasic((Item.Properties)properties, ToolMaterial.IRON));
    public static final DeferredItem<ItemStick> STICK_DIAMOND = ITEMS.registerItem("diamond_stick", properties -> new ItemStickBasic((Item.Properties)properties, ToolMaterial.DIAMOND));
    public static final DeferredItem<ItemStick> STICK_NETHERITE = ITEMS.registerItem("netherite_stick", properties -> new ItemStickBasic((Item.Properties)properties, ToolMaterial.NETHERITE), properties -> properties.fireResistant());
    public static final DeferredItem<ItemUpgradeTemplate> TEMPLATE_ANGEL = ITEMS.registerItem("template_angel", ItemAngelTemplate::new, properties -> properties.stacksTo(1));
    public static final DeferredItem<ItemUpgradeTemplate> TEMPLATE_DESTRUCTION = ITEMS.registerItem("template_destruction", ItemDestructionTemplate::new, properties -> properties.stacksTo(1));
    public static final DeferredItem<ItemUpgradeTemplate> TEMPLATE_REPLACEMENT = ITEMS.registerItem("template_replacement", ItemReplacementTemplate::new, properties -> properties.stacksTo(1));
    public static final DeferredItem<ItemUpgradeTemplate> TEMPLATE_UNBREAKABLE = ITEMS.registerItem("template_unbreakable", ItemUnbreakableTemplate::new, properties -> properties.stacksTo(1));
    public static final DeferredItem<ItemUpgradeTemplate> TEMPLATE_BATTERY = ITEMS.registerItem("template_battery", ItemBatteryTemplate::new, properties -> properties.stacksTo(1));
    public static final List<DeferredItem<ItemStick>> STICKS = List.of(STICK_WOODEN, STICK_COPPER, STICK_IRON, STICK_DIAMOND, STICK_NETHERITE);
    public static final List<DeferredItem<ItemUpgradeTemplate>> TEMPLATES = List.of(TEMPLATE_ANGEL, TEMPLATE_DESTRUCTION, TEMPLATE_REPLACEMENT, TEMPLATE_UNBREAKABLE, TEMPLATE_BATTERY);
    public static final Supplier<CreativeModeTab> CONSTRUCTION_TAB = CREATIVE_MODE_TABS.register("tab", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)STICK_WOODEN.get())).withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).title((Component)Component.translatable((String)"itemGroup.constructionstick.tab")).displayItems((displayParameters, output) -> {
        List<ItemStack> stacks = ITEMS.getEntries().stream().map(reg -> new ItemStack((ItemLike)reg.get())).toList();
        output.acceptAll(stacks);
    }).build());

    @SubscribeEvent
    public static void addCreative(BuildCreativeModeTabContentsEvent event) {
        block3: {
            block2: {
                if (event.getTabKey() != CreativeModeTabs.TOOLS_AND_UTILITIES) break block2;
                for (DeferredItem<ItemStick> itemSupplier : STICKS) {
                    event.accept(itemSupplier);
                }
                break block3;
            }
            if (event.getTabKey() != CreativeModeTabs.INGREDIENTS) break block3;
            for (DeferredItem<ItemUpgradeTemplate> itemSupplier : TEMPLATES) {
                event.accept(itemSupplier);
            }
        }
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        for (DeferredHolder deferredHolder : STICKS) {
            event.registerItem(Capabilities.Energy.ITEM, (stack, access) -> {
                ConstructionConfig.StickProperties properties = ConstructionConfig.getStickProperties((Item)holder.get());
                return new ItemAccessEnergyHandler((ItemAccess)access, (DataComponentType)ModDataComponents.BATTERY.get(), properties.getBatteryStorage(), 200, properties.getBatteryUsage(), (ItemStack)stack){
                    final /* synthetic */ ItemStack val$stack;
                    {
                        this.val$stack = itemStack;
                        super(arg0, arg1, arg2, arg3, arg4);
                    }

                    public int extract(int amount, TransactionContext transaction) {
                        if (this.val$stack.has(ModDataComponents.BATTERY_ENABLED)) {
                            return 0;
                        }
                        return super.extract(amount, transaction);
                    }

                    public int insert(int amount, TransactionContext transaction) {
                        if (this.val$stack.has(ModDataComponents.BATTERY_ENABLED)) {
                            return 0;
                        }
                        return super.insert(amount, transaction);
                    }
                };
            }, new ItemLike[]{(ItemLike)deferredHolder.get()});
        }
    }
}

