/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.stick.action;

import java.util.LinkedList;
import java.util.List;
import mrbysco.constructionstick.api.IStickAction;
import mrbysco.constructionstick.api.IStickSupplier;
import mrbysco.constructionstick.basics.StickUtil;
import mrbysco.constructionstick.basics.option.StickOptions;
import mrbysco.constructionstick.config.ConstructionConfig;
import mrbysco.constructionstick.stick.undo.ISnapshot;
import mrbysco.constructionstick.stick.undo.PlaceSnapshot;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ActionAngel
implements IStickAction {
    @Override
    public int getLimit(ItemStack stick) {
        return ConstructionConfig.getStickProperties(stick.getItem()).getAngel();
    }

    @Override
    @NotNull
    public List<ISnapshot> getSnapshots(Level level, Player player, BlockHitResult blockHitResult, ItemStack stick, StickOptions options, IStickSupplier supplier, int limit) {
        LinkedList<ISnapshot> placeSnapshots = new LinkedList<ISnapshot>();
        Direction placeDirection = blockHitResult.getDirection();
        BlockPos currentPos = blockHitResult.getBlockPos();
        BlockState supportingBlock = level.getBlockState(currentPos);
        for (int i = 0; i < limit; ++i) {
            PlaceSnapshot snapshot = supplier.getPlaceSnapshot(level, currentPos = currentPos.offset(placeDirection.getOpposite().getUnitVec3i()), blockHitResult, supportingBlock);
            if (snapshot == null) continue;
            placeSnapshots.add(snapshot);
            break;
        }
        return placeSnapshots;
    }

    @Override
    @NotNull
    public List<ISnapshot> getSnapshotsFromAir(Level level, Player player, BlockHitResult blockHitResult, ItemStack stick, StickOptions options, IStickSupplier supplier, int limit) {
        Vec3 lookVec;
        LinkedList<ISnapshot> placeSnapshots = new LinkedList<ISnapshot>();
        if (!player.isCreative() && !((Boolean)ConstructionConfig.ANGEL_FALLING.get()).booleanValue() && player.fallDistance > 10.0) {
            return placeSnapshots;
        }
        Vec3 playerVec = StickUtil.entityPositionVec((Entity)player);
        Vec3 placeVec = playerVec.add(lookVec = player.getLookAngle().multiply(2.0, 2.0, 2.0));
        BlockPos currentPos = StickUtil.posFromVec(placeVec);
        PlaceSnapshot snapshot = supplier.getPlaceSnapshot(level, currentPos, blockHitResult, null);
        if (snapshot != null) {
            placeSnapshots.add(snapshot);
        }
        return placeSnapshots;
    }
}

