/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.stick.action;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import mrbysco.constructionstick.api.IStickAction;
import mrbysco.constructionstick.api.IStickSupplier;
import mrbysco.constructionstick.basics.StickUtil;
import mrbysco.constructionstick.basics.option.StickOptions;
import mrbysco.constructionstick.config.ConstructionConfig;
import mrbysco.constructionstick.stick.undo.DestroySnapshot;
import mrbysco.constructionstick.stick.undo.ISnapshot;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class ActionDestruction
implements IStickAction {
    @Override
    public int getLimit(ItemStack stick) {
        return ConstructionConfig.getStickProperties(stick.getItem()).getDestruction();
    }

    @Override
    @NotNull
    public List<ISnapshot> getSnapshots(Level level, Player player, BlockHitResult blockHitResult, ItemStack stick, StickOptions options, IStickSupplier supplier, int limit) {
        LinkedList<ISnapshot> destroySnapshots = new LinkedList<ISnapshot>();
        LinkedList<BlockPos> candidates = new LinkedList<BlockPos>();
        HashSet<BlockPos> allCandidates = new HashSet<BlockPos>();
        Direction breakFace = blockHitResult.getDirection();
        BlockPos startingPoint = blockHitResult.getBlockPos();
        BlockState targetBlock = level.getBlockState(blockHitResult.getBlockPos());
        if (breakFace == Direction.UP || breakFace == Direction.DOWN) {
            if (options.testLock(StickOptions.LOCK.NORTHSOUTH) || options.testLock(StickOptions.LOCK.EASTWEST)) {
                candidates.add(startingPoint);
            }
        } else if (options.testLock(StickOptions.LOCK.HORIZONTAL) || options.testLock(StickOptions.LOCK.VERTICAL)) {
            candidates.add(startingPoint);
        }
        while (!candidates.isEmpty() && destroySnapshots.size() < limit) {
            BlockPos currentCandidate = (BlockPos)candidates.removeFirst();
            if (!StickUtil.isBlockPermeable(level, currentCandidate.offset(breakFace.getUnitVec3i()))) continue;
            try {
                DestroySnapshot snapshot;
                BlockState candidateBlock = level.getBlockState(currentCandidate);
                if (!options.matchBlocks(targetBlock.getBlock(), candidateBlock.getBlock()) || !allCandidates.add(currentCandidate) || (snapshot = DestroySnapshot.get(level, player, currentCandidate)) == null) continue;
                destroySnapshots.add(snapshot);
                switch (breakFace) {
                    case DOWN: 
                    case UP: {
                        if (options.testLock(StickOptions.LOCK.NORTHSOUTH)) {
                            candidates.add(currentCandidate.offset(Direction.NORTH.getUnitVec3i()));
                            candidates.add(currentCandidate.offset(Direction.SOUTH.getUnitVec3i()));
                        }
                        if (options.testLock(StickOptions.LOCK.EASTWEST)) {
                            candidates.add(currentCandidate.offset(Direction.EAST.getUnitVec3i()));
                            candidates.add(currentCandidate.offset(Direction.WEST.getUnitVec3i()));
                        }
                        if (!options.testLock(StickOptions.LOCK.NORTHSOUTH) || !options.testLock(StickOptions.LOCK.EASTWEST)) break;
                        candidates.add(currentCandidate.offset(Direction.NORTH.getUnitVec3i()).offset(Direction.EAST.getUnitVec3i()));
                        candidates.add(currentCandidate.offset(Direction.NORTH.getUnitVec3i()).offset(Direction.WEST.getUnitVec3i()));
                        candidates.add(currentCandidate.offset(Direction.SOUTH.getUnitVec3i()).offset(Direction.EAST.getUnitVec3i()));
                        candidates.add(currentCandidate.offset(Direction.SOUTH.getUnitVec3i()).offset(Direction.WEST.getUnitVec3i()));
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        if (options.testLock(StickOptions.LOCK.HORIZONTAL)) {
                            candidates.add(currentCandidate.offset(Direction.EAST.getUnitVec3i()));
                            candidates.add(currentCandidate.offset(Direction.WEST.getUnitVec3i()));
                        }
                        if (options.testLock(StickOptions.LOCK.VERTICAL)) {
                            candidates.add(currentCandidate.offset(Direction.UP.getUnitVec3i()));
                            candidates.add(currentCandidate.offset(Direction.DOWN.getUnitVec3i()));
                        }
                        if (!options.testLock(StickOptions.LOCK.HORIZONTAL) || !options.testLock(StickOptions.LOCK.VERTICAL)) break;
                        candidates.add(currentCandidate.offset(Direction.UP.getUnitVec3i()).offset(Direction.EAST.getUnitVec3i()));
                        candidates.add(currentCandidate.offset(Direction.UP.getUnitVec3i()).offset(Direction.WEST.getUnitVec3i()));
                        candidates.add(currentCandidate.offset(Direction.DOWN.getUnitVec3i()).offset(Direction.EAST.getUnitVec3i()));
                        candidates.add(currentCandidate.offset(Direction.DOWN.getUnitVec3i()).offset(Direction.WEST.getUnitVec3i()));
                        break;
                    }
                    case EAST: 
                    case WEST: {
                        if (options.testLock(StickOptions.LOCK.HORIZONTAL)) {
                            candidates.add(currentCandidate.offset(Direction.NORTH.getUnitVec3i()));
                            candidates.add(currentCandidate.offset(Direction.SOUTH.getUnitVec3i()));
                        }
                        if (options.testLock(StickOptions.LOCK.VERTICAL)) {
                            candidates.add(currentCandidate.offset(Direction.UP.getUnitVec3i()));
                            candidates.add(currentCandidate.offset(Direction.DOWN.getUnitVec3i()));
                        }
                        if (!options.testLock(StickOptions.LOCK.HORIZONTAL) || !options.testLock(StickOptions.LOCK.VERTICAL)) break;
                        candidates.add(currentCandidate.offset(Direction.UP.getUnitVec3i()).offset(Direction.NORTH.getUnitVec3i()));
                        candidates.add(currentCandidate.offset(Direction.UP.getUnitVec3i()).offset(Direction.SOUTH.getUnitVec3i()));
                        candidates.add(currentCandidate.offset(Direction.DOWN.getUnitVec3i()).offset(Direction.NORTH.getUnitVec3i()));
                        candidates.add(currentCandidate.offset(Direction.DOWN.getUnitVec3i()).offset(Direction.SOUTH.getUnitVec3i()));
                    }
                }
            }
            catch (Exception exception) {}
        }
        return destroySnapshots;
    }

    @Override
    @NotNull
    public List<ISnapshot> getSnapshotsFromAir(Level level, Player player, BlockHitResult blockHitResult, ItemStack stick, StickOptions options, IStickSupplier supplier, int limit) {
        return new ArrayList<ISnapshot>();
    }
}

