/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.stick.undo;

import mrbysco.constructionstick.basics.StickUtil;
import mrbysco.constructionstick.stick.undo.ISnapshot;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class DestroySnapshot
implements ISnapshot {
    private final BlockState block;
    private final BlockPos pos;

    public DestroySnapshot(BlockState block, BlockPos pos) {
        this.pos = pos;
        this.block = block;
    }

    @Nullable
    public static DestroySnapshot get(Level level, Player player, BlockPos pos) {
        if (!StickUtil.isBlockRemovable(level, player, pos)) {
            return null;
        }
        return new DestroySnapshot(level.getBlockState(pos), pos);
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public BlockState getBlockState() {
        return this.block;
    }

    @Override
    public ItemStack getRequiredItems() {
        return ItemStack.EMPTY;
    }

    @Override
    public boolean execute(Level level, Player player, BlockHitResult blockHitResult) {
        return StickUtil.removeBlock(level, player, this.block, this.pos);
    }

    @Override
    public boolean canRestore(Level level, Player player) {
        if (!level.isInWorldBounds(this.pos)) {
            return false;
        }
        if (!level.mayInteract((Entity)player, this.pos)) {
            return false;
        }
        if (player.isCreative()) {
            return true;
        }
        if (!level.isEmptyBlock(this.pos) && !level.getBlockState(this.pos).canBeReplaced(Fluids.EMPTY)) {
            return false;
        }
        return !StickUtil.entitiesCollidingWithBlock(level, this.block, this.pos);
    }

    @Override
    public boolean restore(Level level, Player player) {
        return StickUtil.placeBlock(level, player, this.block, this.pos, null);
    }

    @Override
    public void forceRestore(Level level) {
        level.setBlockAndUpdate(this.pos, this.block);
    }
}

